/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk.model;

import android.util.Log;
import com.fillr.browsersdk.utilities.FillrUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FillrMapping {
    private static final String TAG = "Fill Mapping";
    private static final String USERNAME = "Usernames.Username.Username";
    private static final String PERSONAL_DETAILS_HONORIFIC = "PersonalDetails.Honorific";
    private static final String PERSONAL_DETAILS_GENDER = "PersonalDetails.Gender";
    private static final String CREDIT_CARDS_CREDIT_CARD_TYPE = "CreditCards.CreditCard.Type";
    private static final String CREDIT_CARDS_CREDIT_CARD = "CreditCards.CreditCard";
    private static final String BIRTH_DATE_DAY = "PersonalDetails.BirthDate.Day";
    private static final String BIRTH_DATE_MONTH = "PersonalDetails.BirthDate.Month";
    private static final String BIRTH_DATE_YEAR = "PersonalDetails.BirthDate.Year";
    private static final String BIRTH_DATE = "PersonalDetails.BirthDate";
    private static final int INDEX_USERNAME = 0;
    private static final int INDEX_EMAIL = 1;
    private final JSONObject formMetaData;
    private final List<String> fields;
    private Map<String, String> profileData;
    private Map<String, Integer> fieldSelections;
    private long startTime;
    private static final String[] DEMOGRAPHY_KEYS = new String[]{"PersonalDetails.Honorific", "PersonalDetails.Gender", "CreditCards.CreditCard.Type", "PersonalDetails.BirthDate.Day", "PersonalDetails.BirthDate.Month", "PersonalDetails.BirthDate.Year"};

    public FillrMapping(JSONObject mappingResult, List<String> fields) {
        this.formMetaData = mappingResult;
        this.fields = fields;
    }

    public JSONObject getFormMappings() {
        return this.getFormMappings(false);
    }

    public JSONObject getFormMappings(boolean applyFieldSelections) {
        return applyFieldSelections ? this.applyFieldSelectionsToMappings() : this.formMetaData;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public Map<String, Integer> getFieldSelections() {
        if (this.fieldSelections != null) {
            return this.fieldSelections;
        }
        String payload = this.getProfileData();
        HashMap<String, Integer> defaultSelections = new HashMap<String, Integer>();
        defaultSelections.put(USERNAME, payload != null && payload.contains(USERNAME) ? 0 : 1);
        return defaultSelections;
    }

    public void setFieldSelections(Map<String, Integer> selections) {
        this.fieldSelections = selections;
    }

    public void setProfileData(Map<String, String> profileData) {
        this.profileData = profileData;
    }

    public String getProfileData() {
        if (this.profileData != null) {
            JSONObject profileData = new JSONObject();
            for (Map.Entry<String, String> data : this.profileData.entrySet()) {
                try {
                    profileData.put(data.getKey(), (Object)data.getValue());
                }
                catch (JSONException e) {
                    Log.e((String)TAG, (String)e.getMessage());
                }
            }
            return profileData.toString();
        }
        return null;
    }

    public String getDemographyDataForHeadlessFill() {
        JSONObject retValue = new JSONObject();
        if (this.profileData != null) {
            for (String key : DEMOGRAPHY_KEYS) {
                if (!this.profileData.containsKey(key)) continue;
                try {
                    retValue.put(key, (Object)this.profileData.get(key));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            int age = this.getAge(this.profileData);
            if (age > 0) {
                try {
                    retValue.put("PersonalDetails.Age", age);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        return retValue.toString();
    }

    private int getAge(Map<String, String> profileData) {
        int retVal = 0;
        SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy", Locale.ENGLISH);
        if (profileData.containsKey(BIRTH_DATE_DAY) && profileData.containsKey(BIRTH_DATE_MONTH) && profileData.containsKey(BIRTH_DATE_YEAR)) {
            try {
                String day = profileData.get(BIRTH_DATE_DAY);
                String month = profileData.get(BIRTH_DATE_MONTH);
                String year = profileData.get(BIRTH_DATE_YEAR);
                Date birthDate = df.parse(day + "-" + month + "-" + year);
                retVal = this.getDateDifference(birthDate);
            }
            catch (ParseException e) {
                Log.e((String)this.getClass().getName(), (String)e.getMessage());
            }
        } else if (profileData.containsKey(BIRTH_DATE)) {
            String birthday = profileData.get(BIRTH_DATE);
            try {
                Date birthDate = df.parse(birthday);
                retVal = this.getDateDifference(birthDate);
            }
            catch (ParseException e) {
                Log.e((String)this.getClass().getName(), (String)e.getMessage());
            }
        }
        return retVal;
    }

    public int getNumberOfCreditCardFields() {
        int ccFieldsCount = 0;
        for (String field : this.fields) {
            if (!field.startsWith(CREDIT_CARDS_CREDIT_CARD)) continue;
            ++ccFieldsCount;
        }
        return ccFieldsCount;
    }

    private int getDateDifference(Date birthDate) {
        Calendar brithdayInstance = Calendar.getInstance();
        brithdayInstance.setTime(birthDate);
        return Calendar.getInstance().get(1) - brithdayInstance.get(1);
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean hasFields() {
        return this.fields != null && this.fields.size() > 0;
    }

    public boolean hasProfileData() {
        return this.profileData != null && this.profileData.size() > 0;
    }

    private JSONObject applyFieldSelectionsToMappings() {
        Map<String, Integer> elementSelections = this.getFieldSelections();
        if (elementSelections == null || this.formMetaData == null) {
            return this.formMetaData;
        }
        JSONObject sourceMappings = this.formMetaData;
        try {
            sourceMappings = new JSONObject(sourceMappings.toString());
            JSONArray fields = sourceMappings.getJSONArray("fields");
            for (int index = 0; index < fields.length(); ++index) {
                List<String> fieldParams;
                int targetIndex;
                JSONObject field = fields.getJSONObject(index);
                if (!elementSelections.containsKey(field.getString("param")) || (targetIndex = elementSelections.get(field.getString("param")).intValue()) >= (fieldParams = FillrUtils.jsonToList(field.getJSONArray("params"))).size()) continue;
                String param = fieldParams.get(targetIndex);
                JSONArray newParams = new JSONArray();
                newParams.put((Object)param);
                field.put("param", (Object)param);
                field.put("params", (Object)newParams);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sourceMappings;
    }
}

