/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk.model;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import com.fillr.browsersdk.EmbeddedBrowser;
import com.fillr.browsersdk.analytics.FillrAnalyticsManager;
import com.fillr.browsersdk.utilities.FillrUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class FillrIntentBuilder {
    private static final String EXTRA_KEY_FIELDS = "com.fillr.jsonfields";
    private static final String EXTRA_KEY_DEV_KEY = "com.fillr.devkey";
    private static final String EXTRA_KEY_SECRET_KEY = "com.fillr.secretkey";
    private static final String EXTRA_KEY_SDK_PACKAGE = "com.fillr.sdkpackage";
    private static final String EXTRA_KEY_VERSION = "com.fillr.sdkversion";
    private static final String EXTRA_VALUE_VERSION = "4.2.3";
    private static final String EXTRA_KEY_ADDITIONAL_INFO = "com.fillr.additionalinfo";
    private Context mContext;
    private String mDevKey;
    private String mPackageName;
    private String mSecret;
    private EmbeddedBrowser mEmbeddedBrowser;
    private FillrAnalyticsManager mAnalyticsManager;

    public FillrIntentBuilder(Context context, String devKey, String secret) {
        this.mContext = context.getApplicationContext();
        if (this.mContext != null) {
            this.mPackageName = this.mContext.getPackageName();
        }
        this.mDevKey = devKey;
        this.mSecret = secret;
        this.mEmbeddedBrowser = EmbeddedBrowser.getEmbeddedBrowser(devKey);
    }

    public void setAnalyticsManager(FillrAnalyticsManager analyticsManager) {
        this.mAnalyticsManager = analyticsManager;
    }

    public Intent buildIntent(String json) {
        Intent newIntent = new Intent();
        String pkg = this.getFillrCorePackageName();
        String activity = "com.fillr.embedded.browsersdk.activity.FESDKMainActivity";
        if (this.shouldLoadFillrNativeApps()) {
            activity = "com.fillr.browsersdk.activities.FillrBSDKProfileDataApproveActivity";
        }
        newIntent.setComponent(new ComponentName(pkg, activity));
        newIntent.putExtra(EXTRA_KEY_FIELDS, json);
        this.setIntentExtras(newIntent);
        return newIntent;
    }

    private boolean isFillrDolphinNativeAppAvailable() {
        return !FillrUtils.isPackageInstalled("com.fillr", this.mContext) && FillrUtils.isPackageInstalled("com.fillr.dolphin", this.mContext);
    }

    private boolean shouldLoadFillrNativeApps() {
        return this.isAnyFillrAppInstalled() && this.mEmbeddedBrowser != EmbeddedBrowser.EBATES && this.mEmbeddedBrowser != EmbeddedBrowser.KLARNA;
    }

    public boolean isAnyFillrAppInstalled() {
        boolean a = FillrUtils.isPackageInstalled("com.fillr.dolphin", this.mContext);
        boolean b = FillrUtils.isPackageInstalled("com.fillr", this.mContext);
        return a || b;
    }

    public void setIntentExtras(Intent intent) {
        intent.putExtra(EXTRA_KEY_DEV_KEY, this.mDevKey);
        intent.putExtra(EXTRA_KEY_SECRET_KEY, this.mSecret);
        intent.putExtra(EXTRA_KEY_SDK_PACKAGE, this.mPackageName);
        intent.putExtra(EXTRA_KEY_VERSION, EXTRA_VALUE_VERSION);
        String additionalInfo = this.getAdditionalInfo();
        if (additionalInfo != null) {
            intent.putExtra(EXTRA_KEY_ADDITIONAL_INFO, additionalInfo);
        }
    }

    public String getAdditionalInfo() {
        String retVal = null;
        try {
            JSONObject json = new JSONObject();
            json.put("app_package", (Object)this.mPackageName);
            json.put("developer_key", (Object)this.mDevKey);
            json.put("version", (Object)EXTRA_VALUE_VERSION);
            json.put("sdk_analytics_user_id", (Object)(this.mAnalyticsManager != null ? this.mAnalyticsManager.getClientID() : ""));
            retVal = json.toString();
        }
        catch (JSONException ex) {
            ex.printStackTrace();
        }
        return retVal;
    }

    public String getFillrCorePackageName() {
        return this.getFillrCorePackageName(false);
    }

    public String getFillrCorePackageName(boolean forceFillrCore) {
        if (!this.shouldLoadFillrNativeApps() || forceFillrCore) {
            return this.mPackageName;
        }
        if (this.isAnyFillrAppInstalled()) {
            if (this.isFillrDolphinNativeAppAvailable()) {
                return "com.fillr.dolphin";
            }
            return "com.fillr";
        }
        return this.mPackageName;
    }
}

