/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk.apiclient;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.ResultReceiver;
import com.fillr.browsersdk.Fillr;
import com.fillr.browsersdk.FillrAuthenticationStore;
import com.fillr.browsersdk.analytics.FillrAnalyticsEvents;
import com.fillr.browsersdk.model.FillrIntentBuilder;
import com.fillr.browsersdk.model.FillrMapping;
import com.fillr.browsersdk.model.FillrWebView;
import com.fillr.browsersdk.model.FillrWidgetPageEvent;
import com.fillr.browsersdk.utilities.FillrCaptureSensitiveDataDialogManager;
import java.util.ArrayList;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import timber.log.Timber;

public class FillrMappingServiceClient {
    private static final String TAG = "Mapping Service Client";
    private static final String ELAPSED_TIME_KEY = "PerformanceStatsServiceElapsedTime";
    private static final String FILL_ID = "PerformanceStatsServiceFillID";
    private static final String FILLED = "PerformanceStatsServiceFilled";
    private static final String EXTRA_KEY_FIELDS = "com.fillr.jsonfields";
    private static final String EXTRA_KEY_HEADLESS_MODE = "com.fillr.headless.mode";
    private static final String EXTRA_KEY_VALUES = "com.fillr.jsonvalues";
    private static final String EXTRA_NEW_PAGE = "com.fillr.isnewpage";
    private static final String EXTRA_KEY_VIEW_ID = "com.fillr.viewid";
    private static final String EXTRA_KEY_PAGE_EVENT = "com.fillr.page.event";
    private static final String EXTRA_KEY_DEV_KEY = "com.fillr.devkey";
    private static final String EXTRA_KEY_SECRET_KEY = "com.fillr.secretkey";
    private static final String EXTRA_KEY_VERSION = "com.fillr.sdkversion";
    public static final String EXTRA_DEMOGRAPHY_DATA_KEY = "com.fillr.demographydatakey";
    private static final String EXTRA_RECEIVER = "receiver";
    public static final String RAW_RESPONSE = "raw_response";
    private static final String FIELDS = "fields";
    public static final String COULD_NOT_START_HEADLESS_FILL_MAPPING_SERVICE = "Could not start HeadlessFillMappingService ";
    private boolean delayCaptureValuesMappingRequestService = false;
    private boolean delayHeadlessFillMappingRequestService = false;
    private Fillr mFillr;
    private static FillrCaptureSensitiveDataDialogManager captureDialogManager;
    static Boolean isFeatureToggleUpdateRunning;

    public FillrMappingServiceClient(Fillr fillr) {
        this.mFillr = fillr;
    }

    public boolean sendValuesToProfile(JSONObject fields, JSONObject values, boolean isNewPage) {
        return this.sendValuesToProfile(fields.toString(), values.toString(), isNewPage);
    }

    public boolean sendValuesToProfile(String fields, String values, boolean isNewPage) {
        if (captureDialogManager == null) {
            captureDialogManager = new FillrCaptureSensitiveDataDialogManager(this.mFillr);
        }
        if (!this.delayCaptureValuesMappingRequestService) {
            try {
                this.delayCaptureValuesMappingRequestService = true;
                FillrIntentBuilder intentBuilder = this.mFillr.getIntentBuilder();
                Intent newIntent = new Intent("com.fillr.service.CaptureFieldsMappingService");
                newIntent.setPackage(intentBuilder.getFillrCorePackageName());
                newIntent.putExtra(EXTRA_RECEIVER, (Parcelable)new ResultReceiver(new Handler()){

                    protected void onReceiveResult(int resultCode, Bundle resultData) {
                        Timber.d((String)"Capture values service sent", (Object[])new Object[0]);
                    }
                });
                newIntent.putExtra(EXTRA_KEY_FIELDS, fields);
                newIntent.putExtra(EXTRA_KEY_VALUES, values);
                newIntent.putExtra(EXTRA_NEW_PAGE, isNewPage);
                intentBuilder.setIntentExtras(newIntent);
                this.startFillrService(newIntent);
                Handler handler = new Handler();
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        FillrMappingServiceClient.this.delayCaptureValuesMappingRequestService = false;
                    }
                };
                handler.postDelayed(r, 2000L);
                return true;
            }
            catch (Exception e) {
                Timber.w((String)"%s%s", (Object[])new Object[]{COULD_NOT_START_HEADLESS_FILL_MAPPING_SERVICE, e.getMessage()});
            }
        }
        return false;
    }

    public synchronized boolean getMappingsForHeadlessFill(String formMetaData, FillrWebView webView) {
        if (!this.delayHeadlessFillMappingRequestService && this.formMetaDataValid(formMetaData) && webView != null && webView.getViewId() != null) {
            try {
                this.delayHeadlessFillMappingRequestService = true;
                Intent newIntent = new Intent("com.fillr.service.HeadlessFillMappingService");
                FillrIntentBuilder intentBuilder = this.mFillr.getIntentBuilder();
                newIntent.setPackage(intentBuilder.getFillrCorePackageName());
                newIntent.putExtra(EXTRA_RECEIVER, (Parcelable)new ResultReceiver(new Handler()){

                    protected void onReceiveResult(int resultCode, Bundle resultData) {
                        try {
                            JSONObject mappingResult = new JSONObject(resultData.getString(FillrMappingServiceClient.RAW_RESPONSE));
                            String viewId = resultData.getString(FillrMappingServiceClient.EXTRA_KEY_VIEW_ID);
                            long startTime = resultData.getLong("com.fillr.start_time");
                            ArrayList fields = resultData.getStringArrayList(FillrMappingServiceClient.FIELDS);
                            if (FillrMappingServiceClient.this.mFillr == null) {
                                FillrMappingServiceClient.this.mFillr = Fillr.getInstance();
                            }
                            FillrMapping fillrMapping = new FillrMapping(mappingResult, fields);
                            fillrMapping.setStartTime(startTime);
                            FillrMappingServiceClient.this.mFillr.notifyProfileListener(fillrMapping, viewId);
                        }
                        catch (Exception e) {
                            Timber.e((Throwable)e);
                        }
                    }
                });
                newIntent.putExtra(EXTRA_KEY_FIELDS, formMetaData);
                newIntent.putExtra(EXTRA_KEY_VIEW_ID, webView.getViewId());
                newIntent.putExtra(EXTRA_KEY_HEADLESS_MODE, true);
                intentBuilder.setIntentExtras(newIntent);
                this.startFillrService(newIntent);
                Handler handler = new Handler();
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        FillrMappingServiceClient.this.delayHeadlessFillMappingRequestService = false;
                    }
                };
                handler.postDelayed(r, 2000L);
                return true;
            }
            catch (Exception e) {
                Timber.w((String)"%s%s", (Object[])new Object[]{COULD_NOT_START_HEADLESS_FILL_MAPPING_SERVICE, e.getMessage()});
            }
        }
        return false;
    }

    public synchronized boolean getMappingsForToolBarDisplay(String formMetaData, ResultReceiver receiver) {
        if (!this.delayHeadlessFillMappingRequestService && this.formMetaDataValid(formMetaData)) {
            try {
                this.delayHeadlessFillMappingRequestService = true;
                Intent newIntent = new Intent("com.fillr.service.HeadlessFillMappingService");
                FillrIntentBuilder intentBuilder = this.mFillr.getIntentBuilder();
                newIntent.setPackage(intentBuilder.getFillrCorePackageName());
                newIntent.putExtra(EXTRA_RECEIVER, (Parcelable)receiver);
                newIntent.putExtra(EXTRA_KEY_FIELDS, formMetaData);
                intentBuilder.setIntentExtras(newIntent);
                this.startFillrService(newIntent);
                Handler handler = new Handler();
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        FillrMappingServiceClient.this.delayHeadlessFillMappingRequestService = false;
                    }
                };
                handler.postDelayed(r, 2000L);
                return true;
            }
            catch (Exception e) {
                Timber.w((String)"%s%s", (Object[])new Object[]{COULD_NOT_START_HEADLESS_FILL_MAPPING_SERVICE, e.getMessage()});
            }
        }
        return false;
    }

    private boolean formMetaDataValid(String formMetaData) {
        if (formMetaData != null) {
            try {
                JSONObject jsonObject = new JSONObject(formMetaData);
                JSONArray fields = jsonObject.getJSONArray(FIELDS);
                return fields.length() > 0;
            }
            catch (JSONException e) {
                Timber.e((Throwable)e);
            }
        }
        return false;
    }

    public boolean sendPageEvent(JSONObject event, ResultReceiver receiver) {
        if (this.pageEventValid(event)) {
            if (this.mFillr == null) {
                this.mFillr = Fillr.getInstance();
            }
            try {
                Intent newIntent = new Intent("com.fillr.service.PageEventService");
                FillrIntentBuilder intentBuilder = this.mFillr.getIntentBuilder();
                newIntent.setPackage(intentBuilder.getFillrCorePackageName(true));
                newIntent.putExtra(EXTRA_RECEIVER, (Parcelable)receiver);
                newIntent.putExtra(EXTRA_KEY_PAGE_EVENT, event.toString());
                newIntent.putExtra(EXTRA_KEY_DEV_KEY, this.mFillr.getDeveloperKey());
                newIntent.putExtra(EXTRA_KEY_SECRET_KEY, this.mFillr.getSecretKey());
                newIntent.putExtra(EXTRA_KEY_VERSION, "4.2.3");
                intentBuilder.setIntentExtras(newIntent);
                this.startFillrService(newIntent);
            }
            catch (Exception notSent) {
                Timber.w((Throwable)notSent, (String)"Failed to send page-event via service Intent; falling back to direct dispatch", (Object[])new Object[0]);
                notSent.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private boolean pageEventValid(JSONObject event) {
        if (event != null) {
            try {
                FillrWidgetPageEvent eventType = FillrWidgetPageEvent.eventForName(event.getString("type"));
                return eventType != null && event.getString("url").trim().length() > 1;
            }
            catch (Exception e) {
                Timber.e((Throwable)e);
            }
        }
        return false;
    }

    public void sendPerformanceForHeadlessFill(FillrMapping fields) {
        try {
            if (fields != null) {
                long endTime = System.nanoTime();
                double mappingRequestElapsedTime = (double)(endTime - fields.getStartTime()) / 1000000.0;
                JSONObject formMappings = fields.getFormMappings();
                String filldId = formMappings.getString("fill_id");
                if (mappingRequestElapsedTime > 0.0 && filldId != null) {
                    Intent performanceService = new Intent("com.fillr.service.PerformanceStatsService");
                    FillrIntentBuilder intentBuilder = this.mFillr.getIntentBuilder();
                    String demographyDataForHeadlessFill = fields.getDemographyDataForHeadlessFill();
                    performanceService.setPackage(intentBuilder.getFillrCorePackageName());
                    performanceService.putExtra(ELAPSED_TIME_KEY, mappingRequestElapsedTime);
                    performanceService.putExtra(FILL_ID, filldId);
                    performanceService.putExtra(FILLED, true);
                    performanceService.putExtra(EXTRA_KEY_HEADLESS_MODE, true);
                    performanceService.putExtra(EXTRA_DEMOGRAPHY_DATA_KEY, demographyDataForHeadlessFill);
                    this.startFillrService(performanceService);
                    this.mFillr.trackEvent(FillrAnalyticsEvents.FillrFillHeadlessMode, demographyDataForHeadlessFill, filldId, Integer.toString(fields.getNumberOfCreditCardFields()));
                }
            }
        }
        catch (Exception e) {
            Timber.e((String)e.getMessage(), (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    public void initlizeFeatureTogglesUpdate() {
        this.runFeatureTogglesUpdateIfStopped();
    }

    public void runFeatureTogglesUpdateIfStopped() {
        if (!isFeatureToggleUpdateRunning.booleanValue()) {
            isFeatureToggleUpdateRunning = true;
            this.updateFeatureToggles();
            this.updateFeatureTogglesAtInterval();
        }
    }

    private void updateFeatureTogglesAtInterval() {
        Handler handler = new Handler(Looper.getMainLooper());
        long interval = 300000L;
        handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Date lastActiveTime = Fillr.getInstance().getLastActiveTime();
                if (lastActiveTime != null && System.currentTimeMillis() < lastActiveTime.getTime() + 300000L) {
                    FillrMappingServiceClient.this.updateFeatureToggles();
                    FillrMappingServiceClient.this.updateFeatureTogglesAtInterval();
                } else {
                    isFeatureToggleUpdateRunning = false;
                }
            }
        }, 300000L);
    }

    private void updateFeatureToggles() {
        try {
            Intent featureToggles = new Intent("com.fillr.service.FeatureFlagsService");
            FillrIntentBuilder intentBuilder = this.mFillr.getIntentBuilder();
            featureToggles.setPackage(intentBuilder.getFillrCorePackageName());
            this.startFillrService(featureToggles);
        }
        catch (Exception e) {
            Timber.e((String)e.getMessage(), (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    private void startFillrService(Intent intent) {
        try {
            Activity context = this.mFillr.getParentActivity();
            boolean currentStateActive = this.mFillr.isCurrentStateActive();
            if (context != null && currentStateActive && FillrAuthenticationStore.isEnabled((Context)context)) {
                context.startService(intent);
            }
        }
        catch (Exception e) {
            Timber.e((Throwable)e);
        }
    }

    static {
        isFeatureToggleUpdateRunning = false;
    }
}

