/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk.analytics;

import com.fillr.analytics.AnalyticsEvent;
import com.fillr.browsersdk.analytics.FillrAnalyticsManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import timber.log.Timber;

public class FillrFillResults {
    private static final String LOGTAG = "FillrSDK";
    private final FillrAnalyticsManager mAnalyticsManager;

    public FillrFillResults(FillrAnalyticsManager analyticsManager) {
        this.mAnalyticsManager = analyticsManager;
    }

    public void sendReport(String jsonFillResult) {
        try {
            JSONObject report = new JSONObject(jsonFillResult);
            JSONArray fields = report.getJSONArray("fields");
            for (int i = 0; i < fields.length(); ++i) {
                this.createEvent(fields.getJSONObject(i), report.optString("fill_id"), report.optString("widget_version"));
            }
        }
        catch (JSONException e) {
            Timber.d((String)"Could not parse Filled Result", (Object[])new Object[0]);
        }
    }

    private boolean createEvent(JSONObject field, String fillId, String widgetVersion) {
        if (this.mAnalyticsManager == null) {
            Timber.e((String)"Analytics Manager is null in FillrFillrResults", (Object[])new Object[0]);
            return false;
        }
        AnalyticsEvent event = this.mAnalyticsManager.createEvent();
        event.setCategory("Field Fill Result");
        event.setFillId(fillId);
        event.setValue(String.valueOf(field.optInt("pop_id", 0)));
        String action = null;
        if (field.has("successfully_filled")) {
            if (field.optBoolean("successfully_filled")) {
                action = "Successful";
            } else if (!field.optBoolean("successfully_filled")) {
                action = "Error";
            }
        } else if (field.optBoolean("mapped_but_no_value")) {
            action = "Mapped But No Value";
        }
        if (action == null) {
            return false;
        }
        event.setLabel(field.optString("param"));
        event.setAction(action);
        event.setWidgetVersion(widgetVersion);
        this.mAnalyticsManager.sendEvent(event);
        return true;
    }
}

