/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Rect;
import android.os.Handler;
import android.view.View;
import android.view.ViewTreeObserver;
import com.fillr.browsersdk.EmbeddedBrowser;
import com.fillr.browsersdk.Fillr;
import com.fillr.browsersdk.FillrActionView;
import com.fillr.browsersdk.FillrAuthenticationStore;
import com.fillr.browsersdk.analytics.FillrAnalyticsEvents;
import com.fillr.browsersdk.model.FillrBrowserProperties;
import com.fillr.browsersdk.tooltip.SimpleTooltip;
import com.fillr.browsersdk.utilities.FillrDialogHelper;
import com.fillr.browsersdk.utilities.FillrUtils;
import java.lang.ref.WeakReference;
import java.util.Calendar;
import java.util.Date;
import timber.log.Timber;

public class FillrToolbarManager
implements ViewTreeObserver.OnGlobalLayoutListener,
View.OnClickListener {
    private static final String LOGTAG = "FillrSDK";
    private Context context;
    private WeakReference<FillrActionView> mActionView;
    private String currentUrlDomain = "";
    private boolean isToolbarShown = false;
    private int fieldFocusCount = 0;
    private int orientation = -1;
    private FillrBrowserProperties browserProperties;
    private boolean hasFields = true;
    private SimpleTooltip tourTooltip = null;

    public FillrToolbarManager(Context parentActivity, FillrBrowserProperties browser) {
        Configuration configuration;
        this.context = parentActivity.getApplicationContext();
        Resources resources = parentActivity.getResources();
        if (resources != null && (configuration = resources.getConfiguration()) != null) {
            this.orientation = configuration.orientation;
        }
        this.browserProperties = browser;
    }

    public void setActionView(FillrActionView actionView) {
        ((View)actionView).getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        ((View)actionView).getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        ((View)actionView).setOnClickListener((View.OnClickListener)this);
        this.mActionView = new WeakReference<FillrActionView>(actionView);
    }

    public void urlChanged(String newDomain) {
        this.currentUrlDomain = newDomain;
        this.fieldFocusCount = 0;
    }

    public void setToolbarVisible(boolean visible) {
        if (this.mActionView == null) {
            return;
        }
        FillrActionView fillrActionView = (FillrActionView)this.mActionView.get();
        if (fillrActionView == null) {
            return;
        }
        fillrActionView.setVisibility(visible);
    }

    public void fieldFocused() {
        ++this.fieldFocusCount;
        this.showToolbar();
    }

    private FillrActionView getTargetView() {
        if (this.mActionView != null) {
            return (FillrActionView)this.mActionView.get();
        }
        return null;
    }

    private synchronized void showToolbar() {
        if (Fillr.getInstance().getFillMode() == Fillr.FillMode.HEADLESS) {
            Timber.d((String)"in headless mode", (Object[])new Object[0]);
            return;
        }
        FillrActionView targetView = this.getTargetView();
        if (targetView == null) {
            Timber.d((String)"showToolbar:fillrToolbarView = null", (Object[])new Object[0]);
            return;
        }
        if (!this.viewsAreStable((View)targetView)) {
            Timber.d((String)"showToolbar:!viewsAreStable", (Object[])new Object[0]);
            return;
        }
        if (this.shouldHideToolbar()) {
            Timber.d((String)"showToolbar:shouldHideToolbar", (Object[])new Object[0]);
            this.hideToolbar();
            return;
        }
        if (this.isKeyboardUp((View)targetView)) {
            Timber.d((String)"showToolbar:isKeyboardUp", (Object[])new Object[0]);
            targetView.orientationChange(this.isLandscape());
            if (!this.isToolbarShown) {
                Timber.d((String)"showToolbar:!isToolbarShown", (Object[])new Object[0]);
                if (((View)targetView).hasWindowFocus()) {
                    this.showTour((View)targetView);
                    targetView.show();
                    this.isToolbarShown = true;
                    Fillr.getInstance().trackEvent(FillrAnalyticsEvents.FillrBarShown, new String[0]);
                }
            } else {
                Timber.d((String)"showToolbar:toolbar already visible.%s", (Object[])new Object[]{this.fieldFocusCount});
                if (this.fieldFocusCount >= 3) {
                    targetView.remind();
                    this.fieldFocusCount = 0;
                }
            }
        } else {
            Timber.d((String)"showToolbar:keyboard is not up", (Object[])new Object[0]);
            if (this.isToolbarShown) {
                Timber.d((String)"showToolbar:isToolbarShown", (Object[])new Object[0]);
                this.hideToolbar();
            }
        }
    }

    private void showTour(final View rootView) {
        if (this.shouldShowToolbarToolTip() && this.isKeyboardUp(rootView)) {
            Handler handler = new Handler();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (FillrToolbarManager.this.isToolbarShown && !FillrToolbarManager.this.shouldHideToolbar() && FillrToolbarManager.this.isKeyboardUp(rootView) && FillrToolbarManager.this.tourTooltip == null) {
                        FillrToolbarManager.this.tourTooltip = FillrDialogHelper.showToolbarToolTip(FillrToolbarManager.this.context, rootView, new View.OnClickListener(){

                            public void onClick(View v) {
                                FillrUtils.hideKeyboard(FillrToolbarManager.this.context, rootView);
                                FillrToolbarManager.this.onClick(v);
                            }
                        }, FillrToolbarManager.this.browserProperties);
                    } else {
                        FillrToolbarManager.this.clearTourDialogIfVisible();
                    }
                }
            };
            handler.postDelayed(r, 300L);
        }
    }

    private boolean shouldShowToolbarToolTip() {
        int millisecondsInOneDay = 86400000;
        Date dismissDate = EmbeddedBrowser.getTooltipLastDismissDate(this.context);
        Date currentDate = Calendar.getInstance().getTime();
        return !EmbeddedBrowser.isTooltipAlreadyShown(this.context) || dismissDate != null && currentDate.getTime() - dismissDate.getTime() > (long)millisecondsInOneDay;
    }

    private void hideToolbar() {
        this.clearTourDialogIfVisible();
        FillrActionView targetView = this.getTargetView();
        if (targetView == null) {
            return;
        }
        this.isToolbarShown = false;
        targetView.hide();
    }

    private void clearTourDialogIfVisible() {
        if (this.tourTooltip != null) {
            this.tourTooltip.dismiss();
            this.tourTooltip = null;
        }
    }

    public void onGlobalLayout() {
        Fillr instance = Fillr.getInstance();
        if (instance != null && instance.isEnabled() && instance.getFillMode() == Fillr.FillMode.HEADFUL) {
            this.showToolbar();
        }
    }

    public void onClick(View view) {
        Fillr instance = Fillr.getInstance();
        if (instance == null) {
            return;
        }
        Fillr.getInstance().trackEvent(FillrAnalyticsEvents.FillrUseSecureButton, new String[0]);
        final View leftContainer = view;
        leftContainer.setEnabled(false);
        leftContainer.setClickable(false);
        instance.onToolbarClicked(this.isFillrAppInstalled());
        Handler handler = new Handler();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                leftContainer.setEnabled(true);
                leftContainer.setClickable(true);
            }
        };
        handler.postDelayed(r, 2000L);
    }

    private boolean isFillrAppInstalled() {
        return FillrUtils.isPackageInstalled("com.fillr", this.context);
    }

    private boolean viewsAreStable(View targetView) {
        if (this.orientation != this.context.getResources().getConfiguration().orientation) {
            if (!this.isKeyboardUp(targetView)) {
                this.orientation = this.context.getResources().getConfiguration().orientation;
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean isKeyboardUp(View targetView) {
        Rect displayRect = new Rect();
        targetView.getWindowVisibleDisplayFrame(displayRect);
        int rootHeight = targetView.getRootView().getHeight();
        int keypadHeight = rootHeight - displayRect.bottom;
        return (double)keypadHeight > (double)rootHeight * 0.15;
    }

    private boolean isLandscape() {
        return this.context.getResources().getConfiguration().orientation == 2;
    }

    private boolean isPageExcluded() {
        return FillrUtils.excludeByDomain(this.currentUrlDomain);
    }

    private boolean shouldHideToolbar() {
        if (!Fillr.getInstance().hasValidWebViewInstance()) {
            Timber.d((String)"!hasValidWebViewInstance", (Object[])new Object[0]);
            return true;
        }
        if (Fillr.getInstance().isToolbarDismissed()) {
            Timber.d((String)"isToolbarDismissed", (Object[])new Object[0]);
            return true;
        }
        if (!FillrAuthenticationStore.isVisible(this.context)) {
            Timber.d((String)"isVisible", (Object[])new Object[0]);
            return true;
        }
        if (!this.isFillrAppInstalled() && this.isLandscape()) {
            Timber.d((String)"isLandscape", (Object[])new Object[0]);
            return true;
        }
        if (!FillrAuthenticationStore.isEnabled(this.context)) {
            Timber.d((String)"isEnabled", (Object[])new Object[0]);
            return true;
        }
        if (this.isPageExcluded()) {
            Timber.d((String)"isPageExcluded", (Object[])new Object[0]);
            return true;
        }
        if (!Fillr.getInstance().shouldShowAutofillPrompt()) {
            Timber.d((String)"!webViewHasFocus", (Object[])new Object[0]);
            return true;
        }
        if (!this.hasFields) {
            Timber.d((String)"hasFields", (Object[])new Object[0]);
            return true;
        }
        return false;
    }

    public void setFillableFieldsFlag(boolean hasFields) {
        this.hasFields = hasFields;
        if (this.shouldHideToolbar()) {
            this.hideToolbar();
        } else {
            this.showToolbar();
        }
    }
}

