/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import java.util.Calendar;
import java.util.Date;

public enum EmbeddedBrowser {
    DEFAULT,
    DOLPHIN,
    EBATES,
    KLARNA;

    private static final String PREF_KEY_TUTORIAL = "com_fillr_ebates_help_tooltip";
    private static final String TOOLTIP_LAST_DISMISS_DATE_KEY = "com_fillr_ebates_help_tooltip_dismiss_date";

    public static EmbeddedBrowser getEmbeddedBrowser(String devKey) {
        if (devKey != null) {
            switch (devKey) {
                case "caa4bd5f8250724734e6699e7d2172e5": {
                    return EBATES;
                }
                case "NzIwOGQ2YTU3ODBlM2NiMGQ0Y2Y4YTE=": {
                    return DOLPHIN;
                }
                case "21b1c5cfba87274ecae92ab3555a3cd8": {
                    return KLARNA;
                }
                case "4c35c58dde1ae30aed196c854af215a3": {
                    return KLARNA;
                }
            }
            return DEFAULT;
        }
        return DEFAULT;
    }

    public static void markTooltipAsCompleted(Context context) {
        SharedPreferences defaultSharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        SharedPreferences.Editor editor = defaultSharedPreferences.edit();
        editor.putBoolean(PREF_KEY_TUTORIAL, true);
        Date currentDate = Calendar.getInstance().getTime();
        editor.putLong(TOOLTIP_LAST_DISMISS_DATE_KEY, currentDate.getTime());
        editor.commit();
    }

    public static boolean isTooltipAlreadyShown(Context context) {
        SharedPreferences defaultSharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        return defaultSharedPreferences.getBoolean(PREF_KEY_TUTORIAL, false);
    }

    public static Date getTooltipLastDismissDate(Context context) {
        SharedPreferences defaultSharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        Long lastUpdateLong = defaultSharedPreferences.getLong(TOOLTIP_LAST_DISMISS_DATE_KEY, -1L);
        if (lastUpdateLong > 0L) {
            Date lastUpdate = new Date(lastUpdateLong);
            return lastUpdate;
        }
        return null;
    }
}

