/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk.model;

import android.app.Activity;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.webkit.JavascriptInterface;
import com.fillr.browsersdk.Fillr;
import com.fillr.browsersdk.FillrAuthenticationStore;
import com.fillr.browsersdk.apiclient.FillrWidgetDownloader;
import com.fillr.browsersdk.model.FillrWebView;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import timber.log.Timber;

public class FillrWidget {
    private static final String TAG = "Fillr Widget";
    private FillrWidgetListener mWidgetListener;
    private FillrWidgetListener mWidgetListenerPrompt;
    private String mWidgetJavaScript = null;
    private Fillr mFillr;
    private boolean useAuth = false;
    private WidgetType widgetType;
    private String localAssetName;
    private String remoteAssetUrl;

    public FillrWidget(Fillr fillr, String localAssetName, String remoteAssetUrl, WidgetType type) {
        this.mFillr = fillr;
        this.localAssetName = localAssetName;
        this.remoteAssetUrl = remoteAssetUrl;
        this.widgetType = type;
    }

    public FillrWidget(Fillr fillr, String localAssetName, String remoteAssetUrl, boolean useAuth, WidgetType type) {
        this(fillr, localAssetName, remoteAssetUrl, type);
        this.useAuth = useAuth;
    }

    public boolean useAuth() {
        return this.useAuth;
    }

    public String getRemoteAssetUrl() {
        return this.remoteAssetUrl;
    }

    public String getLocalAssetName() {
        return this.localAssetName;
    }

    public String getWidgetJavaScript() {
        return this.mWidgetJavaScript;
    }

    public void setWidgetListener(FillrWidgetListener listener) {
        this.mWidgetListener = listener;
    }

    public void setWidgetListenerPrompt(FillrWidgetListener listener) {
        this.mWidgetListenerPrompt = listener;
    }

    public void inject(FillrWebView webView) {
        if (webView != null && this.mWidgetJavaScript != null) {
            if (this.widgetType == WidgetType.MOBILE || this.widgetType == WidgetType.CART_SCRAPER) {
                webView.loadJavascript("!function(e){var i=!1;i=!(\"undefined\"==typeof PopWidgetInterface&&\"MOBILE\"==e||\"undefined\"==typeof FillrCartInformationExtractionInterface&&\"CART_SCRAPER\"==e),\"undefined\"!=typeof FillrAndroidWidget&&\"MOBILE\"==e&&FillrAndroidWidget.injectFillrAndroidWidget(i),\"undefined\"!=typeof FillrAndroidWidgetCS&&\"CART_SCRAPER\"==e&&FillrAndroidWidgetCS.injectFillrAndroidCartScraper(i)}('" + this.widgetType.toString() + "');");
            } else {
                this.loadJSIntoWebView(webView, false);
            }
        }
    }

    private void loadJSIntoWebView(final FillrWebView webView, final boolean isInjected) {
        if (webView != null) {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (!isInjected) {
                        webView.loadJavascript(FillrWidget.this.mWidgetJavaScript);
                        webView.setWidgetInjected();
                    }
                    if (FillrWidget.this.mWidgetListenerPrompt != null) {
                        FillrWidget.this.mWidgetListenerPrompt.onWidgetInjected(webView);
                    }
                    if (FillrWidget.this.mWidgetListener != null) {
                        FillrWidget.this.mWidgetListener.onWidgetInjected(webView);
                    }
                }
            }, 200L);
        }
    }

    public void download() {
        if (this.mWidgetJavaScript != null && this.mWidgetListener != null) {
            this.mWidgetListener.onWidgetDownloaded(this.mWidgetJavaScript);
            return;
        }
        if (this.mFillr.getWidgetSource() == FillrAuthenticationStore.WidgetSource.REMOTE) {
            this.getWidgetInfoFromServer();
        } else {
            this.getWidgetInfoFromAssets();
        }
    }

    private void getWidgetInfoFromServer() {
        PerformWidgetDownload widgetDownloader = new PerformWidgetDownload(this);
        widgetDownloader.execute(new Void[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getWidgetInfoFromAssets() {
        Activity activity = this.mFillr.getParentActivity();
        if (activity != null) {
            StringBuilder buf = new StringBuilder();
            BufferedReader in = null;
            InputStream json = null;
            try {
                String str;
                json = activity.getAssets().open(this.localAssetName);
                in = new BufferedReader(new InputStreamReader(json, "UTF-8"));
                while ((str = in.readLine()) != null) {
                    buf.append(str);
                }
                in.close();
                this.mWidgetJavaScript = buf.toString();
            }
            catch (IOException e) {
                this.mWidgetJavaScript = null;
            }
            finally {
                try {
                    if (json != null) {
                        json.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex) {
                    Timber.e((String)"Could not load the widget", (Object[])new Object[0]);
                }
            }
            if (this.mWidgetListener != null) {
                this.mWidgetListener.onWidgetDownloaded(this.mWidgetJavaScript);
            }
        }
    }

    public boolean widgetAvailable() {
        return this.mWidgetJavaScript != null && this.mWidgetJavaScript.length() > 0;
    }

    public String getWidgetInjectionJNI() {
        return this.widgetType.jni;
    }

    private static class PerformWidgetDownload
    extends AsyncTask<Void, Void, String> {
        FillrWidget widget;
        private String remoteWidgetUrl;

        PerformWidgetDownload(FillrWidget widget) {
            this.widget = widget;
            this.remoteWidgetUrl = widget.getRemoteAssetUrl();
        }

        protected String doInBackground(Void ... params) {
            String retVal = null;
            try {
                return FillrWidgetDownloader.getContent(this.remoteWidgetUrl, this.widget.useAuth);
            }
            catch (Exception e) {
                Timber.e((String)e.getMessage(), (Object[])new Object[0]);
                return retVal;
            }
        }

        protected void onPostExecute(String response) {
            super.onPostExecute((Object)response);
            if (response != null && this.widget != null) {
                this.widget.mWidgetJavaScript = response;
                if (this.widget.mWidgetListener != null) {
                    this.widget.mWidgetListener.onWidgetDownloaded(response);
                }
            }
        }
    }

    public class WidgetInjectionInterface {
        FillrWebView injectedWebView;

        public WidgetInjectionInterface(FillrWebView webView) {
            this.injectedWebView = webView;
        }

        @JavascriptInterface
        public void injectFillrAndroidWidget(boolean isInjected) {
            FillrWidget.this.loadJSIntoWebView(this.injectedWebView, isInjected);
        }

        @JavascriptInterface
        public void injectFillrAndroidCartScraper(boolean isInjected) {
            FillrWidget.this.loadJSIntoWebView(this.injectedWebView, isInjected);
        }
    }

    public static interface FillrWidgetListener {
        public void onWidgetDownloaded(String var1);

        public void onWidgetInjected(FillrWebView var1);
    }

    public static enum WidgetType {
        MOBILE("FillrAndroidWidget"),
        CART_SCRAPER("FillrAndroidWidgetCS");

        String jni;

        private WidgetType(String jni) {
            this.jni = jni;
        }
    }
}

