/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.fillr.browsersdk.Fillr;
import com.fillr.browsersdk.FillrActionView;
import com.fillr.browsersdk.R;
import com.fillr.browsersdk.model.FillrBrowserProperties;
import com.fillr.browsersdk.utilities.FillrUtils;
import timber.log.Timber;

public class FillrToolbarView
extends RelativeLayout
implements FillrActionView {
    private static final String LOGTAG = "FillrSDK";
    private boolean alreadyInitialized = false;
    private Context mContext;
    private ImageView autofillIcon;
    private TextView autofillTextView;
    private int mToolbarBackgroundColor = Color.parseColor((String)"#F7E4E7E8");
    private static final int MIN_TOOLBAR_SPACE_DP = 175;
    private static final int MIN_LANDSCAPE_TOOL_BAR_HEIGHT_DP = 35;
    private static final int MAX_LANDSCAPE_TOOL_BAR_HEIGHT_DP = 50;
    private static final String TOOLBAR_TEXT = "Use Autofill";

    public FillrToolbarView(Context context) {
        super(context);
        this.initViews(context);
    }

    public FillrToolbarView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FillrToolbarView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initViews(context);
    }

    private void initViews(Context context) {
        Fillr instance = Fillr.getInstance();
        if (instance != null) {
            instance.setToolbarView(this);
        }
        if (!FillrUtils.androidApiIceCreamSandwichOrHigher()) {
            this.setVisibility(4);
            return;
        }
        if (this.alreadyInitialized) {
            return;
        }
        this.alreadyInitialized = true;
        this.mContext = context;
        int checkExistence = this.mContext.getResources().getIdentifier("fillr_toolbar", "style", this.mContext.getPackageName());
        if (checkExistence != 0) {
            Timber.d((String)"Style exists!", (Object[])new Object[0]);
            int[] attrs = new int[]{R.attr.fillrToolbarTextColor, R.attr.fillrToolbarBG};
            TypedArray ta = this.mContext.obtainStyledAttributes(checkExistence, attrs);
            if (ta != null && ta.length() > 0) {
                this.mToolbarBackgroundColor = ta.getColor(R.styleable.fillr_toolbar_attributes_fillrToolbarBG, this.mToolbarBackgroundColor);
                ta.recycle();
            }
        } else {
            Timber.d((String)"Style does not exist", (Object[])new Object[0]);
        }
        this.setBackgroundColor(context.getResources().getColor(R.color.com_fillr_toobar_color_transparent));
        LinearLayout mainContainer = new LinearLayout(context);
        mainContainer.setOrientation(0);
        RelativeLayout.LayoutParams relativeParams = null;
        this.autofillIcon = new ImageView(context);
        LinearLayout.LayoutParams leftContainerParams = new LinearLayout.LayoutParams(-2, -1);
        leftContainerParams.setMargins(this.dpToPixel(context, 15), this.dpToPixel(context, 3), 0, 0);
        mainContainer.addView((View)this.autofillIcon, (ViewGroup.LayoutParams)leftContainerParams);
        this.autofillIcon.setVisibility(4);
        this.autofillTextView = new TextView(context);
        this.autofillTextView.setTextColor(this.getFillrTextColor());
        this.autofillTextView.setTextSize(2, 14.0f);
        this.autofillTextView.setMaxLines(1);
        this.autofillTextView.setTypeface(Typeface.SANS_SERIF, 0);
        this.autofillTextView.setLineSpacing(this.autofillTextView.getLineSpacingExtra(), 1.14f);
        this.autofillTextView.setGravity(19);
        this.autofillTextView.setVisibility(4);
        leftContainerParams = new LinearLayout.LayoutParams(-2, -1);
        leftContainerParams.setMargins(this.dpToPixel(context, 7), this.dpToPixel(context, 1), this.dpToPixel(context, 15), 0);
        leftContainerParams.gravity = 16;
        mainContainer.addView((View)this.autofillTextView, (ViewGroup.LayoutParams)leftContainerParams);
        relativeParams = new RelativeLayout.LayoutParams(-2, -1);
        relativeParams.addRule(9);
        relativeParams.addRule(15);
        relativeParams.setMargins(0, 0, this.dpToPixel(context, 15), 0);
        this.addView((View)mainContainer, (ViewGroup.LayoutParams)relativeParams);
        this.autofillIcon.setImageResource(this.getFillrBarDrawable());
        this.autofillTextView.setText((CharSequence)this.getFillrToolbarText());
        Timber.d((String)"setting invisible", (Object[])new Object[0]);
        this.setVisibility(4);
    }

    private void adjustHeight(Rect displayRect) {
        if (displayRect != null) {
            int availableSpace = (int)FillrUtils.convertPixelsToDp(displayRect.bottom);
            int toolbarHeight = availableSpace < 175 ? 35 : 50;
            int toolbarHeighInPX = FillrUtils.convertDpToPixels(toolbarHeight);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, toolbarHeighInPX);
            layoutParams.addRule(12);
            layoutParams.setMargins(0, 0, 0, 0);
            this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    public void setFillrToolbarVisible(int visibility) {
        this.autofillTextView.setText((CharSequence)this.getFillrToolbarText());
        this.autofillIcon.setImageResource(this.getFillrBarDrawable());
        this.autofillTextView.setVisibility(visibility);
        this.autofillIcon.setVisibility(visibility);
        this.setVisibility(visibility);
        this.invalidate();
    }

    public int getFillrToolbarVisibility() {
        return this.getVisibility();
    }

    public TextView getAutofillTextView() {
        return this.autofillTextView;
    }

    public ImageView getAutofillIcon() {
        return this.autofillIcon;
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == 0) {
            Fillr.getInstance().notifyToolbarVisibilityChanged(Fillr.ToolbarViewVisibility.VISIBLE);
        } else {
            Fillr.getInstance().notifyToolbarVisibilityChanged(Fillr.ToolbarViewVisibility.INVISIBLE);
        }
    }

    private String getFillrToolbarText() {
        String toolbarName;
        FillrBrowserProperties browserProps;
        Fillr instance = Fillr.getInstance();
        String text = TOOLBAR_TEXT;
        if (instance != null && (browserProps = instance.getBrowserProps()) != null && !TextUtils.isEmpty((CharSequence)(toolbarName = browserProps.getToolbarName()))) {
            text = this.mContext.getString(R.string.fillr_fill_tool_bar_text, new Object[]{toolbarName});
        }
        return text;
    }

    private int getFillrBarDrawable() {
        FillrBrowserProperties browserProps;
        int retVal = R.drawable.com_fillr_icon_toolbar_sdk;
        Fillr instance = Fillr.getInstance();
        if (instance != null && (browserProps = instance.getBrowserProps()) != null) {
            retVal = browserProps.getToolbarDrawable();
        }
        return retVal;
    }

    private int getFillrTextColor() {
        FillrBrowserProperties browserProps;
        int color2 = this.mContext.getResources().getColor(R.color.com_fillr_toolbar_autofill_text_color);
        Fillr instance = Fillr.getInstance();
        if (instance != null && (browserProps = instance.getBrowserProps()) != null) {
            color2 = browserProps.getToolbarResourceTextColor();
        }
        return color2;
    }

    private int dpToPixel(Context context, int dp) {
        Resources resources = context.getResources();
        int px = (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)resources.getDisplayMetrics());
        return px;
    }

    @Override
    public void orientationChange(boolean isLandsacpe) {
        Timber.d((String)"showToolbar:!animationInProgess", (Object[])new Object[0]);
        if (isLandsacpe) {
            Rect displayRect = new Rect();
            this.getWindowVisibleDisplayFrame(displayRect);
            this.adjustHeight(displayRect);
        }
    }

    @Override
    public void show() {
        this.setFillrToolbarVisible(0);
    }

    @Override
    public void remind() {
        Timber.d((String)"remind user", (Object[])new Object[0]);
    }

    @Override
    public void hide() {
        this.setFillrToolbarVisible(4);
    }

    @Override
    public void setVisibility(boolean visible) {
        this.setFillrToolbarVisible(visible ? 0 : 4);
    }
}

