/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk;

import android.content.Context;
import android.support.annotation.VisibleForTesting;
import com.fillr.browsersdk.FeatureToggleManager;
import com.fillr.browsersdk.Fillr;
import com.fillr.featuretoggle.DefaultUnleash;
import com.fillr.featuretoggle.Unleash;
import com.fillr.featuretoggle.UnleashContext;
import com.fillr.featuretoggle.strategy.BlackListUrlStrategy;
import com.fillr.featuretoggle.strategy.DevKeyStrategy;
import com.fillr.featuretoggle.strategy.Strategy;
import com.fillr.featuretoggle.util.UnleashConfig;
import java.util.HashMap;

public class FeatureToggleManagerImp
implements FeatureToggleManager {
    private static FeatureToggleManager instance;
    private static Unleash unleash;

    private FeatureToggleManagerImp() {
    }

    public static FeatureToggleManager getInstance() {
        if (instance == null) {
            instance = new FeatureToggleManagerImp();
        }
        return instance;
    }

    @Override
    public void updateFeatureToggles(Context context) {
        if (unleash == null) {
            UnleashConfig config = UnleashConfig.builder().unleashAPI("https://ft.fillr.com/api").appName("fillr-android-feature-toggle").instanceId("fillr-instance ").fetchTogglesInterval(300L).sendMetricsInterval(300L).localCopyFileName("unleash_features.json").disableMetrics().synchronousFetchOnInitialisation(true).build();
            config.username = "fillr";
            config.password = "zD9mwUEc3WWppo4CYB2pYHdxmY4MFA";
            unleash = new DefaultUnleash(context, config, new Strategy[]{new DevKeyStrategy(), new BlackListUrlStrategy()});
        } else {
            unleash.refreshToggles(context);
        }
    }

    private boolean isFeatureEnabledForProperties(String name, HashMap<String, String> properties) {
        boolean retVal = false;
        if (unleash != null) {
            UnleashContext unleashContext = new UnleashContext("user_id_test", "session_id_test", "remoteaddres_test", properties);
            retVal = unleash.isEnabled(name, unleashContext);
        }
        return retVal;
    }

    private boolean isFeatureEnabledForUrl(String featureName, String urlString) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (Fillr.getInstance().getDeveloperKey() != null) {
            properties.put("devkey", Fillr.getInstance().getDeveloperKey());
        }
        if (urlString != null) {
            properties.put("url", urlString);
        }
        return this.isFeatureEnabledForProperties(featureName, properties);
    }

    private boolean isFeatureEnabled(String featureName) {
        return this.isFeatureEnabledForUrl(featureName, null);
    }

    @Override
    public boolean isUrlEnabled(String urlString) {
        if (urlString != null && urlString.length() > 0) {
            return !this.isFeatureEnabledForUrl("DisableURL", urlString);
        }
        return true;
    }

    @Override
    public boolean isCaptureValueEnabled() {
        return this.isFeatureEnabled("CaptureValues");
    }

    @Override
    public boolean isCaptureCreditCardEnabled() {
        return this.isFeatureEnabled("CaptureCreditCard");
    }

    @Override
    public boolean isAbandonmentTrackingEnabled() {
        return this.isFeatureEnabled("AbandonmentTracking");
    }

    @Override
    public boolean isAndroidNativeAutofillEnabled() {
        return this.isFeatureEnabled("AndroidNativeAutofill");
    }

    @Override
    public boolean isFieldHighlightEnabled() {
        return this.isFeatureEnabled("HighlightFilledFields");
    }

    @Override
    public boolean isiFrameSupportDisabled(String urlString) {
        return this.isFeatureEnabledForUrl("DisableIframeAutofilling", urlString);
    }

    @Override
    public boolean isPINEnabled() {
        return this.isFeatureEnabled("PIN");
    }

    @Override
    public boolean isSendDemographicStatsEnabled() {
        return this.isFeatureEnabled("SendDemographicStats");
    }

    @Override
    public boolean isSensitiveFieldsPromptEnabled() {
        return this.isFeatureEnabled("SensitiveFieldsPrompt");
    }

    @Override
    public String getToggleCollectionAsStringOutput() {
        return unleash.getToggleCollectionAsStringOutput();
    }

    @VisibleForTesting
    public static void setInstance(FeatureToggleManager testInstance) {
        instance = testInstance;
    }

    static {
        unleash = null;
    }
}

