/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk.utilities;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FillrUtils {
    private static final String LOGTAG = "FillrSDK";

    public static void hideKeyboard(Activity activity) {
        View view;
        if (activity != null && (view = activity.getCurrentFocus()) != null) {
            InputMethodManager inputManager = (InputMethodManager)activity.getSystemService("input_method");
            inputManager.hideSoftInputFromWindow(view.getWindowToken(), 2);
        }
    }

    public static void hideKeyboard(Context context, View view) {
        if (view != null) {
            InputMethodManager inputManager = (InputMethodManager)context.getSystemService("input_method");
            inputManager.hideSoftInputFromWindow(view.getWindowToken(), 2);
        }
    }

    public static float convertPixelsToDp(float px) {
        DisplayMetrics metrics = Resources.getSystem().getDisplayMetrics();
        return px / ((float)metrics.densityDpi / 160.0f);
    }

    public static int convertDpToPixels(int dp) {
        DisplayMetrics metrics = Resources.getSystem().getDisplayMetrics();
        return (int)((float)dp * metrics.density + 0.5f);
    }

    public static boolean isPackageInstalled(String packagename, Context context) {
        if (context == null) {
            return false;
        }
        try {
            PackageManager pm = context.getPackageManager();
            if (pm != null) {
                pm.getPackageInfo(packagename, 1);
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.d((String)LOGTAG, (String)("no package found for " + packagename));
        }
        return false;
    }

    public static boolean androidApiIceCreamSandwichOrHigher() {
        return FillrUtils.androidApiIsGreaterThanOrEqualTo(14);
    }

    public static boolean androidApiIsGreaterThanOrEqualTo(int androidVersion) {
        return Build.VERSION.SDK_INT >= androidVersion;
    }

    public static String sanitiseJsonString(String json) {
        json = json.replaceAll("(\\\\t|\\\\n|\\\\r|%0A)", " ");
        json = json.replaceAll("(?<!\\\\)'", "\\\\'");
        json = json.replaceAll("\\\\\"", "");
        return json;
    }

    public static boolean excludeByDomain(String domain) {
        if (domain == null) {
            return false;
        }
        ArrayList<String> exclusions = new ArrayList<String>();
        exclusions.add(".*\\.mplore\\.com");
        for (String pattern : exclusions) {
            if (!domain.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    public static void launchPlaystore(Context context, String campaignUrl) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)campaignUrl));
            if (context != null && intent.resolveActivity(context.getPackageManager()) != null) {
                context.startActivity(intent);
            }
        }
        catch (Exception e) {
            Log.e((String)FillrUtils.class.getSimpleName(), (String)e.getMessage());
        }
    }

    public static boolean noFieldInForm(JSONObject fields) {
        try {
            JSONArray widgetFields = fields.getJSONArray("fields");
            return widgetFields == null || widgetFields.length() == 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileFromAssets(Context context, String fileName) {
        StringBuilder buf = new StringBuilder();
        BufferedReader in = null;
        InputStream json = null;
        try {
            String str;
            json = context.getAssets().open(fileName);
            in = new BufferedReader(new InputStreamReader(json, "UTF-8"));
            while ((str = in.readLine()) != null) {
                buf.append(str);
            }
            in.close();
            String string2 = buf.toString();
            return string2;
        }
        catch (IOException e) {
            String string3 = null;
            return string3;
        }
        finally {
            try {
                if (json != null) {
                    json.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                Log.d((String)LOGTAG, (String)ex.getMessage());
            }
        }
    }

    public static String getDomainName(String url) throws IndexOutOfBoundsException {
        if (url == null) {
            return null;
        }
        return url.startsWith("www.") ? url.substring(4) : url;
    }

    public static void setClipboardData(String key, String value, Context parentActivity) {
        if (parentActivity != null) {
            ClipboardManager clipboard = (ClipboardManager)parentActivity.getSystemService("clipboard");
            ClipData clip = ClipData.newPlainText((CharSequence)key, (CharSequence)value);
            if (clip != null && clipboard != null) {
                clipboard.setPrimaryClip(clip);
            }
        }
    }

    public static String getClipboardData(Context parentActivity) {
        ClipData data;
        String shouldTrigger = null;
        ClipboardManager clipboard = (ClipboardManager)parentActivity.getSystemService("clipboard");
        if (clipboard != null && clipboard.hasPrimaryClip() && (data = clipboard.getPrimaryClip()) != null && data.getItemCount() > 0) {
            shouldTrigger = String.valueOf(data.getItemAt(0).getText());
        }
        return shouldTrigger;
    }

    public static List<String> jsonToList(JSONArray array) throws JSONException {
        if (array == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int index = 0; index < array.length(); ++index) {
            result.add(array.get(index).toString());
        }
        return result;
    }

    public static String streamToString(InputStream data) {
        try {
            Scanner s = new Scanner(data, "UTF-8").useDelimiter("\\A");
            String res = s.next();
            data.close();
            return res;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static JSONObject parsedJsonOrNull(String json) {
        try {
            return new JSONObject(json);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static void logInfo(String msg) {
        Log.d((String)LOGTAG, (String)msg);
    }
}

