/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk.model;

import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import com.fillr.browsersdk.Fillr;
import com.fillr.browsersdk.model.FillrPageEventPayloadBuilder;
import com.fillr.browsersdk.model.FillrWidgetPageEvent;
import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.json.JSONObject;

public class FillrInterceptRequest {
    private static final String LOGTAG = "FillrInterceptRequest";
    private static final long GRACE_PERIOD_MILLIS = 1000L;
    private String mWidgetHeader = null;

    public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
        return this.shouldInterceptRequest(view, request, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request, String lastUrl, String clickInfo) {
        if (Build.VERSION.SDK_INT >= 21 && request != null) {
            String accept;
            Log.d((String)LOGTAG, (String)request.getUrl().toString());
            if (request.isForMainFrame()) {
                Log.d((String)LOGTAG, (String)"Main Frame: true");
                String pageEvent = this.processPageEvent(request, lastUrl, clickInfo);
                if (lastUrl != null && clickInfo != null && pageEvent != null) {
                    return new WebResourceResponse("fillr/json", "utf-8", (InputStream)new ByteArrayInputStream(pageEvent.getBytes(Charsets.UTF_8)));
                }
            }
            if (request.getRequestHeaders().containsKey("Accept") && !request.isForMainFrame() && ((accept = (String)request.getRequestHeaders().get("Accept")).contains("text/html") || accept.contains("application/xhtml") || accept.contains("application/xml"))) {
                HttpURLConnection urlConnection = null;
                try {
                    URL url = new URL(request.getUrl().toString());
                    URLConnection tempConn = url.openConnection();
                    if (tempConn instanceof HttpURLConnection) {
                        urlConnection = (HttpURLConnection)tempConn;
                        urlConnection.setConnectTimeout(10000);
                        urlConnection.setReadTimeout(10000);
                        int responseCode = urlConnection.getResponseCode();
                        Log.d((String)LOGTAG, (String)("responseCode: " + responseCode));
                        if (responseCode == 200) {
                            byte[] pageContents = ByteStreams.toByteArray((InputStream)urlConnection.getInputStream());
                            pageContents = this.enableIntercept(pageContents).getBytes("UTF-8");
                            WebResourceResponse webResourceResponse = new WebResourceResponse("text/html", "UTF-8", (InputStream)new ByteArrayInputStream(pageContents));
                            return webResourceResponse;
                        }
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (urlConnection != null) {
                        urlConnection.disconnect();
                    }
                }
            }
        }
        return null;
    }

    private String processPageEvent(WebResourceRequest request, String url, String clickJson) {
        String requestedWith;
        if (Build.VERSION.SDK_INT >= 21 && !TextUtils.isEmpty((CharSequence)clickJson) && request.getRequestHeaders() != null && !"xmlhttprequest".equalsIgnoreCase(requestedWith = (String)request.getRequestHeaders().get("HTTP_X_REQUESTED_WITH"))) {
            try {
                boolean wasSuccessful;
                JSONObject clickInfo = new JSONObject(clickJson);
                long now = System.currentTimeMillis();
                long clickTime = clickInfo.getLong("time");
                long elapsed = now - clickTime;
                if (clickTime > 0L) {
                    clickInfo.put("elapsedMs", elapsed);
                }
                if (!(wasSuccessful = request.hasGesture()) && elapsed < 1000L) {
                    wasSuccessful = true;
                }
                JSONObject payload = FillrPageEventPayloadBuilder.create(url).setExtraInfo(clickInfo).setEventType(wasSuccessful ? FillrWidgetPageEvent.NAVIGATION : FillrWidgetPageEvent.CLOSE).buildJson();
                return payload.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private String enableIntercept(byte[] data) throws IOException {
        Fillr fillr = Fillr.getInstance();
        if (this.mWidgetHeader == null && fillr != null && fillr.getFillrWidget() != null && fillr.getFillrWidget().widgetAvailable()) {
            this.mWidgetHeader = "<script type=\"text/javascript\">" + fillr.getFillrWidget().getWidgetJavaScript() + "</script>";
        }
        StringBuffer sb = new StringBuffer(new String(data));
        if (this.mWidgetHeader != null) {
            sb.append(this.mWidgetHeader);
        }
        return sb.toString();
    }
}

