/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.fillr.browsersdk.EmbeddedBrowser;
import com.fillr.browsersdk.Fillr;
import com.fillr.browsersdk.FillrActionView;
import com.fillr.browsersdk.FillrActionViewInternalEventListener;
import com.fillr.browsersdk.FillrToolbarAnimation;
import com.fillr.browsersdk.R;
import com.fillr.browsersdk.model.FillrBrowserProperties;
import com.fillr.browsersdk.utilities.FillrUtils;

public class FillrToolbarView
extends RelativeLayout
implements FillrActionView,
View.OnClickListener {
    private static final String LOGTAG = "FillrSDK";
    private boolean alreadyInitialized = false;
    private FillrActionViewInternalEventListener fillrToolbarViewInternalEventListener;
    private FillrToolbarAnimation toolbarAnimation;
    private Context mContext;
    private ImageView autofillIcon;
    private TextView autofillTextView;
    private ImageView dismissImageView;
    private Button dismissButton;
    private View lineSeparatorView;
    private int mToolbarBackgroundColor = Color.parseColor((String)"#E2E8E8");
    private int mToolbarDividerBackgroundColor = Color.parseColor((String)"#CCCCCC");
    private ColorStateList mToolbarTextColor = this.getResources().getColorStateList(R.color.toolbar_text_color);
    private int mDismissImageView = R.drawable.com_fillr_keyboard_arrow_down;
    private static final int MIN_TOOLBAR_SPACE_DP = 175;
    private static final int MIN_LANDSCAPE_TOOL_BAR_HEIGHT_DP = 35;
    private static final int MAX_LANDSCAPE_TOOL_BAR_HEIGHT_DP = 50;

    public FillrToolbarView(Context context) {
        super(context);
        this.initViews(context);
    }

    public FillrToolbarView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FillrToolbarView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initViews(context);
    }

    private void initViews(Context context) {
        Fillr instance = Fillr.getInstance();
        if (instance != null) {
            instance.setToolbarView(this);
        }
        if (!FillrUtils.androidApiIceCreamSandwichOrHigher()) {
            this.setVisibility(4);
            return;
        }
        if (this.alreadyInitialized) {
            return;
        }
        this.alreadyInitialized = true;
        this.mContext = context;
        int checkExistence = this.mContext.getResources().getIdentifier("fillr_toolbar", "style", this.mContext.getPackageName());
        if (checkExistence != 0) {
            Log.d((String)LOGTAG, (String)"Style exists!");
            int[] attrs = new int[]{R.attr.fillrToolbarTextColor, R.attr.fillrToolbarBG};
            TypedArray ta = this.mContext.obtainStyledAttributes(checkExistence, attrs);
            if (ta != null && ta.length() > 0) {
                this.mToolbarTextColor = ta.getColorStateList(R.styleable.fillr_toolbar_attributes_fillrToolbarTextColor);
                this.mToolbarBackgroundColor = ta.getColor(R.styleable.fillr_toolbar_attributes_fillrToolbarBG, this.mToolbarBackgroundColor);
                ta.recycle();
            }
        } else {
            Log.d((String)LOGTAG, (String)"Style does not exist");
        }
        int checkDismissImageExistence = this.mContext.getResources().getIdentifier("com_fillr_toolbar_dismiss_image", "drawable", this.mContext.getPackageName());
        if (checkDismissImageExistence != 0) {
            this.mDismissImageView = checkDismissImageExistence;
        }
        this.setBackgroundColor(context.getResources().getColor(R.color.com_fillr_toobar_color_transparent));
        LinearLayout mainContainer = new LinearLayout(context);
        mainContainer.setOrientation(0);
        RelativeLayout.LayoutParams relativeParams = null;
        this.autofillIcon = new ImageView(context);
        LinearLayout.LayoutParams leftContainerParams = new LinearLayout.LayoutParams(-2, -1);
        leftContainerParams.setMargins(this.dpToPixel(context, 15), 0, 0, 0);
        mainContainer.addView((View)this.autofillIcon, (ViewGroup.LayoutParams)leftContainerParams);
        this.autofillIcon.setVisibility(4);
        this.autofillTextView = new TextView(context);
        this.autofillTextView.setTextColor(this.getFillrTextColor());
        this.autofillTextView.setText(context.getText(R.string.use_secure_fillr_tool_bar_text));
        this.autofillTextView.setTextSize(2, 16.0f);
        this.autofillTextView.setMaxLines(2);
        this.autofillTextView.setGravity(19);
        this.autofillTextView.setVisibility(4);
        leftContainerParams = new LinearLayout.LayoutParams(-2, -1);
        leftContainerParams.setMargins(this.dpToPixel(context, 7), 0, this.dpToPixel(context, 10), 0);
        leftContainerParams.gravity = 16;
        mainContainer.addView((View)this.autofillTextView, (ViewGroup.LayoutParams)leftContainerParams);
        this.dismissImageView = new ImageView(context);
        this.dismissImageView.setImageResource(R.drawable.com_fillr_keyboard_arrow_down);
        this.dismissImageView.setId(R.id.id_btn_yes);
        relativeParams = new RelativeLayout.LayoutParams(this.dpToPixel(context, 14), this.dpToPixel(context, 8));
        relativeParams.addRule(11);
        relativeParams.addRule(15);
        relativeParams.setMargins(this.dpToPixel(context, 15), 0, this.dpToPixel(context, 15), 0);
        this.addView((View)this.dismissImageView, (ViewGroup.LayoutParams)relativeParams);
        this.dismissButton = new Button(context);
        this.dismissButton.setAlpha(0.0f);
        relativeParams = new RelativeLayout.LayoutParams(this.dpToPixel(context, 45), -1);
        relativeParams.addRule(11);
        relativeParams.addRule(15);
        this.addView((View)this.dismissButton, (ViewGroup.LayoutParams)relativeParams);
        this.lineSeparatorView = new View(context);
        this.lineSeparatorView.setId(R.id.line_seperator);
        this.lineSeparatorView.setBackgroundResource(R.color.com_fillr_browsersdk_toolbar_line);
        this.lineSeparatorView.setBackgroundColor(this.mToolbarDividerBackgroundColor);
        relativeParams = new RelativeLayout.LayoutParams(this.dpToPixel(context, 1), -1);
        relativeParams.addRule(0, this.dismissImageView.getId());
        relativeParams.addRule(15);
        relativeParams.setMargins(this.dpToPixel(context, 5), this.dpToPixel(context, 8), this.dpToPixel(context, 1), this.dpToPixel(context, 8));
        this.addView(this.lineSeparatorView, (ViewGroup.LayoutParams)relativeParams);
        relativeParams = new RelativeLayout.LayoutParams(-2, -1);
        relativeParams.addRule(9);
        relativeParams.addRule(15);
        relativeParams.setMargins(0, 0, this.dpToPixel(context, 15), 0);
        this.addView((View)mainContainer, (ViewGroup.LayoutParams)relativeParams);
        this.dismissButton.setOnClickListener((View.OnClickListener)this);
        this.autofillIcon.setImageResource(this.getFillrBarDrawable());
        this.autofillTextView.setText((CharSequence)this.getFillrToolbarText());
        this.integratorSpecificStyle();
        Log.d((String)LOGTAG, (String)"setting invisible");
        this.setVisibility(4);
    }

    private void adjustHeight(Rect displayRect) {
        if (displayRect != null) {
            int availableSpace = (int)FillrUtils.convertPixelsToDp(displayRect.bottom);
            int toolbarHeight = availableSpace < 175 ? 35 : 50;
            int toolbarHeighInPX = FillrUtils.convertDpToPixels(toolbarHeight);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, toolbarHeighInPX);
            layoutParams.addRule(12);
            layoutParams.setMargins(0, 0, 0, 0);
            this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    public void setFillrToolbarVisible(int visibility) {
        this.setVisibility(visibility);
        this.autofillTextView.setVisibility(visibility);
        this.autofillIcon.setVisibility(visibility);
        this.invalidate();
    }

    public int getFillrToolbarVisibility() {
        return this.getVisibility();
    }

    public TextView getAutofillTextView() {
        return this.autofillTextView;
    }

    public ImageView getAutofillIcon() {
        return this.autofillIcon;
    }

    public void onClick(View view) {
        if (view == this.dismissButton && this.fillrToolbarViewInternalEventListener != null) {
            this.fillrToolbarViewInternalEventListener.onDismissButtonClicked();
        }
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == 0) {
            Fillr.getInstance().notifyToolbarVisibilityChanged(Fillr.ToolbarViewVisibility.VISIBLE);
        } else {
            Fillr.getInstance().notifyToolbarVisibilityChanged(Fillr.ToolbarViewVisibility.INVISIBLE);
        }
    }

    private void integratorSpecificStyle() {
        String developerKey;
        EmbeddedBrowser embeddedBrowser;
        Fillr instance = Fillr.getInstance();
        if (instance != null && (embeddedBrowser = EmbeddedBrowser.getEmbeddedBrowser(developerKey = instance.getDeveloperKey())) == EmbeddedBrowser.EBATES) {
            this.dismissImageView.setVisibility(8);
            this.dismissButton.setVisibility(8);
            this.lineSeparatorView.setVisibility(8);
        }
    }

    private String getFillrToolbarText() {
        FillrBrowserProperties browserProps;
        String text = (String)this.mContext.getText(R.string.fillr_fill_tool_bar_text);
        Fillr instance = Fillr.getInstance();
        if (instance != null && (browserProps = instance.getBrowserProps()) != null) {
            text = browserProps.getToolbarName();
        }
        return text;
    }

    private int getFillrBarDrawable() {
        FillrBrowserProperties browserProps;
        int retVal = R.drawable.icon_fillr_toolbar;
        Fillr instance = Fillr.getInstance();
        if (instance != null && (browserProps = instance.getBrowserProps()) != null) {
            retVal = browserProps.getToolbarDrawable();
        }
        return retVal;
    }

    private int getFillrTextColor() {
        FillrBrowserProperties browserProps;
        int color2 = this.mContext.getResources().getColor(R.color.com_fillr_toolbar_autofill_text_color);
        Fillr instance = Fillr.getInstance();
        if (instance != null && (browserProps = instance.getBrowserProps()) != null) {
            color2 = browserProps.getToolbarTextColor();
        }
        return color2;
    }

    private int dpToPixel(Context context, int dp) {
        Resources resources = context.getResources();
        int px = (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)resources.getDisplayMetrics());
        return px;
    }

    @Override
    public void setActivity(Context context) {
        this.toolbarAnimation = new FillrToolbarAnimation(context, this);
    }

    @Override
    public void setFillrActionViewInternalEventListener(FillrActionViewInternalEventListener fillrToolbarViewInternalEventListener) {
        this.fillrToolbarViewInternalEventListener = fillrToolbarViewInternalEventListener;
    }

    @Override
    public void orientationChange(boolean isLandsacpe) {
        Log.d((String)LOGTAG, (String)"showToolbar:!animationInProgess");
        if (!this.toolbarAnimation.animationInProgress() && isLandsacpe) {
            Rect displayRect = new Rect();
            this.getWindowVisibleDisplayFrame(displayRect);
            this.adjustHeight(displayRect);
        }
    }

    @Override
    public void show() {
        if (this.toolbarAnimation == null) {
            Log.d((String)LOGTAG, (String)"showToolbar:toolbarAnimation = null");
            return;
        }
        this.toolbarAnimation.startSlideUpToolbarAnimation();
    }

    @Override
    public void remind() {
        if (this.toolbarAnimation == null) {
            Log.d((String)LOGTAG, (String)"showToolbar:toolbarAnimation = null");
            return;
        }
        this.toolbarAnimation.startShakeToolbarAnimation();
    }

    @Override
    public void hide() {
        this.toolbarAnimation.resetAnimationState();
        this.setFillrToolbarVisible(4);
    }

    @Override
    public void setVisibility(boolean visible) {
        this.setFillrToolbarVisible(visible ? 0 : 4);
    }
}

