/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import com.fillr.browsersdk.FillrToolbarView;
import com.fillr.browsersdk.R;

class FillrToolbarAnimation {
    private Animation mFadeInSlideUpAnimation;
    private Animation mSlideUpNoFade;
    private Animation mSlideInLeft;
    private Animation mFadeOutTextAnimation;
    private Animation mFadeOutText2Animation;
    private Context mContext;
    private FillrToolbarView mToolbarInstance;
    private Handler mHandler;
    private boolean mAnimationInProgress = false;
    private Runnable postDelayedSlideUpAnimation = new Runnable(){

        @Override
        public void run() {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (FillrToolbarAnimation.this.mToolbarInstance != null && FillrToolbarAnimation.this.mSlideUpNoFade != null) {
                        FillrToolbarAnimation.this.mToolbarInstance.startAnimation(FillrToolbarAnimation.this.mSlideUpNoFade);
                    }
                }
            });
        }
    };
    private Runnable postDelayedFadeInSlideUp = new Runnable(){

        @Override
        public void run() {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (FillrToolbarAnimation.this.mToolbarInstance.getAutofillTextView() != null && FillrToolbarAnimation.this.mFadeInSlideUpAnimation != null) {
                        FillrToolbarAnimation.this.mToolbarInstance.getAutofillTextView().startAnimation(FillrToolbarAnimation.this.mFadeInSlideUpAnimation);
                    }
                    if (FillrToolbarAnimation.this.mToolbarInstance.getAutofillIcon() != null && FillrToolbarAnimation.this.mSlideInLeft != null) {
                        FillrToolbarAnimation.this.mToolbarInstance.getAutofillIcon().startAnimation(FillrToolbarAnimation.this.mSlideInLeft);
                    }
                    FillrToolbarAnimation.this.mToolbarInstance.setFillrToolbarVisible(0);
                }
            });
        }
    };

    public FillrToolbarAnimation(Context context, FillrToolbarView toolbarInstance) {
        this.mContext = context;
        this.mToolbarInstance = toolbarInstance;
    }

    private void initializeFadeOutAnimations() {
        this.mFadeOutTextAnimation = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.fade_in_fade_out);
        this.mFadeOutText2Animation = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.fade_in_fade_out);
    }

    private void initializeSlideInAnimations() {
        this.mFadeInSlideUpAnimation = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.text_slide_up);
        this.mSlideUpNoFade = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.toolbar_slide_up_original);
        this.mSlideInLeft = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.slide_in_left_);
        this.mFadeInSlideUpAnimation.setFillAfter(true);
        this.mSlideUpNoFade.setFillAfter(true);
        this.mSlideInLeft.setFillAfter(true);
    }

    public void resetAnimationState() {
        if (this.mToolbarInstance.getAutofillIcon() != null) {
            this.mToolbarInstance.getAutofillIcon().clearAnimation();
        }
        if (this.mToolbarInstance.getAutofillTextView() != null) {
            this.mToolbarInstance.getAutofillTextView().clearAnimation();
        }
        if (this.mToolbarInstance != null) {
            this.mToolbarInstance.clearAnimation();
        }
        this.mFadeInSlideUpAnimation = null;
        this.mSlideUpNoFade = null;
        this.mSlideInLeft = null;
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler = null;
        }
        this.mAnimationInProgress = false;
    }

    public boolean animationInProgress() {
        return this.mAnimationInProgress;
    }

    public void startShakeToolbarAnimation() {
        if (!this.mAnimationInProgress) {
            this.mAnimationInProgress = true;
            this.initializeFadeOutAnimations();
            this.mFadeOutTextAnimation.setDuration(1200L);
            this.mFadeOutText2Animation.setDuration(1200L);
            this.mFadeOutText2Animation.setAnimationListener(this.genericAnimationListener());
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    FillrToolbarAnimation.this.mToolbarInstance.getAutofillTextView().startAnimation(FillrToolbarAnimation.this.mFadeOutTextAnimation);
                    FillrToolbarAnimation.this.mToolbarInstance.getAutofillIcon().startAnimation(FillrToolbarAnimation.this.mFadeOutText2Animation);
                }
            });
        }
    }

    public void startSlideUpToolbarAnimation() {
        if (!this.mAnimationInProgress) {
            this.mAnimationInProgress = true;
            this.initializeSlideInAnimations();
            if (this.mHandler == null) {
                this.mHandler = new Handler();
                this.mHandler.postDelayed(this.postDelayedSlideUpAnimation, 300L);
                this.mHandler.postDelayed(this.postDelayedFadeInSlideUp, 550L);
                this.mSlideInLeft.setAnimationListener(this.genericAnimationListener());
                this.mSlideUpNoFade.setAnimationListener(this.genericAnimationListener());
                this.mFadeInSlideUpAnimation.setAnimationListener(this.genericAnimationListener());
            }
        }
    }

    private Animation.AnimationListener genericAnimationListener() {
        return new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation prog) {
                FillrToolbarAnimation.this.resetAnimationState();
            }

            public void onAnimationRepeat(Animation animation) {
            }
        };
    }
}

