/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk.model;

import com.fillr.browsersdk.model.FillrWebView;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class FillrWebViewMapper {
    private static FillrWebViewMapper _instance = null;
    HashMap<UUID, FillrWebView> webViews = new HashMap();

    private FillrWebViewMapper() {
    }

    public static FillrWebViewMapper getInstance() {
        if (_instance == null) {
            _instance = new FillrWebViewMapper();
        }
        return _instance;
    }

    public FillrWebView getWebViewForId(String viewId) {
        FillrWebView currWebview = null;
        for (Map.Entry<UUID, FillrWebView> uuidFillrWebViewEntry : this.webViews.entrySet()) {
            if (!uuidFillrWebViewEntry.getKey().toString().equals(viewId)) continue;
            currWebview = uuidFillrWebViewEntry.getValue();
            break;
        }
        return currWebview;
    }

    public String getWebviewReference(FillrWebView trackedWebview) {
        String retVal = null;
        boolean alreadyExists = false;
        if (this.webViews.size() > 0) {
            for (Map.Entry<UUID, FillrWebView> allWebview : this.webViews.entrySet()) {
                FillrWebView temp = allWebview.getValue();
                if (temp == null || !temp.equals(trackedWebview)) continue;
                alreadyExists = true;
                retVal = allWebview.getKey().toString();
            }
        }
        if (!alreadyExists) {
            retVal = this.mapWebView(trackedWebview);
        }
        return retVal;
    }

    public FillrWebView getByUUID(UUID uuid) {
        return this.webViews.get(uuid);
    }

    public String mapWebView(FillrWebView webView) {
        UUID uuid = UUID.randomUUID();
        this.webViews.put(uuid, webView);
        return uuid.toString();
    }
}

