/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk.model;

import android.util.Log;
import com.fillr.browsersdk.utilities.FillrUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FillrMapping {
    private static final String TAG = "Fill Mapping";
    private static final String USERNAME = "Usernames.Username.Username";
    private static final int INDEX_USERNAME = 0;
    private static final int INDEX_EMAIL = 1;
    private final JSONObject formMetaData;
    private final List<String> fields;
    private Map<String, String> profileData;
    private Map<String, Integer> fieldSelections;
    private long startTime;

    public FillrMapping(JSONObject mappingResult, List<String> fields) {
        this.formMetaData = mappingResult;
        this.fields = fields;
    }

    public JSONObject getFormMappings() {
        return this.getFormMappings(false);
    }

    public JSONObject getFormMappings(boolean applyFieldSelections) {
        return applyFieldSelections ? this.applyFieldSelectionsToMappings() : this.formMetaData;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public Map<String, Integer> getFieldSelections() {
        if (this.fieldSelections != null) {
            return this.fieldSelections;
        }
        String payload = this.getProfileData();
        HashMap<String, Integer> defaultSelections = new HashMap<String, Integer>();
        defaultSelections.put(USERNAME, payload != null && payload.contains(USERNAME) ? 0 : 1);
        return defaultSelections;
    }

    public void setFieldSelections(Map<String, Integer> selections) {
        this.fieldSelections = selections;
    }

    public void setProfileData(Map<String, String> profileData) {
        this.profileData = profileData;
    }

    public String getProfileData() {
        if (this.profileData != null) {
            JSONObject profileData = new JSONObject();
            for (Map.Entry<String, String> data : this.profileData.entrySet()) {
                try {
                    profileData.put(data.getKey(), (Object)data.getValue());
                }
                catch (JSONException e) {
                    Log.e((String)TAG, (String)e.getMessage());
                }
            }
            return profileData.toString();
        }
        return null;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean hasFields() {
        return this.fields != null && this.fields.size() > 0;
    }

    public boolean hasProfileData() {
        return this.profileData != null && this.profileData.size() > 0;
    }

    private JSONObject applyFieldSelectionsToMappings() {
        Map<String, Integer> elementSelections = this.getFieldSelections();
        if (elementSelections == null || this.formMetaData == null) {
            return this.formMetaData;
        }
        JSONObject sourceMappings = this.formMetaData;
        try {
            sourceMappings = new JSONObject(sourceMappings.toString());
            JSONArray fields = sourceMappings.getJSONArray("fields");
            for (int index = 0; index < fields.length(); ++index) {
                List<String> fieldParams;
                int targetIndex;
                JSONObject field = fields.getJSONObject(index);
                if (!elementSelections.containsKey(field.getString("param")) || (targetIndex = elementSelections.get(field.getString("param")).intValue()) >= (fieldParams = FillrUtils.jsonToList(field.getJSONArray("params"))).size()) continue;
                String param = fieldParams.get(targetIndex);
                JSONArray newParams = new JSONArray();
                newParams.put((Object)param);
                field.put("param", (Object)param);
                field.put("params", (Object)newParams);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sourceMappings;
    }
}

