/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk.model;

import android.content.Context;
import android.util.Log;
import android.webkit.JavascriptInterface;
import com.fillr.analytics.AnalyticsEvent;
import com.fillr.browsersdk.analytics.FillrAnalyticsManager;
import com.fillr.browsersdk.model.FillrWebView;
import com.fillr.browsersdk.model.FillrWebViewMapper;
import com.fillr.browsersdk.model.FillrWidget;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FillrCartInformationExtraction {
    private final String LOGTAG = "FillrSDK";
    private FillrAnalyticsManager mFillrAnalyticsManager;
    private FillrCartInformationExtractionListener mCartInformationExtractionListener;
    private FillrWidget mCartScraperWidget;
    private FillrWebViewMapper mWebViewMapper;
    private boolean enabled;
    public static final String jniName = "fillrCartInformationExtractionJNI";
    private String mWidget;

    public FillrCartInformationExtraction(FillrAnalyticsManager fillrAnalyticsManager, FillrWidget widget, FillrWebViewMapper webViewMapper) {
        if (webViewMapper == null) {
            throw new IllegalArgumentException("webViewMapper cannot be null");
        }
        if (fillrAnalyticsManager == null) {
            throw new IllegalArgumentException("fillrAnalyticsManager cannot be null");
        }
        if (widget == null) {
            throw new IllegalArgumentException("widget cannot be null");
        }
        this.mFillrAnalyticsManager = fillrAnalyticsManager;
        this.mCartScraperWidget = widget;
        this.mWebViewMapper = webViewMapper;
        this.init();
    }

    private void init() {
        if (this.cartInformationExtractionEnabled() && this.mCartScraperWidget != null) {
            this.mCartScraperWidget.download();
        }
    }

    public void onPageFinished(Context context, FillrWebView webView) {
        if (this.cartInformationExtractionEnabled() && this.mCartScraperWidget != null) {
            this.mCartScraperWidget.setWidgetListener(new FillrWidget.FillrWidgetListener(){

                @Override
                public void onWidgetDownloaded(String widgetJavaScript) {
                }

                @Override
                public void onWidgetInjected(FillrWebView webView) {
                    String webviewReference = FillrCartInformationExtraction.this.mWebViewMapper.getWebviewReference(webView);
                    webView.setViewId(webviewReference);
                    webView.loadJavascript("FillrCartInformationExtractionInterface.setViewId(new String('" + webviewReference + "'))");
                    webView.loadJavascript("FillrCartInformationExtractionInterface.start()");
                }
            });
            this.mCartScraperWidget.inject(webView);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.init();
    }

    public boolean cartInformationExtractionEnabled() {
        return this.enabled;
    }

    public void setListener(FillrCartInformationExtractionListener listener) {
        this.mCartInformationExtractionListener = listener;
    }

    public boolean onCartDetected(JSONObject report) throws JSONException {
        Integer total = null;
        String pageUrl = report.optString("page_url", "");
        String version = report.optString("version", "");
        String currency = report.optString("currency", "");
        if (report.has("cart_total")) {
            total = report.optInt("cart_total", -1);
        }
        ArrayList<FillrCartProduct> productsList = new ArrayList<FillrCartProduct>();
        if (report.has("products")) {
            JSONArray products = report.optJSONArray("products");
            for (int i = 0; i < products.length(); ++i) {
                int quantityInt;
                int lineTotalInt;
                int itemPriceInt;
                JSONObject p = products.optJSONObject(i);
                if (p == null) continue;
                String name = p.optString("name", null);
                String url = p.optString("url", null);
                String imageUrl = p.optString("image_url", null);
                Integer itemPrice = null;
                Integer lineTotal = null;
                Integer quantity = null;
                if (p.has("item_price") && (itemPriceInt = p.optInt("item_price", -1)) >= 0) {
                    itemPrice = new Integer(itemPriceInt);
                }
                if (p.has("line_total") && (lineTotalInt = p.optInt("line_total", -1)) >= 0) {
                    lineTotal = new Integer(lineTotalInt);
                }
                if (p.has("quantity") && (quantityInt = p.optInt("quantity", -1)) >= 0) {
                    quantity = new Integer(quantityInt);
                }
                FillrCartProduct product = new FillrCartProduct(name, url, imageUrl, itemPrice, lineTotal, quantity);
                productsList.add(product);
            }
        }
        FillrCartInformation info = new FillrCartInformation(pageUrl, total, currency, productsList, version);
        info.json = report.toString();
        this.sendAnalyticsEvent(info, report);
        if (this.mCartInformationExtractionListener != null) {
            FillrWebView wv = this.mWebViewMapper.getWebViewForId(report.optString("view_id"));
            this.mCartInformationExtractionListener.onCartDetected(wv.getWebView(), info);
        }
        return true;
    }

    private void sendAnalyticsEvent(FillrCartInformation info, JSONObject json) {
        AnalyticsEvent event = this.mFillrAnalyticsManager.createEvent();
        event.setType("cart_information_extraction");
        event.setCategory("Cart Information Extraction");
        event.setAction("Cart Detected");
        event.setHref(info.pageUrl);
        event.setValue(info.total.toString());
        event.setCartInfoJson(json.toString());
        this.mFillrAnalyticsManager.sendEvent(event);
    }

    public class FillrCartInformationExtractionJNI {
        @JavascriptInterface
        public void cartDetected(String json) {
            try {
                JSONObject report = new JSONObject(json);
                FillrCartInformationExtraction.this.onCartDetected(report);
            }
            catch (JSONException e) {
                Log.d((String)"FillrSDK", (String)"Could not parse cart information from JNI");
            }
        }
    }

    public class FillrCartInformation {
        public final Integer total;
        public final String currency;
        public final ArrayList<FillrCartProduct> products;
        public final String pageUrl;
        public final String version;
        public String json;

        public FillrCartInformation(String pageUrl, Integer total, String currency, ArrayList<FillrCartProduct> products, String version) {
            this.pageUrl = pageUrl;
            this.total = total;
            this.currency = currency;
            this.products = products;
            this.version = version;
        }
    }

    public class FillrCartProduct {
        public final String name;
        public final String url;
        public final String imageUrl;
        public final Integer itemPrice;
        public final Integer lineTotal;
        public final Integer quantity;

        public FillrCartProduct(String name, String url, String imageUrl, Integer itemPrice, Integer lineTotal, Integer quantity) {
            this.name = name;
            this.url = url;
            this.imageUrl = imageUrl;
            this.itemPrice = itemPrice;
            this.lineTotal = lineTotal;
            this.quantity = quantity;
        }
    }

    public static interface FillrCartInformationExtractionListener {
        public void onCartDetected(Object var1, FillrCartInformation var2);
    }
}

