/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk.model;

import android.util.Log;
import com.fillr.browsersdk.Fillr;
import com.fillr.browsersdk.apiclient.FillrMappingServiceClient;
import com.fillr.browsersdk.controllers.AutofillPromptInterface;
import com.fillr.browsersdk.model.FillrWebView;
import com.fillr.browsersdk.model.FillrWebViewMapper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class FillrBasePrompt
implements AutofillPromptInterface {
    public static final String TAG = "FillrBasePrompt";
    static final String EXTRA_KEY_FIELDS = "com.fillr.jsonfields";
    static final String EXTRA_NEW_PAGE = "com.fillr.isnewpage";
    protected boolean isNewPage = false;
    Fillr mFillr;
    FillrWebViewMapper mWebViewMapper;

    FillrBasePrompt(FillrWebViewMapper webViewMapper) {
        this.mWebViewMapper = webViewMapper;
    }

    protected abstract void fillrJNISetFields(String var1);

    protected abstract void fillrJNISetFillResult(String var1);

    protected abstract void fillrJNIFieldFocused(String var1);

    protected abstract void fillrJNIFieldBlurred(String var1);

    protected abstract void showPrompt();

    protected abstract void fillrJNICheckFields(String var1);

    protected abstract void fillrJNISetWidgetVersion(String var1);

    protected abstract void fillrJNIFormMutation(String var1);

    public void fillrJNISetValues(String fieldsJson, String valuesJson) {
        FillrMappingServiceClient fillrMappingServiceClient;
        boolean sent;
        if (this.mFillr.getFillMode() != Fillr.FillMode.HEADLESS && (sent = (fillrMappingServiceClient = new FillrMappingServiceClient(this.mFillr)).sendValuesToProfile(fieldsJson, valuesJson, this.isNewPage))) {
            this.isNewPage = false;
        }
    }

    protected boolean hasFields(String mapping) {
        boolean retVal = false;
        try {
            retVal = this.hasFields(new JSONObject(mapping));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return retVal;
    }

    protected boolean hasFields(JSONObject mappings) {
        JSONArray fields = null;
        try {
            fields = mappings.getJSONArray("fields");
        }
        catch (JSONException e) {
            Log.v((String)"INFIELD", (String)e.getMessage());
            return false;
        }
        int mappedFieldsCount = 0;
        for (int i = 0; i < fields.length(); ++i) {
            try {
                JSONObject jsonObject = fields.getJSONObject(i);
                if (jsonObject == null || jsonObject.getString("param").equals("ignore")) continue;
                ++mappedFieldsCount;
                continue;
            }
            catch (JSONException e) {
                Log.d((String)TAG, (String)e.getMessage());
            }
        }
        return mappedFieldsCount > 0;
    }

    void initializeWidget(FillrWebView trackedWebview) {
        String webviewReference = this.mWebViewMapper.getWebviewReference(trackedWebview);
        trackedWebview.setViewId(webviewReference);
        trackedWebview.loadJavascript("PopWidgetInterface.setViewId(new String('" + webviewReference + "'))");
        trackedWebview.loadJavascript("PopWidgetInterface.setupEvents(window);");
        trackedWebview.loadJavascript("PopWidgetInterface.version();");
        if (this.mFillr.getFillMode() == Fillr.FillMode.HEADLESS) {
            trackedWebview.loadJavascript("PopWidgetInterface.startMonitor();");
            trackedWebview.loadJavascript("PopWidgetInterface.getFields();");
        }
    }
}

