/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk.analytics;

import android.content.Context;
import android.util.Log;
import android.webkit.JavascriptInterface;
import com.fillr.analytics.AnalyticsEvent;
import com.fillr.analytics.eventparams.FillrAnalyticsAction;
import com.fillr.analytics.eventparams.FillrAnalyticsCategory;
import com.fillr.analytics.eventparams.FillrAnalyticsScreen;
import com.fillr.browsersdk.EmbeddedBrowser;
import com.fillr.browsersdk.analytics.FillrAnalyticsManager;
import com.fillr.browsersdk.model.FillrWebView;
import com.fillr.browsersdk.utilities.FillrUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class FillrAbandonmentTracking {
    private final String LOGTAG = "FillrSDK";
    private FillrAnalyticsManager mFillrAnalyticsManager;
    private EmbeddedBrowser mEmbeddedBrowser;
    public static final String jniName = "fillrAbandonmentJNI";

    public FillrAbandonmentTracking(FillrAnalyticsManager fillrAnalyticsManager, EmbeddedBrowser browser) {
        this.mFillrAnalyticsManager = fillrAnalyticsManager;
        this.mEmbeddedBrowser = browser;
    }

    public void onPageFinished(Context context, FillrWebView webView) {
        if (this.mFillrAnalyticsManager != null && this.mFillrAnalyticsManager.abandonmentTrackingEnabled()) {
            String script = FillrUtils.getFileFromAssets(context, "Abandonment.js");
            webView.loadJavascript(script);
        }
    }

    boolean sendReport(JSONObject report) {
        if (this.mFillrAnalyticsManager != null && this.mFillrAnalyticsManager.abandonmentTrackingEnabled()) {
            AnalyticsEvent event = this.mFillrAnalyticsManager.createEvent();
            event.setType("abandonment");
            event.setScreen(FillrAnalyticsScreen.WEBVIEW);
            event.setCategory(FillrAnalyticsCategory.ABANDONMENT);
            event.setAction(FillrAnalyticsAction.ABANDONMENT_REPORT);
            try {
                this.mapReportToEvent(event, report);
                this.mFillrAnalyticsManager.sendEvent(event);
                return true;
            }
            catch (JSONException e) {
                Log.e((String)"FillrSDK", (String)e.getMessage());
            }
        }
        return false;
    }

    private void mapReportToEvent(AnalyticsEvent event, JSONObject report) throws JSONException {
        if (report.has("type")) {
            event.setExitAction(report.getString("type"));
        }
        if (report.has("timeOnPage") && report.get("timeOnPage") != JSONObject.NULL) {
            event.setTimeOnPage(Integer.valueOf(report.getInt("timeOnPage")));
        }
        if (report.has("version") && report.get("version") != JSONObject.NULL) {
            event.setAbandonmentClientVersion(report.getString("version"));
        }
        if (report.has("domain") && report.get("domain") != JSONObject.NULL) {
            event.setDomain(report.getString("domain"));
        }
        if (report.has("path") && report.get("path") != JSONObject.NULL) {
            event.setPath(report.getString("path"));
        }
        if (report.has("href") && report.get("href") != JSONObject.NULL) {
            event.setHref(report.getString("href"));
        }
        if (report.has("autofillUsed") && report.get("autofillUsed") != JSONObject.NULL) {
            event.setAutofillUsed(Boolean.valueOf(report.getBoolean("autofillUsed")));
        }
        if (report.has("total") && report.get("total") != JSONObject.NULL) {
            event.setTotalFieldsCount(Integer.valueOf(report.getInt("total")));
        }
        if (report.has("autofilled") && report.get("autofilled") != JSONObject.NULL) {
            event.setAutofilledCount(Integer.valueOf(report.getInt("autofilled")));
        }
        if (report.has("ignored") && report.get("ignored") != JSONObject.NULL) {
            event.setIgnoredCount(Integer.valueOf(report.getInt("ignored")));
        }
        if (report.has("fill_id") && report.get("fill_id") != JSONObject.NULL) {
            event.setFillId(report.getString("fill_id"));
        }
        if (report.has("passwords") && report.get("passwords") != JSONObject.NULL) {
            event.setPasswordsCount(Integer.valueOf(report.getInt("passwords")));
        }
        if (report.has("cards") && report.get("cards") != JSONObject.NULL) {
            event.setCardsCount(Integer.valueOf(report.getInt("cards")));
        }
        if (report.has("id") && report.get("id") != JSONObject.NULL) {
            event.setAbandonmentId(report.getString("id"));
        }
        if (report.has("changedCount") && report.get("changedCount") != JSONObject.NULL) {
            event.setChangedCount(Integer.valueOf(report.getInt("changedCount")));
        }
        if (report.has("changedAfterFill") && report.get("changedAfterFill") != JSONObject.NULL) {
            event.setChangedAfterAutofill(Integer.valueOf(report.getInt("changedAfterFill")));
        }
        if (report.has("changedBeforeFill") && report.get("changedBeforeFill") != JSONObject.NULL) {
            event.setChangedBeforeAutofill(Integer.valueOf(report.getInt("changedBeforeFill")));
        }
    }

    public class FillrAbandonmentJNI {
        @JavascriptInterface
        public void report(String json) {
            try {
                JSONObject report = new JSONObject(json);
                FillrAbandonmentTracking.this.sendReport(report);
            }
            catch (JSONException e) {
                Log.d((String)"FillrSDK", (String)"Could not parse abandonment report from JNI");
            }
        }
    }
}

