/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Rect;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import android.view.ViewTreeObserver;
import com.fillr.browsersdk.EmbeddedBrowser;
import com.fillr.browsersdk.Fillr;
import com.fillr.browsersdk.FillrActionView;
import com.fillr.browsersdk.FillrActionViewInternalEventListener;
import com.fillr.browsersdk.FillrAuthenticationStore;
import com.fillr.browsersdk.analytics.FillrAnalyticsEvents;
import com.fillr.browsersdk.tooltip.SimpleTooltip;
import com.fillr.browsersdk.utilities.FillrDialogHelper;
import com.fillr.browsersdk.utilities.FillrUtils;
import java.lang.ref.WeakReference;
import java.util.Calendar;
import java.util.Date;

public class FillrToolbarManager
implements FillrActionViewInternalEventListener,
ViewTreeObserver.OnGlobalLayoutListener,
View.OnClickListener {
    private static final String LOGTAG = "FillrSDK";
    private Activity parentActivity;
    private WeakReference<FillrActionView> mActionView;
    private String currentUrlDomain = "";
    private boolean isToolbarShown = false;
    private int fieldFocusCount = 0;
    private int orientation = -1;
    private EmbeddedBrowser browser;
    private boolean haveAutoFilledFields = true;
    private SimpleTooltip tourTooltip = null;

    public FillrToolbarManager(Activity parentActivity, EmbeddedBrowser browser) {
        Configuration configuration;
        this.parentActivity = parentActivity;
        Resources resources = parentActivity.getResources();
        if (resources != null && (configuration = resources.getConfiguration()) != null) {
            this.orientation = configuration.orientation;
        }
        this.browser = browser;
    }

    public void setActionView(FillrActionView actionView) {
        actionView.setActivity(this.parentActivity);
        actionView.setFillrActionViewInternalEventListener(this);
        ((View)actionView).getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        ((View)actionView).setOnClickListener((View.OnClickListener)this);
        this.mActionView = new WeakReference<FillrActionView>(actionView);
    }

    public void urlChanged(String newDomain) {
        this.currentUrlDomain = newDomain;
        this.fieldFocusCount = 0;
    }

    public void setToolbarVisible(boolean visible) {
        if (this.mActionView == null) {
            return;
        }
        FillrActionView fillrActionView = (FillrActionView)this.mActionView.get();
        if (fillrActionView == null) {
            return;
        }
        fillrActionView.setVisibility(visible);
    }

    public void fieldFocused() {
        ++this.fieldFocusCount;
        this.showToolbar();
    }

    private FillrActionView getTargetView() {
        if (this.mActionView != null) {
            return (FillrActionView)this.mActionView.get();
        }
        return null;
    }

    private synchronized void showToolbar() {
        if (Fillr.getInstance().getFillMode() == Fillr.FillMode.HEADLESS) {
            Log.d((String)LOGTAG, (String)"in headless mode");
            return;
        }
        FillrActionView targetView = this.getTargetView();
        if (targetView == null) {
            Log.d((String)LOGTAG, (String)"showToolbar:fillrToolbarView = null");
            return;
        }
        if (!this.viewsAreStable((View)targetView)) {
            Log.d((String)LOGTAG, (String)"showToolbar:!viewsAreStable");
            return;
        }
        if (this.shouldHideToolbar()) {
            Log.d((String)LOGTAG, (String)"showToolbar:shouldHideToolbar");
            this.hideToolbar();
            return;
        }
        if (this.isKeyboardUp((View)targetView)) {
            Log.d((String)LOGTAG, (String)"showToolbar:isKeyboardUp");
            targetView.orientationChange(this.isLandscape());
            if (!this.isToolbarShown) {
                Log.d((String)LOGTAG, (String)"showToolbar:!isToolbarShown");
                if (this.parentActivity.hasWindowFocus()) {
                    this.showTour((View)targetView);
                    targetView.show();
                    this.isToolbarShown = true;
                    Fillr.getInstance().trackEvent(FillrAnalyticsEvents.FillrBarShown, new String[0]);
                }
            } else {
                Log.d((String)LOGTAG, (String)("showToolbar:toolbar already visible." + this.fieldFocusCount));
                if (this.fieldFocusCount >= 3) {
                    targetView.remind();
                    this.fieldFocusCount = 0;
                }
            }
        } else {
            Log.d((String)LOGTAG, (String)"showToolbar:keyboard is not up");
            if (this.isToolbarShown) {
                Log.d((String)LOGTAG, (String)"showToolbar:isToolbarShown");
                this.hideToolbar();
            }
        }
    }

    private void showTour(final View rootView) {
        if (this.shouldShowToolbarToolTip() && this.browser == EmbeddedBrowser.EBATES && this.isKeyboardUp(rootView)) {
            Handler handler = new Handler();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (FillrToolbarManager.this.isToolbarShown && !FillrToolbarManager.this.shouldHideToolbar() && FillrToolbarManager.this.isKeyboardUp(rootView) && FillrToolbarManager.this.tourTooltip == null) {
                        FillrToolbarManager.this.tourTooltip = FillrDialogHelper.showToolbarToolTip(FillrToolbarManager.this.parentActivity, rootView, new View.OnClickListener(){

                            public void onClick(View v) {
                                FillrUtils.hideKeyboard(FillrToolbarManager.this.parentActivity);
                                FillrToolbarManager.this.onClick(v);
                            }
                        });
                    } else {
                        FillrToolbarManager.this.clearTourDialogIfVisible();
                    }
                }
            };
            handler.postDelayed(r, 300L);
        }
    }

    private boolean shouldShowToolbarToolTip() {
        int millisecondsInOneDay = 86400000;
        Date dismissDate = EmbeddedBrowser.getTooltipLastDismissDate((Context)this.parentActivity);
        Date currentDate = Calendar.getInstance().getTime();
        return !EmbeddedBrowser.isTooltipAlreadyShown((Context)this.parentActivity) || dismissDate != null && currentDate.getTime() - dismissDate.getTime() > (long)millisecondsInOneDay;
    }

    private void hideToolbar() {
        this.clearTourDialogIfVisible();
        FillrActionView targetView = this.getTargetView();
        if (targetView == null) {
            return;
        }
        this.isToolbarShown = false;
        targetView.hide();
    }

    private void clearTourDialogIfVisible() {
        if (this.tourTooltip != null) {
            this.tourTooltip.dismiss();
            this.tourTooltip = null;
        }
    }

    public void onGlobalLayout() {
        this.showToolbar();
    }

    @Override
    public void onDismissButtonClicked() {
        FillrActionView targetView = this.getTargetView();
        if (targetView == null) {
            return;
        }
        Fillr.getInstance().setToolbarDismissed(true);
        this.hideToolbar();
    }

    public void onClick(View view) {
        Fillr instance = Fillr.getInstance();
        if (instance == null) {
            return;
        }
        Fillr.getInstance().trackEvent(FillrAnalyticsEvents.FillrUseSecureButton, new String[0]);
        final View leftContainer = view;
        leftContainer.setEnabled(false);
        leftContainer.setClickable(false);
        instance.onToolbarClicked(this.isFillrAppInstalled());
        Handler handler = new Handler();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                leftContainer.setEnabled(true);
                leftContainer.setClickable(true);
            }
        };
        handler.postDelayed(r, 2000L);
    }

    private boolean isFillrAppInstalled() {
        return FillrUtils.isPackageInstalled("com.fillr", (Context)this.parentActivity);
    }

    private boolean viewsAreStable(View targetView) {
        if (this.orientation != this.parentActivity.getResources().getConfiguration().orientation) {
            if (!this.isKeyboardUp(targetView)) {
                this.orientation = this.parentActivity.getResources().getConfiguration().orientation;
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean isKeyboardUp(View targetView) {
        Rect displayRect = new Rect();
        targetView.getWindowVisibleDisplayFrame(displayRect);
        int rootHeight = targetView.getRootView().getHeight();
        int keypadHeight = rootHeight - displayRect.bottom;
        return (double)keypadHeight > (double)rootHeight * 0.15;
    }

    private boolean isLandscape() {
        return this.parentActivity.getResources().getConfiguration().orientation == 2;
    }

    private boolean isPageExcluded() {
        return FillrUtils.excludeByDomain(this.currentUrlDomain);
    }

    private boolean shouldHideToolbar() {
        Log.d((String)LOGTAG, (String)"shouldHideToolbar");
        if (!Fillr.getInstance().hasValidWebViewInstance()) {
            Log.d((String)LOGTAG, (String)"!hasValidWebViewInstance");
            return true;
        }
        if (Fillr.getInstance().isToolbarDismissed()) {
            Log.d((String)LOGTAG, (String)"isToolbarDismissed");
            return true;
        }
        if (!FillrAuthenticationStore.isVisible((Context)this.parentActivity)) {
            Log.d((String)LOGTAG, (String)"isVisible");
            return true;
        }
        if (!this.isFillrAppInstalled() && this.isLandscape()) {
            Log.d((String)LOGTAG, (String)"isLandscape");
            return true;
        }
        if (!FillrAuthenticationStore.isEnabled((Context)this.parentActivity)) {
            Log.d((String)LOGTAG, (String)"isEnabled");
            return true;
        }
        if (this.isPageExcluded()) {
            Log.d((String)LOGTAG, (String)"isPageExcluded");
            return true;
        }
        if (!Fillr.getInstance().webViewHasFocus()) {
            Log.d((String)LOGTAG, (String)"!webViewHasFocus");
            return true;
        }
        if (!this.haveAutoFilledFields) {
            Log.d((String)LOGTAG, (String)"haveAutoFilledFields");
            return true;
        }
        return false;
    }

    public void setFillableFieldsFlag(boolean hasFields) {
        this.haveAutoFilledFields = hasFields;
        if (this.shouldHideToolbar()) {
            this.hideToolbar();
        } else {
            this.showToolbar();
        }
    }
}

