/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import android.view.View;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import com.fillr.analytics.eventparams.FillrAnalyticsAction;
import com.fillr.browsersdk.EmbeddedBrowser;
import com.fillr.browsersdk.FillrActionView;
import com.fillr.browsersdk.FillrAuthenticationStore;
import com.fillr.browsersdk.FillrGeckoViewListener;
import com.fillr.browsersdk.FillrOperations;
import com.fillr.browsersdk.FillrToolbarEventListener;
import com.fillr.browsersdk.FillrToolbarManager;
import com.fillr.browsersdk.FillrToolbarView;
import com.fillr.browsersdk.analytics.FillrAbandonmentTracking;
import com.fillr.browsersdk.analytics.FillrAnalyticsEvents;
import com.fillr.browsersdk.analytics.FillrAnalyticsManager;
import com.fillr.browsersdk.apiclient.FillrMappingServiceClient;
import com.fillr.browsersdk.controllers.AutofillPromptFactory;
import com.fillr.browsersdk.controllers.AutofillPromptInterface;
import com.fillr.browsersdk.model.DolphinFillrJSNativeInterface;
import com.fillr.browsersdk.model.DolphinFillrJSNativeInterfaceImpl;
import com.fillr.browsersdk.model.FillrBaseJSInterface;
import com.fillr.browsersdk.model.FillrBasePrompt;
import com.fillr.browsersdk.model.FillrBrowserProperties;
import com.fillr.browsersdk.model.FillrCartInformationExtraction;
import com.fillr.browsersdk.model.FillrEvent;
import com.fillr.browsersdk.model.FillrIntentBuilder;
import com.fillr.browsersdk.model.FillrInterceptRequest;
import com.fillr.browsersdk.model.FillrMapping;
import com.fillr.browsersdk.model.FillrWebView;
import com.fillr.browsersdk.model.FillrWebViewMapper;
import com.fillr.browsersdk.model.FillrWidget;
import com.fillr.browsersdk.utilities.FillrUtils;
import java.util.HashMap;
import org.json.JSONObject;

public final class Fillr
implements FillrOperations {
    public static final int FILLR_REQUEST_CODE = 101;
    private static final String LOGTAG = "FillrSDK";
    private static final String CAMPAIGN_NAME = "https://play.google.com/store/apps/details?id=com.fillr&referrer=utm_source%3D{devkey}%26utm_campaign%3DbrowserSDK";
    public static final String FILLR_PACKAGE_NAME = "com.fillr";
    public static final String FILLR_DOLPHIN_PACKAGE_NAME = "com.fillr.dolphin";
    private static final String FILLR_PAYLOAD = "com.fillr.payload";
    private static final String FILLR_MAPPINGS = "com.fillr.mappings";
    private int mFillrToolbarDismissCountThreshold = 4;
    private boolean captureValueDisabled = false;
    private boolean mToolbarDismissed;
    private String mWidgetVersion = null;
    private String mDomain;
    private boolean isNewPage = false;
    private String devKey = null;
    private String secretKey = null;
    private FillrWidget mWidget = null;
    private static Fillr fillrInstance = null;
    private FillrBrowserProperties mBrowserProps = null;
    private FillrInterceptRequest mInterceptRequest = null;
    private FillrWebView mWebView = null;
    private FillrToolbarView mFillrToolbarView = null;
    private FillrActionView mCustomAutofillButton = null;
    private FillrToolbarManager mFillrToolbarManager;
    private FillrAbandonmentTracking mFillrAbandonmentTracking;
    private Activity parentActivity = null;
    private BROWSER_TYPE browserType = null;
    private EmbeddedBrowser mEmbeddedBrowser = null;
    private FillrGeckoViewListener mGeckoView = null;
    private FillrToolbarEventListener mToolbarEventListener;
    private FillApprovedListener mFillApprovedEventListener;
    private FillrAnalyticsManager mAnalyticsManager = null;
    private FillrAutofillPromptMode mAutofillPromptMode = null;
    private AutofillPromptInterface mAutofillPrompt = null;
    private FillrIntentBuilder intentBuilder;
    private FillMode mFillMode = FillMode.HEADFUL;
    private FillrProfileDataListener mProfileListener;
    private FillrWebViewMapper mWebViewMapper;
    private FillrCartInformationExtraction mFillrCartInformationExtraction;
    private final DolphinFillrJSNativeInterfaceImpl fillrJNIImpl = new DolphinFillrJSNativeInterfaceImpl(){

        @Override
        public void setFields(String json) {
            Fillr.this.startProcess(json, Fillr.this.getWebView());
        }

        @Override
        public void setValues(String fieldsJson, String valuesJson) {
            FillrMappingServiceClient fillrMappingServiceClient = new FillrMappingServiceClient(Fillr.getInstance());
            boolean sent = fillrMappingServiceClient.sendValuesToProfile(fieldsJson, valuesJson, Fillr.this.isNewPage);
            if (sent) {
                Fillr.this.isNewPage = false;
            }
        }

        @Override
        public void fieldFocused(String json) {
            Fillr.this.mAutofillPrompt.onFieldFocused();
        }
    };

    private Fillr() {
    }

    @Override
    public FillrBrowserProperties getBrowserProps() {
        return this.mBrowserProps;
    }

    public static Fillr getInstance() {
        if (fillrInstance == null) {
            fillrInstance = new Fillr();
        }
        return fillrInstance;
    }

    @VisibleForTesting
    public void clearAll() {
        this.mFillrToolbarDismissCountThreshold = 4;
        this.captureValueDisabled = false;
        this.mToolbarDismissed = false;
        this.mWidgetVersion = null;
        this.mDomain = null;
        this.isNewPage = false;
        this.devKey = null;
        this.secretKey = null;
        this.mWidget = null;
        this.mBrowserProps = null;
        this.mWebView = null;
        this.mFillrToolbarView = null;
        this.mCustomAutofillButton = null;
        this.mFillrToolbarManager = null;
        this.mFillrAbandonmentTracking = null;
        this.parentActivity = null;
        this.browserType = null;
        this.mEmbeddedBrowser = null;
        this.mGeckoView = null;
        this.mToolbarEventListener = null;
        this.mFillApprovedEventListener = null;
        this.mAnalyticsManager = null;
        this.mAutofillPromptMode = null;
        this.mAutofillPrompt = null;
        this.mFillMode = FillMode.HEADFUL;
        this.mProfileListener = null;
        this.mInterceptRequest = null;
    }

    public final void initialise(String devKey, String secretKey, Activity parentActivity, BROWSER_TYPE type) {
        this.initialise(devKey, secretKey, parentActivity, type, null);
    }

    public final void initialise(String devKey, String secretKey, Activity parentActivity, BROWSER_TYPE type, FillrBrowserProperties browserInfo) {
        if (!FillrUtils.androidApiIceCreamSandwichOrHigher()) {
            Log.w((String)LOGTAG, (String)"Warning: Fillr will not work with API Level 13 or lower! The SDK has been deactivated.");
            this.setEnabled(false);
            return;
        }
        if (parentActivity != null && devKey != null && type != null) {
            this.parentActivity = parentActivity;
            this.devKey = devKey;
            this.secretKey = secretKey;
            this.browserType = type;
            this.mEmbeddedBrowser = EmbeddedBrowser.getEmbeddedBrowser(devKey);
            this.mBrowserProps = browserInfo;
            this.mAnalyticsManager = new FillrAnalyticsManager((Context)parentActivity, devKey);
            this.mFillrToolbarManager = new FillrToolbarManager(parentActivity, this.mEmbeddedBrowser);
            this.mFillrAbandonmentTracking = new FillrAbandonmentTracking(this.mAnalyticsManager, this.mEmbeddedBrowser);
            this.mWebViewMapper = FillrWebViewMapper.getInstance();
            FillrWidget cartScraperWidget = new FillrWidget(this, "Widget1.js", "https://klarna-widget.fillr.com/widget/cart-information-extraction/FillrCartScraperWidget.js.gz", true);
            this.mFillrCartInformationExtraction = new FillrCartInformationExtraction(this.mAnalyticsManager, cartScraperWidget, this.mWebViewMapper);
            this.intentBuilder = new FillrIntentBuilder((Context)parentActivity, devKey, secretKey);
            this.intentBuilder.setAnalyticsManager(this.mAnalyticsManager);
            if (this.mFillrToolbarView != null) {
                this.mFillrToolbarManager.setActionView(this.mFillrToolbarView);
            }
            if (this.mCustomAutofillButton != null) {
                this.mFillrToolbarManager.setActionView(this.mCustomAutofillButton);
            }
            if (this.mBrowserProps != null && this.mBrowserProps.getWidgetSource() != null) {
                this.setWidgetSource(this.mBrowserProps.getWidgetSource());
            }
        } else {
            throw new IllegalArgumentException("Please provide a valid activity, developer key and browser type");
        }
        this.mWidget = new FillrWidget(this, "FillrWidget-Android.js", "https://d2o8n2jotd2j7i.cloudfront.net/widget/android/sdk/FillrWidget-Android.js.gz");
        this.mWidget.download();
        this.mAutofillPrompt = AutofillPromptFactory.createController(this, this.mFillrToolbarManager, this.mWebViewMapper);
        this.mAutofillPromptMode = this.mAutofillPrompt.getMode();
        this.mInterceptRequest = new FillrInterceptRequest();
    }

    @Override
    public FillrAutofillPromptMode getAutofillPromptMode() {
        return this.mAutofillPromptMode;
    }

    @Override
    public void setAutofillPromptMode(FillrAutofillPromptMode mode) {
        this.mAutofillPromptMode = mode;
    }

    @Override
    public AutofillPromptInterface getAutofillPromptController() {
        return this.mAutofillPrompt;
    }

    @Override
    public void trackWebView(Object view) {
        if (FillrAuthenticationStore.isEnabled((Context)this.parentActivity)) {
            if (view == null) {
                throw new IllegalArgumentException("Invalid webview, your webview instance is null");
            }
            this.mWebView = new FillrWebView(view, this.browserType);
            this.mAutofillPrompt.onTrackWebView(this.mWebView);
            this.mWebView.setJSInterface(new FillrAbandonmentTracking.FillrAbandonmentJNI(this.mFillrAbandonmentTracking), "fillrAbandonmentJNI");
            this.mWebView.setJSInterface(new FillrCartInformationExtraction.FillrCartInformationExtractionJNI(this.mFillrCartInformationExtraction), "fillrCartInformationExtractionJNI");
        }
    }

    @Override
    public void trackWebView(Object view, DolphinFillrJSNativeInterface dolphinWrapper) {
        if (FillrAuthenticationStore.isEnabled((Context)this.parentActivity)) {
            if (view == null) {
                throw new IllegalArgumentException("Invalid webview or interface, your webview/interface instance is null");
            }
            this.mWebView = new FillrWebView(view, this.browserType);
            if (dolphinWrapper != null) {
                this.registerJSNativeInterfaceWrapper(dolphinWrapper);
            } else {
                if (this.mAutofillPrompt instanceof FillrBasePrompt) {
                    this.mWebView.setJSInterface(new FillrBaseJSInterface((FillrBasePrompt)this.mAutofillPrompt));
                }
                this.mWebView.setJSInterface(new FillrAbandonmentTracking.FillrAbandonmentJNI(this.mFillrAbandonmentTracking), "fillrAbandonmentJNI");
                this.mWebView.setJSInterface(new FillrCartInformationExtraction.FillrCartInformationExtractionJNI(this.mFillrCartInformationExtraction), "fillrCartInformationExtractionJNI");
            }
        }
    }

    @Override
    public void injectJSInterface(Object view) {
        if (FillrAuthenticationStore.isEnabled((Context)this.parentActivity)) {
            if (view == null) {
                throw new IllegalArgumentException("Invalid webview, your webview instance is null");
            }
            FillrWebView webView = new FillrWebView(view, this.browserType);
            this.mAutofillPrompt.onInjectJSInterface(webView);
            webView.setJSInterface(new FillrAbandonmentTracking.FillrAbandonmentJNI(this.mFillrAbandonmentTracking), "fillrAbandonmentJNI");
            webView.setJSInterface(new FillrCartInformationExtraction.FillrCartInformationExtractionJNI(this.mFillrCartInformationExtraction), "fillrCartInformationExtractionJNI");
        }
    }

    @Override
    public void injectJSInterface(Object view, DolphinFillrJSNativeInterface dolphinWrapper) {
        if (FillrAuthenticationStore.isEnabled((Context)this.parentActivity)) {
            if (view == null) {
                throw new IllegalArgumentException("Invalid webview, your webview instance is null");
            }
            this.mWebView = new FillrWebView(view, this.browserType);
            if (dolphinWrapper != null) {
                dolphinWrapper.setImpl(this.fillrJNIImpl);
                this.mWebView.setJSInterface(dolphinWrapper);
            } else {
                this.mWebView.setJSInterface(new FillrBaseJSInterface((FillrBasePrompt)this.mAutofillPrompt));
            }
        }
    }

    @Override
    public void onPageFinished(Object view) {
        if (FillrAuthenticationStore.isEnabled((Context)this.parentActivity)) {
            if (view == null) {
                throw new IllegalArgumentException("Invalid webview, your webview instance is null");
            }
            if (this.mWidget != null) {
                this.mWidget.setWidgetListener(null);
            }
            FillrWebView webView = new FillrWebView(view, this.browserType);
            this.mAutofillPrompt.onPageFinished(webView);
            this.isNewPage = true;
            this.onUrlChangedListener(webView.getDomain());
            this.mFillrAbandonmentTracking.onPageFinished((Context)this.getParentActivity(), webView);
            this.mFillrCartInformationExtraction.onPageFinished((Context)this.getParentActivity(), webView);
        }
    }

    @Override
    public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
        if (FillrAuthenticationStore.isEnabled((Context)this.parentActivity)) {
            WebResourceResponse response;
            if (this.mInterceptRequest == null) {
                this.mInterceptRequest = new FillrInterceptRequest();
            }
            if ((response = this.mInterceptRequest.shouldInterceptRequest(view, request)) != null) {
                return response;
            }
        }
        return null;
    }

    @Deprecated
    public void injectFillrJSClient(Object view) {
        this.onPageFinished(view);
    }

    private void registerJSNativeInterfaceWrapper(DolphinFillrJSNativeInterface dolphinWrapper) {
        if (dolphinWrapper != null) {
            if (this.mWebView != null) {
                dolphinWrapper.setImpl(this.fillrJNIImpl);
                this.mWebView.setJSInterface(dolphinWrapper);
            }
        } else {
            Log.e((String)LOGTAG, (String)"Could not register Dolphin Fillr JS Native Interface");
        }
    }

    @Override
    public void trackGeckoView(FillrGeckoViewListener geckoView) {
        this.mGeckoView = geckoView;
    }

    @Override
    @Deprecated
    public void downloadFillrApp() {
        if (this.parentActivity != null && this.intentBuilder != null) {
            FillrUtils.setClipboardData("ReturnPackageName", this.intentBuilder.getAdditionalInfo(), (Context)this.parentActivity);
            String campaignUrl = CAMPAIGN_NAME.replace("{devkey}", this.getDeveloperKey());
            FillrUtils.launchPlaystore((Context)this.parentActivity, campaignUrl);
        }
    }

    @Override
    public void setToolbarEventListener(FillrToolbarEventListener toolbarEventListener) {
        this.mToolbarEventListener = toolbarEventListener;
    }

    @Override
    public void setFillApprovedEventListener(FillApprovedListener fillApprovedEventListener) {
        this.mFillApprovedEventListener = fillApprovedEventListener;
    }

    @Override
    public void setEnabled(boolean value) {
        if (this.mAutofillPrompt != null) {
            boolean previousEnabledValue = FillrAuthenticationStore.isEnabled((Context)this.parentActivity);
            FillrAuthenticationStore.setEnabled((Context)this.parentActivity, value);
            this.mAutofillPrompt.setEnabled(value, previousEnabledValue);
        }
    }

    @Override
    public boolean isEnabled() {
        return FillrAuthenticationStore.isEnabled((Context)this.parentActivity);
    }

    @Override
    public void setToolbarVisibility(final ToolbarViewVisibility visibility) {
        FillrAuthenticationStore.setVisibility((Context)this.parentActivity, visibility);
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.mAutofillPrompt.setVisibility(visibility);
        } else {
            this.parentActivity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    Fillr.this.mAutofillPrompt.setVisibility(visibility);
                }
            });
        }
    }

    @Override
    public FillrAuthenticationStore.WidgetSource getWidgetSource() {
        return FillrAuthenticationStore.widgetSource((Context)this.parentActivity);
    }

    @Override
    public void setWidgetSource(FillrAuthenticationStore.WidgetSource source) {
        FillrAuthenticationStore.setWidgetSource((Context)this.parentActivity, source);
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void onResume() {
        boolean trigger = this.triggerFillView();
        if (this.parentActivity != null && this.mWebView != null && trigger) {
            this.loadWebKitWidget();
        } else if (this.mGeckoView != null && trigger) {
            this.loadFennecWidget();
        }
        if (trigger) {
            FillrUtils.setClipboardData("com.fillr.triggerautofill", "", (Context)this.parentActivity);
        }
    }

    private boolean triggerFillView() {
        String shouldTrigger = null;
        if (this.parentActivity != null) {
            shouldTrigger = FillrUtils.getClipboardData((Context)this.parentActivity);
        }
        return shouldTrigger != null && shouldTrigger.equals("com.fillr.load.yes");
    }

    @Override
    public boolean setFillrToolbarDismissCountThreshold(int threshold) {
        if (threshold > 0) {
            this.mFillrToolbarDismissCountThreshold = threshold;
            return true;
        }
        return false;
    }

    public boolean isCaptureValueDisabled() {
        return this.captureValueDisabled;
    }

    public void setCaptureValueDisabled(boolean disabled) {
        this.captureValueDisabled = disabled;
    }

    public String getWidgetVersion() {
        return this.mWidgetVersion;
    }

    public void setWidgetVersion(String version) {
        this.mWidgetVersion = version;
    }

    public void processForm(Intent data) {
        if (data != null && data.hasExtra(FILLR_PAYLOAD) && data.hasExtra(FILLR_MAPPINGS)) {
            String payload = data.getStringExtra(FILLR_PAYLOAD);
            String mappings = data.getStringExtra(FILLR_MAPPINGS);
            this.populateWebviewFields(payload, mappings, this.mWebView);
            this.notifyFillApproved(mappings, payload);
        }
    }

    @Override
    public void startProcess(String mapping) {
        this.startProcess(mapping, this.getWebView());
    }

    @Override
    public void startProcess(final String mapping, final FillrWebView fillrWebView) {
        if (this.parentActivity != null) {
            this.parentActivity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    FillrUtils.hideKeyboard(Fillr.this.parentActivity);
                    if (Fillr.this.mFillMode == FillMode.HEADLESS) {
                        FillrMappingServiceClient fillrMappingServiceClient = new FillrMappingServiceClient(Fillr.this);
                        fillrMappingServiceClient.getMappingsForHeadlessFill(mapping, fillrWebView);
                    } else {
                        Intent newIntent = Fillr.this.intentBuilder.buildIntent(mapping);
                        Fillr.this.parentActivity.startActivityForResult(newIntent, 101);
                    }
                }
            });
        }
    }

    @Override
    public boolean shouldShowAutofillPrompt() {
        return FillrAuthenticationStore.isEnabled((Context)this.parentActivity) && this.webViewHasFocus() && this.mWebView != null && !FillrUtils.excludeByDomain(this.mWebView.getDomain());
    }

    public Activity getParentActivity() {
        return this.parentActivity;
    }

    public final String getDeveloperKey() {
        return this.devKey;
    }

    public final String getSecretKey() {
        return this.secretKey;
    }

    public final EmbeddedBrowser getEmbeddedBrowser() {
        return this.mEmbeddedBrowser;
    }

    public FillrWebView getFillrWebView() {
        return this.mWebView;
    }

    public FillrWidget getFillrWidget() {
        return this.mWidget;
    }

    private boolean isToolbarToggleEvent(FillrEvent event) {
        return event != null && 1 == event.getEventType() && this.mToolbarEventListener != null;
    }

    private boolean isSkipPinDialogEvent(FillrEvent event) {
        return event != null && 0 == event.getEventType() && this.mToolbarEventListener != null;
    }

    void onUrlChangedListener(String url) {
        try {
            String newDomain = FillrUtils.getDomainName(url);
            if (this.mDomain == null) {
                this.mDomain = newDomain;
            } else if (!this.mDomain.equals(newDomain)) {
                this.mAutofillPrompt.onUrlChanged(newDomain);
                this.mDomain = newDomain;
                this.mToolbarDismissed = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void onFieldFocussed(Object data) {
        this.mFillrToolbarManager.fieldFocused();
    }

    public FillrToolbarManager getFillrToolbarManager() {
        return this.mFillrToolbarManager;
    }

    boolean webViewHasFocus() {
        if (this.mWebView != null) {
            return this.mWebView.hasFocus();
        }
        if (this.mGeckoView != null) {
            return this.mGeckoView.shouldShowFillrToolbar();
        }
        return true;
    }

    void onToolbarClicked(boolean isFillrAppInstalled) {
        this.mAnalyticsManager.timeEvent("Sign Up Fill");
        this.mAnalyticsManager.timeEvent(FillrAnalyticsAction.WEB_FORM_FILLED.getName());
        this.mAnalyticsManager.timeEvent("Web Form Filled First Time");
        this.initiateFill();
        if (this.mToolbarEventListener != null) {
            this.mToolbarEventListener.onToolbarFillClicked(isFillrAppInstalled);
            if (!FillrAuthenticationStore.isToolbarTapped((Context)this.parentActivity)) {
                this.mToolbarEventListener.onToolbarTappedFirstTime();
            }
        }
    }

    private void initiateFill() {
        if (this.browserType == BROWSER_TYPE.WEB_KIT) {
            this.injectWidgetIntoWebView(this.mWebView);
        } else if (this.browserType == BROWSER_TYPE.GECKO || this.browserType == BROWSER_TYPE.CLOUD) {
            if (this.mGeckoView != null) {
                this.mGeckoView.onFillButtonClicked();
            } else {
                throw new ExceptionInInitializerError("provide a fillrinitlistener");
            }
        }
    }

    @Override
    public void triggerFill(Object webView) {
        if (webView == null) {
            throw new IllegalArgumentException("Invalid webView, your webView instance is null");
        }
        FillrWebView fillrWebView = new FillrWebView(webView, this.browserType);
        this.injectWidgetIntoWebView(fillrWebView);
    }

    private void injectWidgetIntoWebView(FillrWebView webView) {
        if (!FillrAuthenticationStore.isEnabled((Context)this.parentActivity)) {
            Log.e((String)LOGTAG, (String)"Fillr is disabled");
            return;
        }
        this.mWidget.setWidgetListener(new FillrWidget.FillrWidgetListener(){

            @Override
            public void onWidgetDownloaded(String widgetJavaScript) {
            }

            @Override
            public void onWidgetInjected(FillrWebView webView) {
                webView.loadJavascript("PopWidgetInterface.getFields();");
            }
        });
        this.mWidget.inject(webView);
    }

    private void loadFennecWidget() {
        Handler handler = new Handler();
        handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (Fillr.this.mGeckoView != null) {
                    Fillr.this.mGeckoView.onFillButtonClicked();
                }
            }
        }, 300L);
    }

    private void loadWebKitWidget() {
        if (this.mWebView != null && this.mWebView.getVisibility() == 0) {
            Handler handler = new Handler();
            handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    Fillr.this.mWidget.inject(Fillr.this.mWebView);
                }
            }, 300L);
        }
    }

    FillrWebView getWebView() {
        return this.mWebView;
    }

    void setToolbarView(FillrToolbarView view) {
        this.mFillrToolbarView = view;
        if (this.mFillrToolbarManager != null) {
            this.mFillrToolbarManager.setActionView(view);
        }
    }

    @Override
    public void setAutofillButton(View view) {
        if (view instanceof FillrActionView) {
            this.mCustomAutofillButton = (FillrActionView)view;
            if (this.mFillrToolbarManager != null) {
                this.mFillrToolbarManager.setActionView((FillrActionView)view);
            }
        }
    }

    void notifyToolbarVisibilityChanged(ToolbarViewVisibility visibility) {
        if (this.mToolbarEventListener != null) {
            boolean fillrInstalled = this.intentBuilder.isAnyFillrAppInstalled();
            this.mToolbarEventListener.onToolbarVisibilityChanged(visibility, fillrInstalled);
        }
    }

    private void notifyFillApproved(String mappings, String profileData) {
        if (this.mFillApprovedEventListener != null) {
            this.mFillApprovedEventListener.onFillApproved(mappings, profileData);
        }
    }

    private void notifyToolbarDismissCountThresholdExceeded() {
        if (this.mToolbarEventListener != null) {
            this.mToolbarEventListener.onDismissThresholdExceeded();
        }
    }

    void setToolbarDismissed(boolean dismissed) {
        this.mToolbarDismissed = dismissed;
        int numberOfToolbarDismisses = this.incrementToolbarDismissCount();
        Fillr.getInstance().trackEvent(FillrAnalyticsEvents.FillrToolbarDismissed, new String[0]);
        if (numberOfToolbarDismisses >= this.mFillrToolbarDismissCountThreshold) {
            this.resetToolbarDismissCount();
            this.notifyToolbarDismissCountThresholdExceeded();
        }
    }

    boolean isToolbarDismissed() {
        return this.mToolbarDismissed;
    }

    int incrementToolbarDismissCount() {
        int v = FillrAuthenticationStore.getDismissedCount((Context)this.parentActivity);
        FillrAuthenticationStore.setDismissedCount((Context)this.parentActivity, ++v);
        return v;
    }

    void resetToolbarDismissCount() {
        FillrAuthenticationStore.setDismissedCount((Context)this.parentActivity, 0);
    }

    public void trackEvent(FillrAnalyticsEvents event, String ... extraValue) {
        if (this.mAnalyticsManager != null) {
            this.mAnalyticsManager.trackEvent(event, extraValue);
        }
    }

    public boolean hasValidWebViewInstance() {
        if (this.browserType == BROWSER_TYPE.GECKO) {
            Log.e((String)LOGTAG, (String)"hasValidWebViewInstance:Gecko");
            return this.mGeckoView != null;
        }
        Log.e((String)LOGTAG, (String)"hasValidWebViewInstance:WebView");
        return this.mWebView != null;
    }

    public void setFillMode(FillMode mFillMode) {
        if (mFillMode != null) {
            this.mFillMode = mFillMode;
        }
    }

    public FillMode getFillMode() {
        return this.mFillMode;
    }

    public void profileDataListener(FillrProfileDataListener profileListener) {
        this.mProfileListener = profileListener;
    }

    public void notifyProfileListener(FillrMapping fields, String viewId) {
        if (this.mProfileListener != null && fields != null && fields.hasFields()) {
            FillrWebView webView = this.mWebViewMapper.getWebViewForId(viewId);
            this.mProfileListener.onFormDetected(webView, fields);
        }
    }

    private void populateWebviewFields(String payload, String mappings, FillrWebView webView) {
        if (webView != null && payload != null && payload.length() > 0 && mappings != null && mappings.length() > 0) {
            String sanitisedMappings = FillrUtils.sanitiseJsonString(mappings);
            String sanitisedPayload = FillrUtils.sanitiseJsonString(payload);
            webView.populateWithMappings(sanitisedMappings, sanitisedPayload);
        }
    }

    @Override
    public synchronized void performAutofillOnWebView(FillrWebView webView, FillrMapping fields) {
        if (fields != null) {
            String payload = fields.getProfileData();
            JSONObject mappings = fields.getFormMappings(this.mFillMode == FillMode.HEADLESS);
            if (webView != null && payload != null && payload.length() > 0 && mappings != null && mappings.toString().length() > 0) {
                this.populateWebviewFields(payload, mappings.toString(), webView);
            }
            if (fields.hasFields()) {
                FillrMappingServiceClient fillrMappingServiceClient = new FillrMappingServiceClient(this);
                fillrMappingServiceClient.sendPerformance(fields);
                Log.e((String)LOGTAG, (String)("sent performance data for " + payload));
            }
        } else {
            Log.e((String)LOGTAG, (String)"fields are null");
        }
    }

    public void setCartInformationExtractionListener(FillrCartInformationExtraction.FillrCartInformationExtractionListener listener) {
        this.mFillrCartInformationExtraction.setListener(listener);
    }

    public void setCartInformationExtractionEnabled(boolean enabled) {
        this.mFillrCartInformationExtraction.setEnabled(enabled);
    }

    public boolean cartInformationExtractionEnabled() {
        return this.mFillrCartInformationExtraction.cartInformationExtractionEnabled();
    }

    @Override
    public void onDestroy() {
        this.parentActivity = null;
    }

    @Override
    public FillrIntentBuilder getIntentBuilder() {
        if (this.intentBuilder == null) {
            this.intentBuilder = new FillrIntentBuilder((Context)this.parentActivity, this.devKey, this.secretKey);
            this.intentBuilder.setAnalyticsManager(this.mAnalyticsManager);
        }
        return this.intentBuilder;
    }

    public static interface FillrProfileDataListener {
        public void onFormDetected(FillrWebView var1, FillrMapping var2);
    }

    public static interface FillApprovedListener {
        public void onFillApproved(String var1, String var2);
    }

    public static interface FillrGeckoViewInterface {
        public void handleMessage(String var1, JSONObject var2);

        public void onFillButtonClicked();

        public boolean shouldShowFillrToolbar();
    }

    public static interface FillrFormProcessListener {
        public void getResult(HashMap<String, String> var1, HashMap<String, String> var2);
    }

    public static enum FillMode {
        HEADFUL,
        HEADLESS;

    }

    public static enum FillrAutofillPromptMode {
        TOOLBAR,
        IN_FIELD,
        HEADLESS;

    }

    public static enum ToolbarViewVisibility {
        VISIBLE,
        INVISIBLE;

    }

    public static enum BROWSER_TYPE {
        WEB_KIT,
        GECKO,
        CLOUD;

    }
}

