/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk.model;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ResultReceiver;
import android.util.Log;
import com.fillr.browsersdk.Fillr;
import com.fillr.browsersdk.FillrToolbarManager;
import com.fillr.browsersdk.analytics.FillrAnalyticsEvents;
import com.fillr.browsersdk.apiclient.FillrMappingServiceClient;
import com.fillr.browsersdk.model.FillrBasePrompt;
import com.fillr.browsersdk.model.FillrWebView;
import com.fillr.browsersdk.model.FillrWebViewMapper;
import com.fillr.browsersdk.model.FillrWidget;
import com.fillr.browsersdk.model.JSNativeInterface;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class ToolbarAutofillPrompt
extends FillrBasePrompt {
    private FillrToolbarManager mFillrToolbarManager;
    private FillrMappingServiceClient mClient;

    public ToolbarAutofillPrompt(Fillr fillr, FillrToolbarManager fillrToolbarManager, FillrWebViewMapper webViewMapper) {
        super(webViewMapper);
        this.mFillr = fillr;
        this.mFillrToolbarManager = fillrToolbarManager;
        this.mClient = new FillrMappingServiceClient(this.mFillr);
    }

    @Override
    public void onTrackWebView(FillrWebView trackedWebview) {
        FillrWidget widget = this.mFillr.getFillrWidget();
        if (widget != null) {
            widget.setWidgetListenerPrompt(new FillrWidget.FillrWidgetListener(){

                @Override
                public void onWidgetDownloaded(String widgetJavaScript) {
                }

                @Override
                public void onWidgetInjected(FillrWebView webView) {
                    ToolbarAutofillPrompt.this.initializeWidget(webView);
                }
            });
            widget.download();
        }
        trackedWebview.setJSInterface(new JSNativeInterface(this));
    }

    @Override
    public void onInjectJSInterface(FillrWebView webView) {
        webView.setJSInterface(new JSNativeInterface(this));
    }

    @Override
    public void onPageFinished(FillrWebView webView) {
        webView.setFillrJSClient();
        this.mFillr.getFillrWidget().inject(webView);
        this.isNewPage = true;
    }

    @Override
    public void onUrlChanged(String newDomain) {
        if (this.mFillrToolbarManager != null) {
            this.mFillrToolbarManager.urlChanged(newDomain);
        }
    }

    @Override
    public void setEnabled(boolean enabled, boolean previousEnabledValue) {
        if (enabled) {
            this.mFillr.setToolbarVisibility(Fillr.ToolbarViewVisibility.VISIBLE);
            if (!previousEnabledValue) {
                this.mFillr.trackEvent(FillrAnalyticsEvents.FillrToolbarEnabled, new String[0]);
            }
        } else {
            this.mFillr.setToolbarVisibility(Fillr.ToolbarViewVisibility.INVISIBLE);
            if (previousEnabledValue) {
                this.mFillr.trackEvent(FillrAnalyticsEvents.FillrToolbarDisabled, new String[0]);
            }
        }
    }

    @Override
    public void setVisibility(Fillr.ToolbarViewVisibility visibility) {
        this.mFillrToolbarManager.setToolbarVisible(visibility == Fillr.ToolbarViewVisibility.VISIBLE);
    }

    @Override
    public Fillr.FillrAutofillPromptMode getMode() {
        return Fillr.FillrAutofillPromptMode.TOOLBAR;
    }

    @Override
    public void onFieldFocused() {
        this.mFillrToolbarManager.fieldFocused();
    }

    @Override
    public void fillrJNISetFields(String json) {
        try {
            JSONObject mappingMeta = new JSONObject(json);
            if (mappingMeta.has("view_id")) {
                String viewId = mappingMeta.getString("view_id");
                FillrWebView currWebview = this.mWebViewMapper.getWebViewForId(viewId);
                this.mFillr.startProcess(json, currWebview);
            } else {
                this.mFillr.startProcess(json);
            }
        }
        catch (Exception e) {
            Log.e((String)"FillrBasePrompt", (String)e.getMessage());
        }
    }

    @Override
    public void fillrJNISetFillResult(String jsonFillResult) {
        this.mFillr.trackEvent(FillrAnalyticsEvents.FillrFillResult, jsonFillResult);
    }

    @Override
    public void fillrJNIFieldFocused(String json) {
    }

    @Override
    public void fillrJNISetWidgetVersion(String version) {
        this.mFillr.setWidgetVersion(version);
    }

    @Override
    public void fillrJNIFormMutation(String json) {
        try {
            JSONObject jsonObject = new JSONObject(json);
            final String viewId = jsonObject.getString("view_id");
            Activity activity = this.mFillr.getParentActivity();
            if (activity != null) {
                activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        FillrWebView fillrWebView = ToolbarAutofillPrompt.this.mWebViewMapper.getByUUID(UUID.fromString(viewId));
                        if (fillrWebView != null) {
                            fillrWebView.loadJavascript("PopWidgetInterface.getFields();");
                        }
                    }
                });
            }
        }
        catch (JSONException e) {
            Log.e((String)"FillrBasePrompt", (String)e.getMessage());
        }
    }

    @Override
    public void fillrJNIFieldBlurred(String json) {
        this.triggerCheckFields();
    }

    @Override
    public void showPrompt() {
    }

    @Override
    public void fillrJNICheckFields(String json) {
        this.sendRequestForToolbarDisplay(json);
    }

    private void sendRequestForToolbarDisplay(final String json) {
        if (this.isHeadlful() && this.hasFields(json)) {
            Handler mainHandler = new Handler(Looper.getMainLooper());
            mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        ResultReceiver toolbarMappingReceiver = new ResultReceiver(new Handler()){

                            protected void onReceiveResult(int resultCode, Bundle resultData) {
                                try {
                                    if (resultData != null) {
                                        JSONObject mappingResult = new JSONObject(resultData.getString("raw_response"));
                                        if (ToolbarAutofillPrompt.this.mFillrToolbarManager != null) {
                                            ToolbarAutofillPrompt.this.mFillrToolbarManager.setFillableFieldsFlag(ToolbarAutofillPrompt.this.hasFields(mappingResult));
                                        }
                                    }
                                }
                                catch (JSONException e) {
                                    e.printStackTrace();
                                }
                            }
                        };
                        if (ToolbarAutofillPrompt.this.mClient == null) {
                            ToolbarAutofillPrompt.this.mClient = new FillrMappingServiceClient(ToolbarAutofillPrompt.this.mFillr);
                        }
                        ToolbarAutofillPrompt.this.mClient.getMappingsForToolBarDisplay(json, toolbarMappingReceiver);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private boolean isHeadlful() {
        return this.mFillr != null && this.mFillr.getParentActivity() != null && this.mFillr.getFillMode() != Fillr.FillMode.HEADLESS;
    }

    @Override
    void initializeWidget(FillrWebView trackedWebview) {
        super.initializeWidget(trackedWebview);
        this.triggerCheckFields();
    }

    private void triggerCheckFields() {
        if (this.isHeadlful()) {
            this.mFillr.getParentActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ToolbarAutofillPrompt.this.mFillr.getFillrWebView().loadJavascript("try { PopWidgetInterface.checkFields(); } catch (e) { console.log('Cannot check fields until widget is injected'); }");
                }
            });
        }
    }
}

