/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk.model;

import android.app.Activity;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.fillr.browsersdk.Fillr;
import com.fillr.browsersdk.FillrAuthenticationStore;
import com.fillr.browsersdk.apiclient.FillrWidgetDownloader;
import com.fillr.browsersdk.model.FillrWebView;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class FillrWidget {
    private static final String TAG = "Fillr Widget";
    private FillrWidgetListener mWidgetListener;
    private FillrWidgetListener mWidgetListenerPrompt;
    private String mWidgetJavaScript = null;
    private Fillr mFillr;
    private boolean useAuth = false;
    private String localAssetName;
    private String remoteAssetUrl;

    public FillrWidget(Fillr fillr, String localAssetName, String remoteAssetUrl) {
        this.mFillr = fillr;
        this.localAssetName = localAssetName;
        this.remoteAssetUrl = remoteAssetUrl;
    }

    public FillrWidget(Fillr fillr, String localAssetName, String remoteAssetUrl, boolean useAuth) {
        this(fillr, localAssetName, remoteAssetUrl);
        this.useAuth = useAuth;
    }

    public boolean useAuth() {
        return this.useAuth;
    }

    public String getRemoteAssetUrl() {
        return this.remoteAssetUrl;
    }

    public String getLocalAssetName() {
        return this.localAssetName;
    }

    public String getWidgetJavaScript() {
        return this.mWidgetJavaScript;
    }

    public void setWidgetListener(FillrWidgetListener listener) {
        this.mWidgetListener = listener;
    }

    public void setWidgetListenerPrompt(FillrWidgetListener listener) {
        this.mWidgetListenerPrompt = listener;
    }

    public void inject(final FillrWebView webView) {
        if (webView != null && this.mWidgetJavaScript != null) {
            webView.loadJavascript(this.mWidgetJavaScript);
            webView.setWidgetInjected();
            Handler handler = new Handler(Looper.getMainLooper());
            handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (FillrWidget.this.mWidgetListenerPrompt != null) {
                        FillrWidget.this.mWidgetListenerPrompt.onWidgetInjected(webView);
                    }
                    if (FillrWidget.this.mWidgetListener != null) {
                        FillrWidget.this.mWidgetListener.onWidgetInjected(webView);
                    }
                }
            }, 100L);
        }
    }

    public void download() {
        if (this.mWidgetJavaScript != null && this.mWidgetListener != null) {
            this.mWidgetListener.onWidgetDownloaded(this.mWidgetJavaScript);
            return;
        }
        if (this.mFillr.getWidgetSource() == FillrAuthenticationStore.WidgetSource.REMOTE) {
            this.getWidgetInfoFromServer();
        } else {
            this.getWidgetInfoFromAssets();
        }
    }

    private void getWidgetInfoFromServer() {
        PerformWidgetDownload widgetDownloader = new PerformWidgetDownload(this);
        widgetDownloader.execute(new Void[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getWidgetInfoFromAssets() {
        Activity activity = this.mFillr.getParentActivity();
        if (activity != null) {
            StringBuilder buf = new StringBuilder();
            BufferedReader in = null;
            InputStream json = null;
            try {
                String str;
                json = activity.getAssets().open(this.localAssetName);
                in = new BufferedReader(new InputStreamReader(json, "UTF-8"));
                while ((str = in.readLine()) != null) {
                    buf.append(str);
                }
                in.close();
                this.mWidgetJavaScript = buf.toString();
            }
            catch (IOException e) {
                this.mWidgetJavaScript = null;
            }
            finally {
                try {
                    if (json != null) {
                        json.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex) {
                    Log.e((String)FillrWidget.class.toString(), (String)"Could not load the widget");
                }
            }
            if (this.mWidgetListener != null) {
                this.mWidgetListener.onWidgetDownloaded(this.mWidgetJavaScript);
            }
        }
    }

    public boolean widgetAvailable() {
        return this.mWidgetJavaScript != null && this.mWidgetJavaScript.length() > 0;
    }

    private static class PerformWidgetDownload
    extends AsyncTask<Void, Void, String> {
        FillrWidget widget;
        private String remoteWidgetUrl;

        PerformWidgetDownload(FillrWidget widget) {
            this.widget = widget;
            this.remoteWidgetUrl = widget.getRemoteAssetUrl();
        }

        protected String doInBackground(Void ... params) {
            String retVal = null;
            try {
                return FillrWidgetDownloader.getContent(this.remoteWidgetUrl, this.widget.useAuth);
            }
            catch (Exception e) {
                Log.e((String)FillrWidget.TAG, (String)e.getMessage());
                return retVal;
            }
        }

        protected void onPostExecute(String response) {
            super.onPostExecute((Object)response);
            if (response != null && this.widget != null) {
                this.widget.mWidgetJavaScript = response;
                if (this.widget.mWidgetListener != null) {
                    this.widget.mWidgetListener.onWidgetDownloaded(response);
                }
            }
        }
    }

    public static interface FillrWidgetListener {
        public void onWidgetDownloaded(String var1);

        public void onWidgetInjected(FillrWebView var1);
    }
}

