/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk.model;

import android.annotation.SuppressLint;
import android.util.Log;
import com.fillr.browsersdk.Fillr;
import com.fillr.browsersdk.model.DolphinFillrJSNativeInterface;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URL;

public class FillrWebView {
    public static final String TAG = "FillrWebView";
    private WeakReference<Object> mWebView;
    private Fillr.BROWSER_TYPE browserType;
    private String viewId;
    private boolean widgetInjected = false;

    public FillrWebView(Object view, Fillr.BROWSER_TYPE browserType) {
        this.mWebView = new WeakReference<Object>(view);
        this.browserType = browserType;
        this.initializeWebViewSettings();
    }

    public Object getWebView() {
        return this.mWebView.get();
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void initializeWebViewSettings() {
        Object webView = this.mWebView.get();
        if (webView == null) {
            return;
        }
        try {
            Method getSettings = webView.getClass().getMethod("getSettings", new Class[0]);
            Object webSettings = getSettings.invoke(webView, new Object[0]);
            Method setJavaScriptEnabled = webSettings.getClass().getMethod("setJavaScriptEnabled", Boolean.TYPE);
            setJavaScriptEnabled.invoke(webSettings, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setJSInterface(Object widgetInterface) {
        this.setJSInterface(widgetInterface, "androidInterface");
    }

    public void setJSInterface(Object widgetInterface, String interfaceName) {
        Object webView = this.mWebView.get();
        if (webView == null) {
            return;
        }
        try {
            Method m = webView.getClass().getMethod("addJavascriptInterface", Object.class, String.class);
            m.invoke(webView, widgetInterface, interfaceName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setJSInterface(DolphinFillrJSNativeInterface widgetInterface) {
        Object webView = this.mWebView.get();
        if (webView == null) {
            return;
        }
        try {
            Method m = webView.getClass().getMethod("addJavascriptInterface", Object.class, String.class);
            m.invoke(webView, widgetInterface, "androidInterface");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean hasFocus() {
        Object webView = this.mWebView.get();
        if (webView == null) {
            return false;
        }
        try {
            Method hasFocus = webView.getClass().getMethod("hasFocus", new Class[0]);
            Object result = hasFocus.invoke(webView, new Object[0]);
            return Boolean.valueOf(result.toString());
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Could not call hasFocus" + e.getMessage()));
            return false;
        }
    }

    public void loadJavascript(String js) {
        Object webView = this.mWebView.get();
        if (webView == null) {
            return;
        }
        try {
            Method loadUrl = webView.getClass().getMethod("loadUrl", String.class);
            String script = "javascript: " + js;
            loadUrl.invoke(webView, script);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getVisibility() {
        Object webView = this.mWebView.get();
        if (webView == null) {
            return 8;
        }
        try {
            Method getVisibility = webView.getClass().getMethod("getVisibility", new Class[0]);
            Object result = getVisibility.invoke(webView, new Object[0]);
            return Integer.valueOf(result.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return 8;
        }
    }

    public void populateWithMappings(String mappings, String payload) {
        if (payload != null && mappings != null) {
            this.loadJavascript("PopWidgetInterface.populateWithMappings(JSON.parse('" + mappings + "'), JSON.parse('" + payload + "'));");
        }
    }

    public String getDomain() {
        URL u = this.getUrl();
        if (u == null) {
            return null;
        }
        return u.getHost();
    }

    public URL getUrl() {
        Object webView = this.mWebView.get();
        if (webView == null) {
            return null;
        }
        try {
            Method getUrl = webView.getClass().getMethod("getUrl", new Class[0]);
            String o = (String)getUrl.invoke(webView, new Object[0]);
            if (o != null) {
                return new URL(o);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setFillrJSClient() {
        this.loadJavascript("(function() { if (typeof window.FillrFieldFocusEvent == 'undefined') { console.log('Assigning Field Focussed'); function checkTarget(e) { if (typeof e == 'undefined' || e == null || typeof e.nodeName != 'string') { return false; } return true; }; function isInput(e) { var el = e.nodeName.toLowerCase(); if (el == 'input' || el == 'select' || el == 'password' || el == 'textarea') { return true; } return false; }; window.FillrClickedEvent = function(e) { if (isInput(document.activeElement)) { console.log('Field Still Focussed!'); if (androidInterface && typeof androidInterface.fieldFocussed == 'function') { androidInterface.fieldFocussed('{}'); }; } }; window.FillrFieldFocusEvent = function(e) { if (!checkTarget(e.target)) return; if (isInput(e.target)) { console.log('Field Focussed!'); if (androidInterface && typeof androidInterface.fieldFocussed == 'function') { androidInterface.fieldFocussed('{}'); }; } }; window.FillrFieldFocusOutEvent = function(e) { if (!checkTarget(e.target)) return; if (isInput(e.target)) { console.log('Field Focussed Out!'); if (androidInterface && typeof androidInterface.fieldBlurred == 'function') { androidInterface.fieldBlurred('{}'); }; } }; window.FillrOrientationChangeEvent = function(e) { if (isInput(document.activeElement)) { console.log('Field Still Focussed (Orientation)!'); if (androidInterface && typeof androidInterface.fieldFocussed == 'function') { androidInterface.fieldFocussed('{}'); }; } }; document.addEventListener('click', window.FillrClickedEvent, true); document.addEventListener('focus', window.FillrFieldFocusEvent, true); document.addEventListener('focusout', window.FillrFieldFocusOutEvent, true); window.addEventListener('orientationchange', window.FillrOrientationChangeEvent, true); }})()");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FillrWebView that = (FillrWebView)o;
        if (this.mWebView != null) {
            Object webView = this.mWebView.get();
            Object thatWebViewObject = that.getWebViewObject();
            if (webView == null || thatWebViewObject == null) {
                return false;
            }
            if (!webView.equals(thatWebViewObject)) {
                return false;
            }
        }
        return this.browserType == that.browserType;
    }

    public int hashCode() {
        int result = this.mWebView != null ? this.mWebView.hashCode() : 0;
        result = 31 * result + (this.browserType != null ? this.browserType.hashCode() : 0);
        return result;
    }

    void setViewId(String viewId) {
        this.viewId = viewId;
    }

    public String getViewId() {
        return this.viewId;
    }

    void setWidgetInjected() {
        this.widgetInjected = true;
    }

    public boolean isWidgetInjected() {
        return this.widgetInjected;
    }

    public Object getWebViewObject() {
        Object retVal = null;
        if (this.mWebView != null) {
            retVal = this.mWebView.get();
        }
        return retVal;
    }
}

