/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk.analytics;

import android.content.Context;
import com.fillr.analytics.AnalyticsEvent;
import com.fillr.analytics.FillrAnalyticsService;
import com.fillr.analytics.metrics.FillrAPI;
import com.fillr.browsersdk.Fillr;
import com.fillr.browsersdk.FillrAuthenticationStore;
import com.fillr.browsersdk.analytics.FillrAnalyticsEvents;
import com.fillr.browsersdk.analytics.FillrFillResults;
import com.fillr.browsersdk.model.FillrIntentBuilder;
import com.fillr.browsersdk.utilities.FillrUtils;

public class FillrAnalyticsManager {
    private String mFillrDevKey = null;
    private Context mContext = null;
    private FillrAnalyticsService mAnalyticsService;

    public FillrAnalyticsManager(Context context, String devKey) {
        this.mContext = context;
        this.mFillrDevKey = devKey;
        Fillr fillr = Fillr.getInstance();
        if (fillr != null) {
            FillrIntentBuilder intentBuilder = fillr.getIntentBuilder();
            this.mAnalyticsService = FillrAnalyticsService.getInstance((String)this.mFillrDevKey, (String)intentBuilder.getFillrCorePackageName());
        }
    }

    public String getClientID() {
        return FillrAPI.getInstance((Context)this.mContext, (String)this.mFillrDevKey).getDistinctId();
    }

    public void sendEvent(AnalyticsEvent event) {
        this.mAnalyticsService.sendEvent(this.mContext, event);
    }

    public void trackEvent(FillrAnalyticsEvents event, String ... extraValue) {
        this.trackEvent(event, -1, extraValue);
    }

    public void trackEvent(FillrAnalyticsEvents event, int i, String ... extraValue) {
        switch (event) {
            case FillrFillResult: {
                this.sendFillResult(extraValue);
                break;
            }
            default: {
                this.dispatchTrackedEvent(event);
            }
        }
    }

    public AnalyticsEvent createEvent() {
        AnalyticsEvent event = new AnalyticsEvent();
        event.setDevKey(this.mFillrDevKey);
        this.additionalInfo(event);
        return event;
    }

    private void dispatchTrackedEvent(FillrAnalyticsEvents eventType) {
        AnalyticsEvent event = this.createEvent();
        event.setScreen(eventType.getScreen());
        event.setCategory(eventType.getCategory());
        event.setAction(eventType.getAction());
        this.mAnalyticsService.sendEvent(this.mContext, event);
    }

    private void additionalInfo(AnalyticsEvent event) {
        event.setFillrInstalled(Boolean.toString(FillrUtils.isPackageInstalled("com.fillr", this.mContext)));
        event.setPinModalShown(Boolean.toString(FillrAuthenticationStore.isPinModalShown(this.mContext)));
        event.setBrowserSdkVersion("3.6.17");
    }

    public void timeEvent(String eventName) {
        this.mAnalyticsService.timeEvent(this.mContext, eventName);
    }

    private void sendFillResult(String[] extraValues) {
        if (extraValues != null && extraValues.length > 0) {
            FillrFillResults fr = new FillrFillResults(this);
            fr.sendReport(extraValues[0]);
        }
    }
}

