/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk;

import android.util.Log;
import com.fillr.browsersdk.Fillr;
import com.fillr.browsersdk.analytics.FillrAnalyticsEvents;
import com.fillr.browsersdk.apiclient.FillrMappingServiceClient;
import org.json.JSONException;
import org.json.JSONObject;

public class FillrGeckoViewListener
implements Fillr.FillrGeckoViewInterface {
    public static final String LOGTAG = "FillrSDK";
    private final Fillr mFillr;
    private boolean isNewCaptureValuesPage = true;

    public FillrGeckoViewListener(Fillr fillr) {
        this.mFillr = fillr;
    }

    @Override
    public void handleMessage(String event, JSONObject message) {
        Log.d((String)LOGTAG, (String)("Handling message: " + event + " - " + message.toString()));
        try {
            if ("Fillr:FieldFocussed".equals(event)) {
                Fillr.getInstance().onFieldFocussed(message);
            } else if ("Fillr:SetValues".equals(event)) {
                this.onSetValues(message);
            } else if ("DOMContentLoaded".equals(event)) {
                this.isNewCaptureValuesPage = true;
            } else if ("Fillr:OnPageFinished".equals(event)) {
                Fillr.getInstance().onUrlChangedListener(message.getString("url"));
            } else if ("Fillr:SetFillResult".equals(event)) {
                Fillr.getInstance().trackEvent(FillrAnalyticsEvents.FillrFillResult, message.toString());
            }
        }
        catch (Exception e) {
            Log.e((String)LOGTAG, (String)("handleMessage exception " + e.getMessage()));
        }
    }

    private void onSetValues(JSONObject message) {
        try {
            JSONObject fields = message.getJSONObject("fields");
            JSONObject values = message.getJSONObject("values");
            FillrMappingServiceClient fillrMappingServiceClient = new FillrMappingServiceClient(this.mFillr);
            boolean sent = fillrMappingServiceClient.sendValuesToProfile(fields, values, this.isNewCaptureValuesPage);
            if (sent) {
                this.isNewCaptureValuesPage = false;
            }
        }
        catch (JSONException e) {
            Log.e((String)LOGTAG, (String)("onSetValues exception " + e.getMessage()));
        }
    }

    @Override
    public void onFillButtonClicked() {
    }

    @Override
    public boolean shouldShowFillrToolbar() {
        return false;
    }
}

