/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk;

import android.content.Context;
import android.content.SharedPreferences;
import com.fillr.browsersdk.Fillr;

public class FillrAuthenticationStore {
    private static final String F_ANALYICS = "F_ANALYTICS";
    private static final String SHARED_PREF_KEY = "com.fillr.browsersdk";
    private static final String DOWNLOAD_WIDGET = "com.fillr.browsersdk.download_widget";
    private static final String DISMISSED_COUNT = "com.fillr.browsersdk.dimissed_count";
    private static final String TOOLBAR_VISIBILITY = "com.fillr.browsersdk.toolbar_visibility";

    public static void clearFillrAuthenticationStore(Context context) {
        SharedPreferences.Editor editor = context.getSharedPreferences(SHARED_PREF_KEY, 0).edit();
        editor.clear();
        editor.apply();
    }

    public static void setAnalyticsFeature(Context context, boolean isAnalyticsOn) {
        SharedPreferences.Editor editor = context.getSharedPreferences(SHARED_PREF_KEY, 0).edit();
        editor.putBoolean(F_ANALYICS, isAnalyticsOn);
        editor.apply();
    }

    public static boolean getAnalyticsFlag(Context context) {
        SharedPreferences sharedPref;
        boolean retVal = true;
        if (context != null && (sharedPref = context.getSharedPreferences(SHARED_PREF_KEY, 0)) != null) {
            retVal = sharedPref.getBoolean(F_ANALYICS, true);
        }
        return retVal;
    }

    public static boolean isPinModalShown(Context context) {
        SharedPreferences sharedPref;
        boolean retVal = true;
        if (context != null && (sharedPref = context.getSharedPreferences(SHARED_PREF_KEY, 0)) != null) {
            retVal = sharedPref.getBoolean("isPinModelShown", false);
        }
        return retVal;
    }

    static final boolean isEnabled(Context context) {
        boolean retVal = false;
        if (context != null) {
            SharedPreferences sharedPreferences = context.getSharedPreferences(SHARED_PREF_KEY, 0);
            boolean legacyValue = sharedPreferences.getBoolean("toolbar_visibility", true);
            if (!legacyValue) {
                SharedPreferences.Editor editor = sharedPreferences.edit();
                editor.putBoolean("enabled", false);
                editor.remove("toolbar_visibility");
                editor.apply();
                return false;
            }
            retVal = sharedPreferences.getBoolean("enabled", true);
        }
        return retVal;
    }

    static final boolean isToolbarTapped(Context context) {
        SharedPreferences sharedPreferences;
        boolean retVal = true;
        if (context != null && !(retVal = (sharedPreferences = context.getSharedPreferences(SHARED_PREF_KEY, 0)).getBoolean("toolbar_tapped", false))) {
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putBoolean("toolbar_tapped", true);
            editor.apply();
        }
        return retVal;
    }

    static final void setEnabled(Context context, boolean value) {
        if (context != null) {
            SharedPreferences sharedPreferences = context.getSharedPreferences(SHARED_PREF_KEY, 0);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putBoolean("enabled", value);
            editor.apply();
        }
    }

    static final boolean isVisible(Context context) {
        boolean retVal = true;
        if (context != null) {
            SharedPreferences sharedPreferences = context.getSharedPreferences(SHARED_PREF_KEY, 0);
            int visibility = sharedPreferences.getInt(TOOLBAR_VISIBILITY, 0);
            retVal = visibility == Fillr.ToolbarViewVisibility.VISIBLE.ordinal();
        }
        return retVal;
    }

    static final void setVisibility(Context context, Fillr.ToolbarViewVisibility value) {
        if (context != null && value != null) {
            SharedPreferences sharedPreferences = context.getSharedPreferences(SHARED_PREF_KEY, 0);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putInt(TOOLBAR_VISIBILITY, value.ordinal());
            editor.apply();
        }
    }

    static final WidgetSource widgetSource(Context context) {
        boolean retVal = false;
        if (context != null) {
            SharedPreferences sharedPreferences = context.getSharedPreferences(SHARED_PREF_KEY, 0);
            retVal = sharedPreferences.getBoolean(DOWNLOAD_WIDGET, true);
        }
        return retVal ? WidgetSource.REMOTE : WidgetSource.LOCAL;
    }

    static final void setWidgetSource(Context context, WidgetSource source) {
        if (context != null) {
            SharedPreferences sharedPreferences = context.getSharedPreferences(SHARED_PREF_KEY, 0);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putBoolean(DOWNLOAD_WIDGET, source == WidgetSource.REMOTE);
            editor.apply();
        }
    }

    static final void setDismissedCount(Context context, int count) {
        if (context != null) {
            SharedPreferences sharedPreferences = context.getSharedPreferences(SHARED_PREF_KEY, 0);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putInt(DISMISSED_COUNT, count);
            editor.apply();
        }
    }

    static final int getDismissedCount(Context context) {
        int retVal = 0;
        if (context != null) {
            SharedPreferences sharedPreferences = context.getSharedPreferences(SHARED_PREF_KEY, 0);
            retVal = sharedPreferences.getInt(DISMISSED_COUNT, 0);
        }
        return retVal;
    }

    public static enum WidgetSource {
        REMOTE,
        LOCAL;

    }
}

