/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.ui.common;

import android.util.Log;
import com.facebook.fresco.ui.common.BaseControllerListener2;
import com.facebook.fresco.ui.common.ControllerListener2;
import com.facebook.infer.annotation.Nullsafe;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public class ForwardingControllerListener2<I>
extends BaseControllerListener2<I> {
    private static final String TAG = "FwdControllerListener2";
    private final List<ControllerListener2<I>> mListeners = new ArrayList<ControllerListener2<I>>(2);

    public synchronized void addListener(ControllerListener2<I> listener) {
        this.mListeners.add(listener);
    }

    public synchronized void removeListener(ControllerListener2<I> listener) {
        int index = this.mListeners.indexOf(listener);
        if (index != -1) {
            this.mListeners.remove(index);
        }
    }

    public synchronized void removeAllListeners() {
        this.mListeners.clear();
    }

    private synchronized void onException(String message, Throwable t) {
        Log.e((String)TAG, (String)message, (Throwable)t);
    }

    @Override
    public void onSubmit(String id, Object callerContext, @Nullable ControllerListener2.Extras extras) {
        int numberOfListeners = this.mListeners.size();
        for (int i = 0; i < numberOfListeners; ++i) {
            try {
                ControllerListener2<I> listener = this.mListeners.get(i);
                if (listener == null) continue;
                listener.onSubmit(id, callerContext, extras);
                continue;
            }
            catch (Exception exception) {
                this.onException("ForwardingControllerListener2 exception in onSubmit", exception);
            }
        }
    }

    @Override
    public void onFinalImageSet(String id, @Nullable I imageInfo, ControllerListener2.Extras extraData) {
        int numberOfListeners = this.mListeners.size();
        for (int i = 0; i < numberOfListeners; ++i) {
            try {
                ControllerListener2<I> listener = this.mListeners.get(i);
                if (listener == null) continue;
                listener.onFinalImageSet(id, imageInfo, extraData);
                continue;
            }
            catch (Exception exception) {
                this.onException("ForwardingControllerListener2 exception in onFinalImageSet", exception);
            }
        }
    }

    @Override
    public void onFailure(String id, Throwable throwable, @Nullable ControllerListener2.Extras extras) {
        int numberOfListeners = this.mListeners.size();
        for (int i = 0; i < numberOfListeners; ++i) {
            try {
                ControllerListener2<I> listener = this.mListeners.get(i);
                if (listener == null) continue;
                listener.onFailure(id, throwable, extras);
                continue;
            }
            catch (Exception exception) {
                this.onException("ForwardingControllerListener2 exception in onFailure", exception);
            }
        }
    }

    @Override
    public void onRelease(String id, @Nullable ControllerListener2.Extras extras) {
        int numberOfListeners = this.mListeners.size();
        for (int i = 0; i < numberOfListeners; ++i) {
            try {
                ControllerListener2<I> listener = this.mListeners.get(i);
                if (listener == null) continue;
                listener.onRelease(id, extras);
                continue;
            }
            catch (Exception exception) {
                this.onException("ForwardingControllerListener2 exception in onRelease", exception);
            }
        }
    }
}

