/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.stetho;

import android.graphics.Bitmap;
import android.os.Environment;
import android.text.TextUtils;
import android.util.SparseArray;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.disk.DiskStorage;
import com.facebook.cache.disk.FileCache;
import com.facebook.common.time.RealtimeSinceBootClock;
import com.facebook.imagepipeline.cache.BitmapMemoryCacheKey;
import com.facebook.imagepipeline.cache.CountingMemoryCacheInspector;
import com.facebook.imagepipeline.core.ImagePipeline;
import com.facebook.imagepipeline.core.ImagePipelineFactory;
import com.facebook.imagepipeline.image.CloseableBitmap;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.stetho.dumpapp.DumpException;
import com.facebook.stetho.dumpapp.DumpUsageException;
import com.facebook.stetho.dumpapp.DumperContext;
import com.facebook.stetho.dumpapp.DumperPlugin;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseFrescoStethoPlugin
implements DumperPlugin {
    private static final String NAME = "image";
    private static final float KB = 1024.0f;
    protected boolean mInitialized;
    private CountingMemoryCacheInspector<CacheKey, CloseableImage> mBitmapMemoryCacheInspector;
    private FileCache mMainFileCache;
    private FileCache mSmallFileCache;
    private ImagePipeline mImagePipeline;

    protected BaseFrescoStethoPlugin() {
        this.mInitialized = false;
    }

    protected BaseFrescoStethoPlugin(ImagePipelineFactory factory) {
        this.initialize(factory);
    }

    protected abstract void ensureInitialized() throws DumpException;

    protected void initialize(ImagePipelineFactory factory) {
        this.mBitmapMemoryCacheInspector = new CountingMemoryCacheInspector(factory.getBitmapCountingMemoryCache());
        this.mMainFileCache = factory.getMainFileCache();
        this.mSmallFileCache = factory.getSmallImageFileCache();
        this.mImagePipeline = factory.getImagePipeline();
        this.mInitialized = true;
    }

    public String getName() {
        return NAME;
    }

    public void dump(DumperContext dumpContext) throws DumpException {
        ArrayList<String> rest;
        this.ensureInitialized();
        List args = dumpContext.getArgsAsList();
        PrintStream writer = dumpContext.getStdout();
        String cmd = args.isEmpty() ? null : (String)args.get(0);
        List<String> list = rest = args.isEmpty() ? new ArrayList<String>() : args.subList(1, args.size());
        if (cmd != null && cmd.equals("memcache")) {
            this.memcache(writer, rest);
        } else if (cmd != null && cmd.equals("diskcache")) {
            this.diskcache(this.mMainFileCache, "Main", writer, rest);
            this.diskcache(this.mSmallFileCache, "Small", writer, rest);
        } else if (cmd != null && cmd.equals("clear")) {
            this.mImagePipeline.clearCaches();
        } else {
            BaseFrescoStethoPlugin.usage(writer);
            if (TextUtils.isEmpty((CharSequence)cmd)) {
                throw new DumpUsageException("Missing command");
            }
            throw new DumpUsageException("Unknown command: " + cmd);
        }
    }

    private void diskcache(FileCache cache, String title, PrintStream writer, List<String> args) throws DumpException {
        DiskStorage.DiskDumpInfo intDiskDumpInfo;
        try {
            intDiskDumpInfo = cache.getDumpInfo();
        }
        catch (IOException e) {
            throw new DumpException(e.getMessage());
        }
        if (!args.isEmpty() && args.get(0).equals("-s")) {
            this.writeDiskDumpInfoScriptReadable(writer, intDiskDumpInfo);
        } else {
            writer.println();
            writer.println(title + " disk cache contents:");
            this.writeDiskDumpInfo(writer, intDiskDumpInfo);
        }
    }

    private void writeDiskDumpInfo(PrintStream writer, DiskStorage.DiskDumpInfo dumpInfo) {
        if (dumpInfo.entries.isEmpty()) {
            writer.println("Empty");
            return;
        }
        SparseArray<Integer> histogram = BaseFrescoStethoPlugin.emptyHistogram();
        float total = 0.0f;
        for (DiskStorage.DiskDumpInfoEntry entry : dumpInfo.entries) {
            this.writeDiskDumpEntry(writer, entry);
            this.addToHistogram(histogram, entry);
            total += entry.size;
        }
        writer.println();
        writer.println(BaseFrescoStethoPlugin.formatStrLocaleSafe("Total size: %.1f MB", Float.valueOf(total / 1024.0f / 1024.0f)));
        this.printFileTypes(writer, dumpInfo);
        this.printHistogram(writer, histogram);
    }

    private static SparseArray<Integer> emptyHistogram() {
        SparseArray histogram = new SparseArray();
        histogram.put(0, (Object)0);
        histogram.put(5, (Object)0);
        histogram.put(10, (Object)0);
        histogram.put(20, (Object)0);
        histogram.put(50, (Object)0);
        histogram.put(100, (Object)0);
        histogram.put(200, (Object)0);
        histogram.put(512, (Object)0);
        histogram.put(1024, (Object)0);
        return histogram;
    }

    private void printFileTypes(PrintStream writer, DiskStorage.DiskDumpInfo dumpInfo) {
        writer.println();
        writer.println("File Type Counts:");
        for (String type : dumpInfo.typeCounts.keySet()) {
            writer.println(BaseFrescoStethoPlugin.formatStrLocaleSafe("%4s: %5d", type, dumpInfo.typeCounts.get(type)));
        }
    }

    private void addToHistogram(SparseArray<Integer> histogram, DiskStorage.DiskDumpInfoEntry entry) {
        for (int i = 0; i < histogram.size(); ++i) {
            int key = histogram.keyAt(i);
            if (!(entry.size / 1024.0f < (float)key)) continue;
            histogram.put(key, (Object)((Integer)histogram.get(key) + 1));
            return;
        }
        histogram.put((int)(entry.size / 1024.0f), (Object)1);
    }

    private void printHistogram(PrintStream writer, SparseArray<Integer> histogram) {
        writer.println();
        writer.println("File Size Counts:");
        for (int i = 1; i < histogram.size(); ++i) {
            int lb = histogram.keyAt(i - 1);
            int ub = histogram.keyAt(i);
            writer.println(BaseFrescoStethoPlugin.formatStrLocaleSafe("%4d-%4dK: %3d", lb, ub, histogram.get(ub)));
        }
    }

    private void writeDiskDumpEntry(PrintStream writer, DiskStorage.DiskDumpInfoEntry entry) {
        if (entry.firstBits != null && !entry.firstBits.isEmpty()) {
            writer.println("Undefined: " + entry.firstBits);
        }
        writer.println(BaseFrescoStethoPlugin.formatStrLocaleSafe("type: %5s size: %7.2fkB path: %9s", entry.type, Float.valueOf(entry.size / 1024.0f), entry.path));
    }

    private void writeDiskDumpInfoScriptReadable(PrintStream writer, DiskStorage.DiskDumpInfo dumpInfo) {
        for (DiskStorage.DiskDumpInfoEntry entry : dumpInfo.entries) {
            this.writeDiskDumpEntryScriptReadable(writer, entry);
        }
    }

    private void writeDiskDumpEntryScriptReadable(PrintStream writer, DiskStorage.DiskDumpInfoEntry entry) {
        writer.println(BaseFrescoStethoPlugin.formatStrLocaleSafe("%s\t%s", entry.type, entry.path));
    }

    private void writeCacheEntry(PrintStream writer, CountingMemoryCacheInspector.DumpInfoEntry<CacheKey, CloseableImage> entry) {
        if (!(entry.key instanceof BitmapMemoryCacheKey)) {
            writer.println("Undefined: " + ((CacheKey)entry.key).getClass());
        }
        BitmapMemoryCacheKey cacheKey = (BitmapMemoryCacheKey)entry.key;
        writer.println(BaseFrescoStethoPlugin.formatStrLocaleSafe("size: %7.2fkB (%4d x %4d) key: %s, %s, duration: %dms", Float.valueOf((float)((CloseableImage)entry.value.get()).getSizeInBytes() / 1024.0f), ((CloseableImage)entry.value.get()).getWidth(), ((CloseableImage)entry.value.get()).getHeight(), entry.key, cacheKey.getCallerContext(), RealtimeSinceBootClock.get().now() - cacheKey.getInBitmapCacheSince()));
    }

    private void memcache(PrintStream writer, List<String> args) throws DumpException {
        CountingMemoryCacheInspector.DumpInfo dumpInfo = this.mBitmapMemoryCacheInspector.dumpCacheContent();
        try {
            writer.println(this.mBitmapMemoryCacheInspector.getClass().getSimpleName());
            writer.println();
            writer.println("Params:");
            writer.println(BaseFrescoStethoPlugin.formatStrLocaleSafe("Max size:          %7.2fMB", (double)dumpInfo.maxSize / 1048576.0));
            writer.println(BaseFrescoStethoPlugin.formatStrLocaleSafe("Max entries count: %9d", dumpInfo.maxEntriesCount));
            writer.println(BaseFrescoStethoPlugin.formatStrLocaleSafe("Max entry size:    %7.2fMB", (double)dumpInfo.maxEntrySize / 1048576.0));
            writer.println();
            writer.println("Summary of current content:");
            writer.println(BaseFrescoStethoPlugin.formatStrLocaleSafe("Total size:        %7.2fMB (includes in-use content)", (double)dumpInfo.size / 1048576.0));
            writer.println(BaseFrescoStethoPlugin.formatStrLocaleSafe("Entries count:     %9d", dumpInfo.lruEntries.size() + dumpInfo.sharedEntries.size()));
            writer.println(BaseFrescoStethoPlugin.formatStrLocaleSafe("LRU size:          %7.2fMB", (double)dumpInfo.lruSize / 1048576.0));
            writer.println(BaseFrescoStethoPlugin.formatStrLocaleSafe("LRU count:         %9d", dumpInfo.lruEntries.size()));
            writer.println(BaseFrescoStethoPlugin.formatStrLocaleSafe("Shared size:       %7.2fMB", (double)(dumpInfo.size - dumpInfo.lruSize) / 1048576.0));
            writer.println(BaseFrescoStethoPlugin.formatStrLocaleSafe("Shared count:      %9d", dumpInfo.sharedEntries.size()));
            writer.println();
            writer.println("The cache consists of two parts: Things currently being used and things not.");
            writer.println("Those things that are *not* currently being used are in the LRU.");
            writer.println("Things currently being used are considered to be shared. They will be added");
            writer.println("to the LRU if/when they stop being used.");
            writer.println();
            writer.println("LRU contents: (things near the top will be evicted first)");
            for (CountingMemoryCacheInspector.DumpInfoEntry entry : dumpInfo.lruEntries) {
                this.writeCacheEntry(writer, (CountingMemoryCacheInspector.DumpInfoEntry<CacheKey, CloseableImage>)entry);
            }
            writer.println();
            writer.println("Shared contents:");
            for (CountingMemoryCacheInspector.DumpInfoEntry entry : dumpInfo.sharedEntries) {
                this.writeCacheEntry(writer, (CountingMemoryCacheInspector.DumpInfoEntry<CacheKey, CloseableImage>)entry);
            }
            if (!args.isEmpty() && "-g".equals(args.get(0))) {
                this.getFiles(writer, (CountingMemoryCacheInspector.DumpInfo<CacheKey, CloseableImage>)dumpInfo);
            }
        }
        catch (IOException e) {
            throw new DumpException(e.getMessage());
        }
        finally {
            dumpInfo.release();
        }
    }

    private void getFiles(PrintStream writer, CountingMemoryCacheInspector.DumpInfo<CacheKey, CloseableImage> dumpInfo) throws DumpException, IOException {
        writer.println("\nStoring all images in the memory cache into /sdcard/imagedumperfiles/ ...");
        File dir = new File(Environment.getExternalStorageDirectory().getPath() + "/imagedumperfiles/");
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles();
            if (files != null) {
                for (File file : files) {
                    file.delete();
                }
            }
            if (!dir.delete()) {
                throw new DumpException("Failed to clear existing /sdcard/imagedumperfiles directory");
            }
        }
        if (!dir.mkdirs()) {
            throw new DumpException("Failed to create /sdcard/imagedumperfiles directory");
        }
        if (!dumpInfo.lruEntries.isEmpty()) {
            writer.println("LRU Entries:");
            this.storeEntries(dumpInfo.lruEntries, 1, writer, dir);
        }
        if (!dumpInfo.sharedEntries.isEmpty()) {
            writer.println("Shared Entries:");
            this.storeEntries(dumpInfo.sharedEntries, dumpInfo.lruEntries.size() + 1, writer, dir);
        }
        writer.println("Done!");
    }

    private void storeEntries(List<CountingMemoryCacheInspector.DumpInfoEntry<CacheKey, CloseableImage>> entries, int i, PrintStream writer, File directory) throws IOException {
        for (CountingMemoryCacheInspector.DumpInfoEntry<CacheKey, CloseableImage> entry : entries) {
            CloseableImage closeableImage = (CloseableImage)entry.value.get();
            if (closeableImage instanceof CloseableBitmap) {
                CloseableBitmap closeableBitmap = (CloseableBitmap)closeableImage;
                String filename = "tmp" + i + ".png";
                writer.println(BaseFrescoStethoPlugin.formatStrLocaleSafe("Storing image %d as %s. Key: %s", i, filename, entry.key));
                this.storeImage(closeableBitmap.getUnderlyingBitmap(), new File(directory, filename), Bitmap.CompressFormat.PNG, 100);
            } else {
                writer.println(BaseFrescoStethoPlugin.formatStrLocaleSafe("Image %d has unrecognized type %s. Key: %s", i, closeableImage, entry.key));
            }
            ++i;
        }
    }

    private void storeImage(Bitmap image, File pictureFile, Bitmap.CompressFormat compressionFormat, int quality) throws IOException {
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(pictureFile);
            image.compress(compressionFormat, quality, (OutputStream)fos);
        }
    }

    private static void usage(PrintStream writer) {
        String cmdName = "dumpapp image";
        String usagePrefix = "Usage: dumpapp image ";
        writer.println("Usage: dumpapp image <command> [command-options]");
        writer.println("Usage: dumpapp image memcache|diskcache");
        writer.println();
        writer.println("dumpapp image memcache: Show contents of bitmap memory cache.");
        writer.println("dumpapp image memcache -g: Get contents of bitmap memory cache and store themon the sdcard.");
        writer.println("dumpapp image diskcache: Show contents of disk storage cache.");
        writer.println("dumpapp image diskcache -s: Show contents of disk storage cache formatted for script consumption.");
        writer.println("dumpapp image clear: Clear all caches.");
        writer.println();
    }

    private static String formatStrLocaleSafe(String format, Object ... args) {
        String str = String.format(null, "  " + format, args);
        return str;
    }
}

