/*
 * Decompiled with CFR 0.152.
 */
package com.eyeem.recyclerviewtools.adapter;

import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.util.LruCache;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import com.eyeem.recyclerviewtools.OnItemClickListener;
import com.eyeem.recyclerviewtools.adapter.AbstractSectionAdapter;
import com.eyeem.recyclerviewtools.adapter.EmptySectionAdapter;
import com.eyeem.recyclerviewtools.adapter.OnItemClickListenerDetector;
import com.eyeem.recyclerviewtools.adapter.StaggeredLayoutManagerInternalUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class WrapAdapter
extends RecyclerView.Adapter {
    private static final int MAX_CACHE_SIZE = 666;
    private static final int MAIN_VIEW_TYPE_MASK = 0x40000000;
    private static final long MAIN_ITEM_ID_MASK = 0x4000000000000000L;
    private static final int HEADER_VIEW_TYPE_MASK = 0x41000000;
    private static final long HEADER_ITEM_ID_MASK = 0x4100000000000000L;
    private static final int FOOTER_VIEW_TYPE_MASK = 0x42000000;
    private static final long FOOTER_ITEM_ID_MASK = 0x4200000000000000L;
    private static final int SECTION_VIEW_TYPE_MASK = 0x44000000;
    private static final long SECTION_ITEM_ID_MASK = 0x4400000000000000L;
    private static final int CUSTOM_VIEW_TYPE = Integer.MAX_VALUE;
    static final int NOT_A_SECTION = -1;
    private final RecyclerView.Adapter wrapped;
    private final AbstractSectionAdapter sections;
    private OnItemClickListenerDetector onItemClickListenerDetector;
    private boolean isReverseOrder = false;
    private List<View> headers;
    private List<View> footers;
    private final AtomicInteger headerViewTypeGenerator = new AtomicInteger();
    private final AtomicInteger footerViewTypeGenerator = new AtomicInteger();
    private SparseIntArray headerTypes;
    private SparseIntArray footerTypes;
    private View customView;
    private LruCache<Integer, Integer> sectionIndex;
    private LruCache<Integer, Integer> sectionPosition;
    LruCache<Integer, Integer> recyclerToWrappedPosition;
    private LruCache<Integer, Integer> wrappedToRecyclerPosition;
    private boolean lruCacheEnabled;
    private final RecyclerView.AdapterDataObserver dataObserver = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            WrapAdapter.this.clearCache();
            WrapAdapter.this.notifyDataSetChanged();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            WrapAdapter.this.clearCache();
            WrapAdapter.this.notifyItemRangeChanged((Integer)WrapAdapter.this.wrappedToRecyclerPosition.get((Object)positionStart), itemCount);
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            WrapAdapter.this.clearCache();
            WrapAdapter.this.notifyItemRangeInserted((Integer)WrapAdapter.this.wrappedToRecyclerPosition.get((Object)positionStart), itemCount);
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            WrapAdapter.this.clearCache();
            WrapAdapter.this.notifyItemRangeRemoved((Integer)WrapAdapter.this.wrappedToRecyclerPosition.get((Object)positionStart), itemCount);
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            WrapAdapter.this.clearCache();
            int from = (Integer)WrapAdapter.this.wrappedToRecyclerPosition.get((Object)fromPosition);
            int to = (Integer)WrapAdapter.this.wrappedToRecyclerPosition.get((Object)toPosition);
            for (int i = 0; i < itemCount; ++i) {
                WrapAdapter.this.notifyItemMoved(from + i, to + i);
            }
        }
    };
    private static boolean logEnabled = false;

    public WrapAdapter(RecyclerView.Adapter wrappedAdapter) {
        this(wrappedAdapter, new EmptySectionAdapter());
    }

    public WrapAdapter(RecyclerView.Adapter wrappedAdapter, AbstractSectionAdapter sectionAdapter) {
        if (wrappedAdapter == null || sectionAdapter == null) {
            throw new IllegalArgumentException("wrappedAdapter and sectionAdapter cannot be null");
        }
        this.wrapped = wrappedAdapter;
        this.sections = sectionAdapter;
        this.setHasStableIds(this.wrapped.hasStableIds());
        this.wrapped.registerAdapterDataObserver(this.dataObserver);
        int count = this.wrapped.getItemCount();
        int cacheSize = Math.min(count > 0 ? count : 333, 666);
        this.initPositionCaching(cacheSize);
    }

    public int getItemViewType(int position) {
        int type;
        if (this.customView != null) {
            type = Integer.MAX_VALUE;
        } else if (this.isHeaderPosition(position)) {
            type = 0x41000000 | this.headerTypes.get(this.getHeaders().get(position).hashCode());
        } else if (this.isFooterPosition(position)) {
            int footerPosition = position - this.getItemCount() + this.getFooterCount();
            type = 0x42000000 | this.footerTypes.get(this.getFooters().get(footerPosition).hashCode());
        } else {
            int sectionPosition = this.getSectionIndex(position);
            if (sectionPosition != -1) {
                type = 0x44000000 | this.sections.getSectionViewType(sectionPosition);
            } else {
                type = this.wrapped.getItemViewType(((Integer)this.recyclerToWrappedPosition.get((Object)position)).intValue());
                if (type > 0x40000000) {
                    throw new IllegalArgumentException("ItemView type cannot be greater than 0x" + Integer.toHexString(0x40000000));
                }
            }
        }
        WrapAdapter.l("getItemViewType for " + position + " = 0x" + Integer.toHexString(type));
        return type;
    }

    public long getItemId(int position) {
        long id;
        if (!this.hasStableIds()) {
            id = -1L;
        } else if (this.customView != null) {
            id = -1L;
        } else if (this.isHeaderPosition(position)) {
            id = 0x4100000000000000L | (long)this.getHeaders().get(position).hashCode();
        } else if (this.isFooterPosition(position)) {
            int footerPosition = position - this.getItemCount() + this.getFooterCount();
            id = 0x4200000000000000L | (long)this.getFooters().get(footerPosition).hashCode();
        } else {
            int sectionPosition = this.getSectionIndex(position);
            if (sectionPosition != -1) {
                id = 0x4400000000000000L | this.sections.getSectionId(sectionPosition);
            } else {
                id = this.wrapped.getItemId(((Integer)this.recyclerToWrappedPosition.get((Object)position)).intValue());
                if (id > 0x4000000000000000L) {
                    throw new IllegalArgumentException("ItemView type cannot be greater than 0x" + Long.toHexString(0x4000000000000000L));
                }
            }
        }
        WrapAdapter.l("getItemId for " + position + " = 0x" + Long.toHexString(id));
        return id;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        Object viewHolder;
        if (this.customView != null && viewType == Integer.MAX_VALUE) {
            HeaderFooterHolder viewHolder2 = new HeaderFooterHolder(this.customView);
            StaggeredLayoutManagerInternalUtils.setFullWidthLayoutParams((View)parent, viewHolder2);
            return viewHolder2;
        }
        boolean extra = false;
        if (WrapAdapter.isHeaderViewType(viewType)) {
            extra = true;
            viewHolder = new HeaderFooterHolder(WrapAdapter.findViewByType(WrapAdapter.removeMask(viewType, 0x41000000), this.getHeaders(), this.headerTypes));
            StaggeredLayoutManagerInternalUtils.setFullWidthLayoutParams((View)parent, viewHolder);
        } else if (WrapAdapter.isFooterViewType(viewType)) {
            extra = true;
            viewHolder = new HeaderFooterHolder(WrapAdapter.findViewByType(WrapAdapter.removeMask(viewType, 0x42000000), this.getFooters(), this.footerTypes));
            StaggeredLayoutManagerInternalUtils.setFullWidthLayoutParams((View)parent, viewHolder);
        } else if (WrapAdapter.isSectionViewType(viewType)) {
            extra = true;
            viewHolder = this.sections.onCreateSectionViewHolder(parent, WrapAdapter.removeMask(viewType, 0x44000000));
            StaggeredLayoutManagerInternalUtils.setFullWidthLayoutParams((View)parent, viewHolder);
        } else {
            viewHolder = this.wrapped.onCreateViewHolder(parent, viewType);
        }
        this.bindOnItemClickListener((RecyclerView.ViewHolder)viewHolder, extra);
        return viewHolder;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (holder instanceof HeaderFooterHolder) {
            return;
        }
        if (WrapAdapter.isSectionViewType(holder.getItemViewType())) {
            this.sections.onBindSectionView(holder, this.getSectionIndex(position));
        } else {
            this.wrapped.onBindViewHolder(holder, ((Integer)this.recyclerToWrappedPosition.get((Object)position)).intValue());
        }
    }

    public int getItemCount() {
        if (this.customView != null) {
            return 1;
        }
        return this.wrapped.getItemCount() + this.sections.getSectionCount() + this.getHeaderCount() + this.getFooterCount();
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        if (holder instanceof HeaderFooterHolder || WrapAdapter.isSectionViewType(holder.getItemViewType())) {
            return;
        }
        this.wrapped.onViewAttachedToWindow(holder);
    }

    public void onViewDetachedFromWindow(RecyclerView.ViewHolder holder) {
        if (holder instanceof HeaderFooterHolder || WrapAdapter.isSectionViewType(holder.getItemViewType())) {
            return;
        }
        this.wrapped.onViewDetachedFromWindow(holder);
    }

    public void onViewRecycled(RecyclerView.ViewHolder holder) {
        if (holder instanceof HeaderFooterHolder || WrapAdapter.isSectionViewType(holder.getItemViewType())) {
            return;
        }
        this.wrapped.onViewRecycled(holder);
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        this.wrapped.onAttachedToRecyclerView(recyclerView);
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        this.wrapped.onDetachedFromRecyclerView(recyclerView);
    }

    public boolean onFailedToRecycleView(RecyclerView.ViewHolder holder) {
        if (holder instanceof HeaderFooterHolder || WrapAdapter.isSectionViewType(holder.getItemViewType())) {
            return super.onFailedToRecycleView(holder);
        }
        return this.wrapped.onFailedToRecycleView(holder);
    }

    public void setOnItemClickListener(RecyclerView recyclerView, OnItemClickListener onItemClickListener) {
        this.setOnItemClickListener(recyclerView, onItemClickListener, true);
    }

    public void setOnItemClickListener(RecyclerView recyclerView, OnItemClickListener onItemClickListener, boolean ignoreExtras) {
        this.onItemClickListenerDetector = new OnItemClickListenerDetector(recyclerView, onItemClickListener, ignoreExtras);
    }

    private void bindOnItemClickListener(RecyclerView.ViewHolder holder, boolean isExtra) {
        if (this.onItemClickListenerDetector == null) {
            return;
        }
        if (this.onItemClickListenerDetector.ignoreExtras && isExtra) {
            return;
        }
        holder.itemView.setOnClickListener((View.OnClickListener)this.onItemClickListenerDetector);
    }

    private static boolean isHeaderViewType(int viewType) {
        return WrapAdapter.isViewType(viewType, 0x41000000);
    }

    private static boolean isFooterViewType(int viewType) {
        return WrapAdapter.isViewType(viewType, 0x42000000);
    }

    private static boolean isSectionViewType(int viewType) {
        return WrapAdapter.isViewType(viewType, 0x44000000);
    }

    private static boolean isViewType(int viewType, int viewTypeMask) {
        return (viewTypeMask & viewType) == viewTypeMask;
    }

    private static int removeMask(int val, int mask) {
        return val & ~mask;
    }

    private static View findViewByType(int viewType, List<View> views, SparseIntArray hashToType) {
        int size = views.size();
        for (int i = 0; i < size; ++i) {
            View v = views.get(i);
            int thisViewType = hashToType.get(v.hashCode());
            if (thisViewType != viewType) continue;
            return v;
        }
        return null;
    }

    public void addHeader(View v) {
        if (!this.getHeaders().contains(v)) {
            this.setDefaultLayoutParams(v);
            this.getHeaders().add(v);
            this.headerTypes.put(v.hashCode(), this.headerViewTypeGenerator.incrementAndGet());
            this.clearCache();
        }
    }

    public void removeHeader(View v, boolean autoNotify) {
        if (this.headers == null) {
            return;
        }
        if (this.getHeaders().contains(v)) {
            int position = -1;
            if (autoNotify) {
                position = this.getHeaders().indexOf(v);
            }
            if (this.getHeaders().remove(v)) {
                this.headerTypes.delete(v.hashCode());
                this.clearCache();
                if (autoNotify && position >= 0) {
                    this.notifyItemRemoved(position);
                }
            }
        }
    }

    public void addFooter(View v) {
        if (!this.getFooters().contains(v)) {
            this.setDefaultLayoutParams(v);
            this.getFooters().add(v);
            this.footerTypes.put(v.hashCode(), this.footerViewTypeGenerator.incrementAndGet());
            this.clearCache();
        }
    }

    public void removeFooter(View v, boolean autoNotify) {
        if (this.footers == null) {
            return;
        }
        if (this.getFooters().contains(v)) {
            int position = -1;
            if (autoNotify) {
                position = this.getFooters().indexOf(v);
            }
            if (this.getFooters().remove(v)) {
                this.footerTypes.delete(v.hashCode());
                this.clearCache();
                if (autoNotify && position >= 0) {
                    this.notifyItemRemoved(this.getHeaderCount() + this.sections.getSectionCount() + this.getWrappedCount() + position);
                }
            }
        }
    }

    private void setDefaultLayoutParams(View v) {
        if (v.getLayoutParams() == null) {
            RecyclerView.LayoutParams lp = new RecyclerView.LayoutParams(-1, -2);
            v.setLayoutParams((ViewGroup.LayoutParams)lp);
        }
    }

    private boolean isHeaderPosition(int position) {
        return position < this.getHeaderCount();
    }

    private boolean isFooterPosition(int position) {
        int footerCount = this.getFooterCount();
        if (footerCount == 0) {
            return false;
        }
        return this.getItemCount() - position <= footerCount;
    }

    private List<View> getHeaders() {
        if (this.headers == null) {
            this.headers = new ArrayList<View>();
        }
        if (this.headerTypes == null) {
            this.headerTypes = new SparseIntArray();
        }
        return this.headers;
    }

    private List<View> getFooters() {
        if (this.footers == null) {
            this.footers = new ArrayList<View>();
        }
        if (this.footerTypes == null) {
            this.footerTypes = new SparseIntArray();
        }
        return this.footers;
    }

    public int getHeaderCount() {
        return this.headers == null ? 0 : this.headers.size();
    }

    public int getFooterCount() {
        return this.footers == null ? 0 : this.footers.size();
    }

    public int getWrappedCount() {
        return this.wrapped.getItemCount();
    }

    public RecyclerView.Adapter getWrapped() {
        return this.wrapped;
    }

    public void setCustomView(View view) {
        if (this.customView == null && view == null) {
            return;
        }
        if (this.customView != null && view != null && this.customView.equals(view)) {
            return;
        }
        this.customView = view;
        this.notifyDataSetChanged();
    }

    private int getSectionIndex(int position) {
        position -= this.getHeaderCount();
        if (this.lruCacheEnabled) {
            return (Integer)this.sectionIndex.get((Object)position);
        }
        return this.sections.getSectionIndex(position);
    }

    private int getSectionPosition(int index) {
        if (this.lruCacheEnabled) {
            return (Integer)this.sectionPosition.get((Object)index);
        }
        return this.sections.getSectionPosition(index);
    }

    private void initPositionCaching(int cacheSize) {
        this.lruCacheEnabled = this.sections.lruCacheEnabled();
        if (this.lruCacheEnabled) {
            this.sectionIndex = new LruCache<Integer, Integer>(cacheSize){

                protected Integer create(Integer position) {
                    return WrapAdapter.this.sections.getSectionIndex(position - WrapAdapter.this.getHeaderCount());
                }
            };
            this.sectionPosition = new LruCache<Integer, Integer>(cacheSize){

                protected Integer create(Integer index) {
                    return WrapAdapter.this.sections.getSectionPosition(index);
                }
            };
        }
        this.recyclerToWrappedPosition = new LruCache<Integer, Integer>(cacheSize){

            protected Integer create(Integer position) {
                int numberOfSectionsBeforePosition = 0;
                for (int i = position.intValue(); i >= WrapAdapter.this.getHeaderCount(); --i) {
                    int sectionIndexVal = WrapAdapter.this.getSectionIndex(i);
                    if (sectionIndexVal == -1) continue;
                    numberOfSectionsBeforePosition = sectionIndexVal + 1;
                    break;
                }
                int retVal = position - numberOfSectionsBeforePosition - WrapAdapter.this.getHeaderCount();
                if (WrapAdapter.this.isReverseOrder) {
                    retVal = WrapAdapter.this.wrapped.getItemCount() - 1 - retVal;
                }
                return retVal;
            }
        };
        this.wrappedToRecyclerPosition = new LruCache<Integer, Integer>(cacheSize){

            protected Integer create(Integer position) {
                int value = position;
                for (int i = 0; i < WrapAdapter.this.sections.getSectionCount() && WrapAdapter.this.getSectionPosition(i) <= value; ++value, ++i) {
                }
                return value + WrapAdapter.this.getHeaderCount();
            }
        };
    }

    private void clearCache() {
        if (this.sectionIndex != null) {
            this.sectionIndex.evictAll();
        }
        if (this.sectionPosition != null) {
            this.sectionPosition.evictAll();
        }
        this.recyclerToWrappedPosition.evictAll();
        this.wrappedToRecyclerPosition.evictAll();
    }

    public void setIsReverseOrder(boolean isReverseOrder) {
        this.isReverseOrder = isReverseOrder;
        this.clearCache();
    }

    public GridLayoutManager.SpanSizeLookup createSpanSizeLookup(int spanCount) {
        return new SectionSpanSizeLookup(null, spanCount);
    }

    public GridLayoutManager.SpanSizeLookup createSpanSizeLookup(GridLayoutManager.SpanSizeLookup wrap, int spanCount) {
        return new SectionSpanSizeLookup(wrap, spanCount);
    }

    public static void setLogging(boolean enabled) {
        logEnabled = enabled;
    }

    private static void l(String message) {
        if (logEnabled) {
            Log.d((String)"WrapAdapter", (String)message);
        }
    }

    private final class SectionSpanSizeLookup
    extends GridLayoutManager.SpanSizeLookup {
        private final GridLayoutManager.SpanSizeLookup source;
        private final int spanCount;

        private SectionSpanSizeLookup(GridLayoutManager.SpanSizeLookup source, int spanCount) {
            this.source = source;
            this.spanCount = spanCount;
        }

        public int getSpanSize(int position) {
            if (WrapAdapter.this.isHeaderPosition(position)) {
                return this.spanCount;
            }
            if (WrapAdapter.this.isFooterPosition(position)) {
                return this.spanCount;
            }
            int sectionIndexVal = WrapAdapter.this.getSectionIndex(position);
            if (sectionIndexVal != -1) {
                return this.spanCount;
            }
            if (this.source == null) {
                return 1;
            }
            return this.source.getSpanSize(((Integer)WrapAdapter.this.recyclerToWrappedPosition.get((Object)position)).intValue());
        }
    }

    private static class HeaderFooterHolder
    extends RecyclerView.ViewHolder {
        public HeaderFooterHolder(View itemView) {
            super(itemView);
        }
    }
}

