/*
 * Decompiled with CFR 0.152.
 */
package com.eyeem.recyclerviewtools;

import android.graphics.Rect;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.View;
import android.view.ViewGroup;
import com.eyeem.recyclerviewtools.adapter.WrapAdapter;

public class ItemOffsetDecoration
extends RecyclerView.ItemDecoration {
    private final Rect externalOffset;
    private final Rect internalOffset;
    private final boolean disableHeaderSpacing;

    public ItemOffsetDecoration(int offsetLeft, int offsetTop, int offsetRight, int offsetBottom, boolean disableHeaderSpacing) {
        this(new Rect(offsetLeft, offsetTop, offsetRight, offsetBottom), new Rect(offsetLeft, offsetTop, offsetRight, offsetBottom), disableHeaderSpacing);
    }

    public ItemOffsetDecoration(Rect externalOffset, Rect internalOffset, boolean disableHeaderSpacing) {
        this.externalOffset = externalOffset;
        this.internalOffset = internalOffset;
        this.disableHeaderSpacing = disableHeaderSpacing;
    }

    public ItemOffsetDecoration(int externalOffsetLeft, int externalOffsetTop, int externalOffsetRight, int externalOffsetBottom, int internalOffsetLeft, int internalOffsetTop, int internalOffsetRight, int internalOffsetBottom, boolean disableHeaderSpacing) {
        this(new Rect(externalOffsetLeft, externalOffsetTop, externalOffsetRight, externalOffsetBottom), new Rect(internalOffsetLeft, internalOffsetTop, internalOffsetRight, internalOffsetBottom), disableHeaderSpacing);
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        boolean isRight;
        boolean isLeft;
        WrapAdapter wrapAdapter = null;
        RecyclerView.Adapter adapter = parent.getAdapter();
        int adapterCount = adapter.getItemCount();
        if (adapter instanceof WrapAdapter) {
            wrapAdapter = (WrapAdapter)adapter;
            adapter = wrapAdapter.getWrapped();
        }
        int numHeaders = wrapAdapter == null ? 0 : wrapAdapter.getHeaderCount();
        int adapterPosition = parent.getChildAdapterPosition(view);
        int offsetAdapterPosition = adapterPosition - numHeaders;
        int spanCount = 1;
        RecyclerView.LayoutManager lm = parent.getLayoutManager();
        if (lm instanceof GridLayoutManager) {
            spanCount = ((GridLayoutManager)lm).getSpanCount();
        } else if (lm instanceof StaggeredGridLayoutManager) {
            spanCount = ((StaggeredGridLayoutManager)lm).getSpanCount();
        }
        if (adapterPosition < numHeaders) {
            if (this.disableHeaderSpacing) {
                outRect.set(0, 0, 0, 0);
            } else {
                outRect.set(this.externalOffset);
            }
            return;
        }
        boolean isTop = offsetAdapterPosition < spanCount;
        boolean isBottom = adapterCount - adapterPosition < spanCount;
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        if (lp instanceof GridLayoutManager.LayoutParams) {
            GridLayoutManager.LayoutParams glp = (GridLayoutManager.LayoutParams)lp;
            isLeft = glp.getSpanIndex() == 0;
            isRight = glp.getSpanIndex() + glp.getSpanSize() == spanCount;
        } else if (lp instanceof StaggeredGridLayoutManager.LayoutParams) {
            StaggeredGridLayoutManager.LayoutParams sglp = (StaggeredGridLayoutManager.LayoutParams)lp;
            isLeft = sglp.getSpanIndex() == 0;
            isRight = sglp.getSpanIndex() == spanCount - 1;
        } else {
            int itemColumn = offsetAdapterPosition % spanCount;
            isLeft = itemColumn == 0;
            isRight = itemColumn == spanCount - 1;
        }
        outRect.set(this.internalOffset);
        if (isTop) {
            outRect.top = this.externalOffset.top;
        }
        if (isBottom) {
            outRect.bottom = this.externalOffset.bottom;
        }
        if (isLeft) {
            outRect.left = this.externalOffset.left;
        }
        if (isRight) {
            outRect.right = this.externalOffset.right;
        }
    }
}

