/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.server.spring;

import com.apollographql.federation.graphqljava.tracing.FederatedTracingInstrumentation;
import com.expediagroup.graphql.generator.TopLevelNames;
import com.expediagroup.graphql.generator.TopLevelObject;
import com.expediagroup.graphql.generator.execution.KotlinDataFetcherFactoryProvider;
import com.expediagroup.graphql.generator.extensions.GraphQLSchemaExtensionsKt;
import com.expediagroup.graphql.generator.federation.FederatedClasspathTypeResolver;
import com.expediagroup.graphql.generator.federation.FederatedGraphQLTypeResolver;
import com.expediagroup.graphql.generator.federation.FederatedSchemaGeneratorConfig;
import com.expediagroup.graphql.generator.federation.FederatedSchemaGeneratorHooks;
import com.expediagroup.graphql.generator.federation.ToFederatedSchemaKt;
import com.expediagroup.graphql.generator.federation.execution.FederatedTypeResolver;
import com.expediagroup.graphql.generator.internal.state.ClassScanner;
import com.expediagroup.graphql.server.Schema;
import com.expediagroup.graphql.server.operations.Mutation;
import com.expediagroup.graphql.server.operations.Query;
import com.expediagroup.graphql.server.operations.Subscription;
import com.expediagroup.graphql.server.spring.GraphQLConfigurationProperties;
import com.expediagroup.graphql.server.spring.GraphQLExecutionConfiguration;
import com.expediagroup.graphql.server.spring.extensions.GeneratorExtensionsKt;
import graphql.schema.GraphQLSchema;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@ConditionalOnProperty(value={"graphql.federation.enabled"}, havingValue="true")
@Configuration
@Import(value={GraphQLExecutionConfiguration.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0017J.\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0017J\u001c\u0010\u0014\u001a\u00020\r2\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u000fH\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0017JZ\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u00160\u000f2\u0012\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u00160\u000f2\u0012\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0\u00160\u000f2\u0006\u0010\"\u001a\u00020\u000b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u000fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/expediagroup/graphql/server/spring/FederatedSchemaAutoConfiguration;", "", "config", "Lcom/expediagroup/graphql/server/spring/GraphQLConfigurationProperties;", "(Lcom/expediagroup/graphql/server/spring/GraphQLConfigurationProperties;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "federatedGraphQLTypeResolver", "Lcom/expediagroup/graphql/generator/federation/FederatedGraphQLTypeResolver;", "federatedSchemaConfig", "Lcom/expediagroup/graphql/generator/federation/FederatedSchemaGeneratorConfig;", "hooks", "Lcom/expediagroup/graphql/generator/federation/FederatedSchemaGeneratorHooks;", "topLevelNames", "Ljava/util/Optional;", "Lcom/expediagroup/graphql/generator/TopLevelNames;", "dataFetcherFactoryProvider", "Lcom/expediagroup/graphql/generator/execution/KotlinDataFetcherFactoryProvider;", "typeResolver", "federatedSchemaGeneratorHooks", "resolvers", "", "Lcom/expediagroup/graphql/generator/federation/execution/FederatedTypeResolver;", "federatedTracing", "Lcom/apollographql/federation/graphqljava/tracing/FederatedTracingInstrumentation;", "schema", "Lgraphql/schema/GraphQLSchema;", "queries", "Lcom/expediagroup/graphql/server/operations/Query;", "mutations", "Lcom/expediagroup/graphql/server/operations/Mutation;", "subscriptions", "Lcom/expediagroup/graphql/server/operations/Subscription;", "schemaConfig", "schemaObject", "Lcom/expediagroup/graphql/server/Schema;", "graphql-kotlin-spring-server"})
public class FederatedSchemaAutoConfiguration {
    @NotNull
    private final GraphQLConfigurationProperties config;
    private final Logger logger;

    public FederatedSchemaAutoConfiguration(@NotNull GraphQLConfigurationProperties config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.logger = LoggerFactory.getLogger(FederatedSchemaAutoConfiguration.class);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public FederatedSchemaGeneratorHooks federatedSchemaGeneratorHooks(@NotNull Optional<List<FederatedTypeResolver>> resolvers) {
        Intrinsics.checkNotNullParameter(resolvers, (String)"resolvers");
        List<FederatedTypeResolver> list = resolvers.orElse(CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"orElse(...)");
        return new FederatedSchemaGeneratorHooks(list);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public FederatedGraphQLTypeResolver federatedGraphQLTypeResolver() {
        return (FederatedGraphQLTypeResolver)new FederatedClasspathTypeResolver(new ClassScanner(this.config.getPackages()));
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public FederatedSchemaGeneratorConfig federatedSchemaConfig(@NotNull FederatedSchemaGeneratorHooks hooks, @NotNull Optional<TopLevelNames> topLevelNames, @NotNull KotlinDataFetcherFactoryProvider dataFetcherFactoryProvider, @NotNull FederatedGraphQLTypeResolver typeResolver) {
        Intrinsics.checkNotNullParameter((Object)hooks, (String)"hooks");
        Intrinsics.checkNotNullParameter(topLevelNames, (String)"topLevelNames");
        Intrinsics.checkNotNullParameter((Object)dataFetcherFactoryProvider, (String)"dataFetcherFactoryProvider");
        Intrinsics.checkNotNullParameter((Object)typeResolver, (String)"typeResolver");
        List<String> list = this.config.getPackages();
        TopLevelNames topLevelNames2 = topLevelNames.orElse(new TopLevelNames(null, null, null, 7, null));
        Intrinsics.checkNotNullExpressionValue((Object)topLevelNames2, (String)"orElse(...)");
        return new FederatedSchemaGeneratorConfig(list, topLevelNames2, hooks, dataFetcherFactoryProvider, this.config.getIntrospection().getEnabled(), null, typeResolver, 32, null);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public GraphQLSchema schema(@NotNull Optional<List<Query>> queries, @NotNull Optional<List<Mutation>> mutations, @NotNull Optional<List<Subscription>> subscriptions, @NotNull FederatedSchemaGeneratorConfig schemaConfig, @NotNull Optional<Schema> schemaObject) {
        GraphQLSchema graphQLSchema;
        Intrinsics.checkNotNullParameter(queries, (String)"queries");
        Intrinsics.checkNotNullParameter(mutations, (String)"mutations");
        Intrinsics.checkNotNullParameter(subscriptions, (String)"subscriptions");
        Intrinsics.checkNotNullParameter((Object)schemaConfig, (String)"schemaConfig");
        Intrinsics.checkNotNullParameter(schemaObject, (String)"schemaObject");
        List<Query> list = queries.orElse(CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"orElse(...)");
        List<TopLevelObject> list2 = GeneratorExtensionsKt.toTopLevelObjects(list);
        List<Mutation> list3 = mutations.orElse(CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue(list3, (String)"orElse(...)");
        List<TopLevelObject> list4 = GeneratorExtensionsKt.toTopLevelObjects(list3);
        List<Subscription> list5 = subscriptions.orElse(CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue(list5, (String)"orElse(...)");
        Schema schema = schemaObject.orElse(null);
        GraphQLSchema federatedSchema = graphQLSchema = ToFederatedSchemaKt.toFederatedSchema((FederatedSchemaGeneratorConfig)schemaConfig, list2, list4, GeneratorExtensionsKt.toTopLevelObjects(list5), (TopLevelObject)(schema != null ? GeneratorExtensionsKt.toTopLevelObject(schema) : null));
        boolean bl = false;
        if (this.config.getPrintSchema()) {
            this.logger.info("\n" + GraphQLSchemaExtensionsKt.print$default((GraphQLSchema)federatedSchema, (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, (boolean)false, (int)63, null));
        }
        return graphQLSchema;
    }

    @Bean
    @ConditionalOnProperty(value={"graphql.federation.tracing.enabled"}, havingValue="true", matchIfMissing=true)
    @NotNull
    public FederatedTracingInstrumentation federatedTracing() {
        return new FederatedTracingInstrumentation(new FederatedTracingInstrumentation.Options(this.config.getFederation().getTracing().getDebug()));
    }
}

