/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.message;

import com.epam.reportportal.message.MessageParser;
import com.epam.reportportal.message.ReportPortalMessage;
import com.epam.reportportal.message.TypeAwareByteSource;
import com.epam.reportportal.utils.MimeTypeDetector;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import rp.com.google.common.base.Joiner;
import rp.com.google.common.base.Splitter;
import rp.com.google.common.io.BaseEncoding;
import rp.com.google.common.io.ByteSource;
import rp.com.google.common.io.Files;
import rp.com.google.common.io.Resources;

public class HashMarkSeparatedMessageParser
implements MessageParser {
    private static final int CHUNKS_COUNT = 4;

    @Override
    public ReportPortalMessage parse(String message) throws IOException {
        List<String> split = Splitter.on("#").limit(4).splitToList(message);
        if (4 != split.size()) {
            throw new RuntimeException("Incorrect message format. Chunks: " + Joiner.on("\n").join(split) + "\n count: " + split.size());
        }
        return new ReportPortalMessage(MessageType.fromString(split.get(1)).toByteSource(split.get(2)), split.get(3));
    }

    @Override
    public boolean supports(String message) {
        return message.startsWith("RP_MESSAGE");
    }

    private static enum MessageType {
        FILE{

            @Override
            public TypeAwareByteSource toByteSource(String data) throws IOException {
                File file = new File(data);
                if (!file.exists()) {
                    return null;
                }
                return new TypeAwareByteSource(Files.asByteSource(file), MimeTypeDetector.detect(file));
            }
        }
        ,
        BASE64{

            @Override
            public TypeAwareByteSource toByteSource(String data) throws IOException {
                if (data.contains(":")) {
                    String[] parts = data.split(":");
                    String type = parts[1];
                    return new TypeAwareByteSource(ByteSource.wrap(BaseEncoding.base64().decode(parts[0])), type);
                }
                ByteSource source = ByteSource.wrap(BaseEncoding.base64().decode(data));
                return new TypeAwareByteSource(source, MimeTypeDetector.detect(source, null));
            }
        }
        ,
        RESOURCE{

            @Override
            public TypeAwareByteSource toByteSource(String resourceName) throws IOException {
                URL resource = Resources.getResource(resourceName);
                if (null == resource) {
                    return null;
                }
                ByteSource source = Resources.asByteSource(resource);
                return new TypeAwareByteSource(source, MimeTypeDetector.detect(source, resourceName));
            }
        };


        public abstract TypeAwareByteSource toByteSource(String var1) throws IOException;

        public static MessageType fromString(String messageType) {
            return MessageType.valueOf(messageType);
        }
    }
}

