/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.junit;

import com.epam.reportportal.junit.IListenerHandler;
import com.epam.reportportal.junit.JUnitInjectorProvider;
import com.nordstrom.automation.junit.AtomicTest;
import com.nordstrom.automation.junit.MethodWatcher;
import com.nordstrom.automation.junit.RunWatcher;
import com.nordstrom.automation.junit.RunnerWatcher;
import com.nordstrom.automation.junit.ShutdownListener;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;

public class ReportPortalListener
implements ShutdownListener,
RunnerWatcher,
RunWatcher,
MethodWatcher {
    private static volatile IListenerHandler handler = (IListenerHandler)JUnitInjectorProvider.getInstance().getInstance(IListenerHandler.class);

    public void onShutdown() {
        handler.stopLaunch();
    }

    public void runStarted(Object runner) {
        boolean isSuite = runner instanceof Suite;
        handler.startRunner(runner, isSuite);
    }

    public void runFinished(Object runner) {
        handler.stopRunner(runner);
    }

    public void testStarted(AtomicTest atomicTest) {
    }

    public void testFinished(AtomicTest atomicTest) {
    }

    public void testFailure(AtomicTest atomicTest, Throwable thrown) {
    }

    public void testAssumptionFailure(AtomicTest atomicTest, AssumptionViolatedException thrown) {
    }

    public void testIgnored(AtomicTest atomicTest) {
        handler.handleTestSkip(atomicTest.getIdentity(), atomicTest.getRunner());
    }

    public void beforeInvocation(Object runner, Object target, FrameworkMethod method, Object ... params) {
        if (handler.isReportable(method)) {
            handler.startTestMethod(method, runner);
        }
    }

    public void afterInvocation(Object runner, Object target, FrameworkMethod method, Throwable thrown) {
        if (handler.isReportable(method)) {
            if (thrown != null) {
                this.reportTestFailure(method, runner, thrown);
            }
            handler.stopTestMethod(method, runner);
        }
    }

    public void reportTestFailure(FrameworkMethod method, Object runner, Throwable thrown) {
        handler.sendReportPortalMsg(method, runner, thrown);
        handler.markCurrentTestMethod(method, runner, "FAILED");
    }

    static {
        handler.startLaunch();
    }
}

