/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.handlers.proxy;

import com.epam.healenium.SelfHealingEngine;
import com.epam.healenium.config.ProcessorConfig;
import com.epam.healenium.handlers.proxy.BaseHandler;
import com.epam.healenium.model.Context;
import com.epam.healenium.processor.BaseProcessor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebElementProxyHandler
extends BaseHandler
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger((String)"healenium");
    private WebElement delegate;

    public WebElementProxyHandler(WebElement delegate, SelfHealingEngine engine) {
        super(engine);
        this.delegate = delegate;
        this.findElementChainProcessor = ProcessorConfig.findChildElementChainProcessor();
        this.findElementsChainProcessor = ProcessorConfig.findChildElementsChainProcessor();
    }

    public WebElementProxyHandler(SelfHealingEngine engine) {
        super(engine);
        this.findElementChainProcessor = ProcessorConfig.findChildElementChainProcessor();
        this.findElementsChainProcessor = ProcessorConfig.findChildElementsChainProcessor();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            ClassLoader loader = this.driver.getClass().getClassLoader();
            if ("findElement".equals(method.getName())) {
                WebElement element = this.findElement((By)args[0]);
                return this.engine.isProxy() ? element : Optional.ofNullable(element).map(it -> this.wrapElement((WebElement)it, loader)).orElse(null);
            }
            if ("findElements".equals(method.getName())) {
                List<WebElement> elements = this.findElements((By)args[0]);
                return this.engine.isProxy() ? elements : elements.stream().map(it -> this.wrapElement((WebElement)it, loader)).collect(Collectors.toList());
            }
            if ("getWrappedElement".equals(method.getName())) {
                return this.delegate;
            }
            return method.invoke((Object)this.delegate, args);
        }
        catch (Exception ex) {
            throw ex.getCause();
        }
    }

    @Override
    public WebElement findElement(By by) {
        try {
            if (this.engine.getSessionContext().isWaitCommand()) {
                this.engine.getSessionContext().setFindElementWaitCommand(true);
            }
            if (this.engine.isHealingEnabled()) {
                Context context = new Context().setBy(by).setAction("findElement");
                this.setBaseProcessorFields(this.findElementChainProcessor, context);
                this.findElementChainProcessor.process();
                if (context.getElements().size() > 0) {
                    return context.getElements().get(0);
                }
                throw context.getNoSuchElementException();
            }
            return this.delegate.findElement(by);
        }
        catch (Exception ex) {
            throw new NoSuchElementException("Failed to find element using " + by.toString(), (Throwable)ex);
        }
    }

    @Override
    public List<WebElement> findElements(By by) {
        try {
            if (this.engine.getSessionContext().isWaitCommand()) {
                this.engine.getSessionContext().setFindElementWaitCommand(true);
            }
            if (this.engine.isHealingEnabled()) {
                Context context = new Context().setBy(by).setAction("findElements");
                this.setBaseProcessorFields(this.findElementsChainProcessor, context);
                this.findElementsChainProcessor.process();
                return context.getElements();
            }
            return this.delegate.findElements(by);
        }
        catch (Exception ex) {
            throw new NoSuchElementException("Failed to find elements using " + by.toString(), (Throwable)ex);
        }
    }

    @Override
    protected void setBaseProcessorFields(BaseProcessor baseProcessor, Context context) {
        super.setBaseProcessorFields(baseProcessor, context);
        baseProcessor.setDelegateElement(this.delegate);
    }

    public WebElementProxyHandler setDelegate(WebElement delegate) {
        this.delegate = delegate;
        return this;
    }
}

