/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.converter;

import com.epam.healenium.treecomparing.Node;
import com.epam.healenium.treecomparing.NodeBuilder;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.Map;

public class NodeDeserializer
extends JsonDeserializer<Node> {
    public Node deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        ObjectCodec codec = parser.getCodec();
        TreeNode tree = parser.readValueAsTree();
        String tag = (String)codec.treeToValue(tree.path("tag"), String.class);
        Integer index = (Integer)codec.treeToValue(tree.path("index"), Integer.class);
        String innerText = (String)codec.treeToValue(tree.path("innerText"), String.class);
        String id = (String)codec.treeToValue(tree.path("id"), String.class);
        String classes = (String)codec.treeToValue(tree.path("classes"), String.class);
        Map attributes = (Map)codec.treeToValue(tree.path("other"), Map.class);
        attributes.put("id", id);
        attributes.put("class", classes);
        return new NodeBuilder().setTag(tag).setIndex(index.intValue()).addContent(innerText).setAttributes(attributes).build();
    }
}

