/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.client;

import com.epam.healenium.converter.NodeDeserializer;
import com.epam.healenium.converter.NodeSerializer;
import com.epam.healenium.mapper.HealeniumMapper;
import com.epam.healenium.model.HealeniumSelectorImitatorDto;
import com.epam.healenium.model.LastHealingDataDto;
import com.epam.healenium.model.Locator;
import com.epam.healenium.model.MetricsDto;
import com.epam.healenium.model.RequestDto;
import com.epam.healenium.treecomparing.Node;
import com.epam.healenium.utils.SystemUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.typesafe.config.Config;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.openqa.selenium.By;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClient {
    private static final Logger log = LoggerFactory.getLogger(RestClient.class);
    private final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    private final String baseUrl;
    private final String imitateUrl;
    private final String sessionKey;
    private final ObjectMapper objectMapper = this.initMapper();
    private final HealeniumMapper mapper;

    public RestClient(Config config) {
        this.baseUrl = "http://" + config.getString("serverHost") + ":" + config.getInt("serverPort") + "/healenium";
        this.imitateUrl = "http://" + config.getString("serverHost") + ":" + config.getInt("imitatePort") + "/imitate";
        this.sessionKey = config.hasPath("sessionKey") ? config.getString("sessionKey") : "";
        this.mapper = new HealeniumMapper();
    }

    private OkHttpClient okHttpClient() {
        return new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).build();
    }

    private ObjectMapper initMapper() {
        SimpleModule module = new SimpleModule("node");
        module.addSerializer(Node.class, (JsonSerializer)new NodeSerializer());
        module.addDeserializer(Node.class, (JsonDeserializer)new NodeDeserializer());
        ObjectMapper mapper = new ObjectMapper().registerModule((Module)module);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        return mapper;
    }

    public void selectorsRequest(By by, List<List<Node>> nodePath) {
        RequestDto requestDto = this.mapper.buildDto(by, nodePath);
        try {
            RequestBody body = RequestBody.create((MediaType)this.JSON, (String)this.objectMapper.writeValueAsString((Object)requestDto));
            Request request = new Request.Builder().url(this.baseUrl).post(body).build();
            this.okHttpClient().newCall(request).execute();
        }
        catch (Exception e) {
            log.warn("Failed to make response: " + e.getMessage());
        }
    }

    public void healRequest(RequestDto requestDto, byte[] screenshot, String healingTime, MetricsDto metricsDto) {
        try {
            MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("screenshot", this.buildScreenshotName(), RequestBody.create((MediaType)MediaType.parse((String)"image/png"), (byte[])screenshot)).addFormDataPart("dto", this.objectMapper.writeValueAsString((Object)requestDto)).addFormDataPart("metrics", this.objectMapper.writeValueAsString((Object)metricsDto)).build();
            Request request = new Request.Builder().addHeader("sessionKey", this.sessionKey).addHeader("hostProject", SystemUtils.getHostProjectName()).addHeader("healingTime", healingTime).url(this.baseUrl + "/healing").post((RequestBody)requestBody).build();
            this.okHttpClient().newCall(request).execute();
        }
        catch (Exception e) {
            log.warn("Failed to make response", (Throwable)e);
        }
    }

    public Optional<LastHealingDataDto> getLastHealingData(By locator) {
        LastHealingDataDto lastHealingDataDto = null;
        RequestDto requestDto = this.mapper.buildDto(locator);
        try {
            HttpUrl.Builder httpBuilder = HttpUrl.parse((String)this.baseUrl).newBuilder().addQueryParameter("locator", requestDto.getLocator()).addQueryParameter("className", requestDto.getClassName()).addQueryParameter("methodName", requestDto.getMethodName());
            Request request = new Request.Builder().addHeader("sessionKey", this.sessionKey).url(httpBuilder.build()).get().build();
            Response response = this.okHttpClient().newCall(request).execute();
            if (response.code() == 200) {
                String result = response.body().string();
                lastHealingDataDto = (LastHealingDataDto)this.objectMapper.readValue(result, (TypeReference)new TypeReference<LastHealingDataDto>(){});
            }
        }
        catch (Exception ex) {
            log.warn("Failed to make response", (Throwable)ex);
        }
        return Optional.ofNullable(lastHealingDataDto);
    }

    public List<Locator> imitate(HealeniumSelectorImitatorDto healeniumSelectorImitatorDto) {
        try {
            RequestBody body = RequestBody.create((MediaType)this.JSON, (String)this.objectMapper.writeValueAsString((Object)healeniumSelectorImitatorDto));
            Request request = new Request.Builder().url(this.imitateUrl).post(body).build();
            Response response = this.okHttpClient().newCall(request).execute();
            if (response.code() == 200) {
                String result = response.body().string();
                return (List)this.objectMapper.readValue(result, (TypeReference)new TypeReference<List<Locator>>(){});
            }
        }
        catch (Exception ex) {
            log.warn("Failed to make imitate response: {}", (Object)ex.getMessage());
        }
        return Collections.emptyList();
    }

    private String buildScreenshotName() {
        return "screenshot_" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("dd-MMM-yyyy-hh-mm-ss").withLocale(Locale.US)) + ".png";
    }

    public HealeniumMapper getMapper() {
        return this.mapper;
    }
}

