/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.service.impl;

import com.epam.healenium.PageAwareBy;
import com.epam.healenium.SelfHealingEngine;
import com.epam.healenium.model.HealeniumSelectorImitatorDto;
import com.epam.healenium.model.HealingCandidateDto;
import com.epam.healenium.model.LastHealingDataDto;
import com.epam.healenium.model.Locator;
import com.epam.healenium.model.MetricsDto;
import com.epam.healenium.service.HealingService;
import com.epam.healenium.treecomparing.Node;
import com.epam.healenium.treecomparing.Scored;
import com.epam.healenium.utils.StackUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.Augmenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealingServiceImpl
implements HealingService {
    private static final Logger log = LoggerFactory.getLogger(HealingServiceImpl.class);
    private final SelfHealingEngine engine;
    private final WebDriver driver;

    public HealingServiceImpl(SelfHealingEngine engine) {
        this.engine = engine;
        this.driver = engine.getWebDriver();
    }

    @Override
    public Optional<WebElement> heal(PageAwareBy pageBy, NoSuchElementException ex) {
        return this.healLocators(pageBy, null, ex.getStackTrace()).map(arg_0 -> ((WebDriver)this.driver).findElement(arg_0));
    }

    @Override
    public List<WebElement> healElements(PageAwareBy pageBy, StackTraceElement[] stackTrace, NoSuchElementException ex) {
        List<List<Node>> nodesToHeal = this.engine.findNodesToHeal(pageBy, stackTrace);
        List<WebElement> resultWebElements = this.getHealedElementsByNodes(pageBy, stackTrace, nodesToHeal);
        return Optional.of(resultWebElements).orElseThrow(() -> ex);
    }

    @Override
    public List<WebElement> saveAndHealElements(PageAwareBy pageBy, List<WebElement> pageElements, StackTraceElement[] stackTrace) {
        List<List<Node>> nodesToHeal = this.engine.findNodesToHeal(pageBy, stackTrace);
        this.engine.savePath(pageBy, pageElements, Optional.of(nodesToHeal).orElse(Collections.emptyList()));
        return Stream.concat(pageElements.stream(), this.getHealedElementsByNodes(pageBy, stackTrace, nodesToHeal).stream()).collect(Collectors.toList());
    }

    @NotNull
    private List<WebElement> getHealedElementsByNodes(PageAwareBy pageBy, StackTraceElement[] stackTrace, List<List<Node>> nodesToHeal) {
        ArrayList<WebElement> resultWebElements = new ArrayList<WebElement>();
        nodesToHeal.forEach(nodes -> this.healLocators(pageBy, (List<Node>)nodes, stackTrace).map(arg_0 -> ((WebDriver)this.driver).findElement(arg_0)).ifPresent(resultWebElements::add));
        return resultWebElements;
    }

    public Optional<By> healLocators(PageAwareBy pageBy, List<Node> nodes, StackTraceElement[] trace) {
        String pageContent = this.pageSource();
        Optional<StackTraceElement> traceElement = StackUtils.findOriginCaller(trace);
        Locator userLocator = this.engine.getClient().getMapper().byToLocator(pageBy.getBy());
        MetricsDto metricsDto = new MetricsDto().setCurrentDom(pageContent).setUserSelector(userLocator);
        Optional<List<List<Node>>> paths = traceElement.map(it -> this.engine.getClient().getLastHealingData(pageBy.getBy(), (StackTraceElement)it)).filter(Optional::isPresent).map(dto -> {
            metricsDto.setPreviousSuccessfulDom(((LastHealingDataDto)dto.get()).getPageContent());
            return ((LastHealingDataDto)dto.get()).getPaths();
        });
        List<Scored<By>> choices = nodes == null ? this.engine.findNewLocations(this.pageSource(), paths, metricsDto) : this.engine.findNewLocationsByNodes(nodes, this.pageSource(), metricsDto);
        HealingCandidateDto mainHealingCandidate = metricsDto.getMainHealingCandidate();
        if (mainHealingCandidate != null) {
            this.imitateMainCandidate(userLocator, mainHealingCandidate, choices);
        }
        String healingTime = this.engine.getHealingTime();
        Optional result = choices.stream().findFirst();
        if (!result.isPresent()) {
            log.warn("New element locators have not been found");
            double scoreCap = this.engine.getScoreCap();
            log.warn("Score property={} is bigger than healing's locator score", (Object)scoreCap);
        } else {
            Scored healed = (Scored)result.get();
            log.warn("Using healed locator: {}", result);
            byte[] screenshot = this.captureScreen((Scored<By>)healed);
            metricsDto.setHealedSelector(this.engine.getClient().getMapper().byToLocator((By)healed.getValue()));
            traceElement.ifPresent(it -> this.engine.getClient().healRequest(pageBy.getBy(), (StackTraceElement)it, pageContent, choices, (Scored<By>)healed, screenshot, healingTime, metricsDto));
        }
        return result.map(Scored::getValue);
    }

    private void imitateMainCandidate(Locator userLocator, HealingCandidateDto mainHealingCandidate, List<Scored<By>> choices) {
        Node targetNode = mainHealingCandidate.getNode();
        Double score = mainHealingCandidate.getScore();
        if (targetNode != null) {
            HealeniumSelectorImitatorDto healeniumSelectorImitator = new HealeniumSelectorImitatorDto().setUserSelector(userLocator).setTargetNode(targetNode);
            List<Locator> imitatedLocators = this.engine.getClient().imitate(healeniumSelectorImitator);
            Optional<Scored<By>> byScored = this.engine.toLocator(imitatedLocators, score);
            if (byScored.isPresent()) {
                choices.remove(0);
                choices.add(0, byScored.get());
            }
        }
    }

    private byte[] captureScreen(Scored<By> byScored) {
        WebElement element = this.driver.findElement((By)byScored.getValue());
        if (this.engine.isHealingBacklighted()) {
            JavascriptExecutor jse = (JavascriptExecutor)this.driver;
            jse.executeScript("arguments[0].style.border='3px solid red'", new Object[]{element});
        }
        WebDriver augmentedDriver = new Augmenter().augment(this.driver);
        return (byte[])((TakesScreenshot)augmentedDriver).getScreenshotAs(OutputType.BYTES);
    }

    private String pageSource() {
        if (this.driver instanceof JavascriptExecutor) {
            return ((JavascriptExecutor)this.driver).executeScript("return document.body.outerHTML;", new Object[0]).toString();
        }
        return this.driver.getPageSource();
    }
}

