/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.mapper;

import com.epam.healenium.model.HealingResultDto;
import com.epam.healenium.model.Locator;
import com.epam.healenium.model.RequestDto;
import com.epam.healenium.treecomparing.Node;
import com.epam.healenium.treecomparing.Scored;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.mapstruct.Mapper;
import org.mapstruct.ReportingPolicy;
import org.openqa.selenium.By;

@Mapper(unmappedTargetPolicy=ReportingPolicy.IGNORE)
public interface HealeniumMapper {
    default public RequestDto buildDto(By by, StackTraceElement element) {
        String[] locatorParts = by.toString().split(":", 2);
        RequestDto dto = new RequestDto().setLocator(locatorParts[1].trim()).setType(locatorParts[0].trim());
        if (element != null) {
            dto.setClassName(element.getClassName());
            dto.setMethodName(element.getMethodName());
        }
        return dto;
    }

    default public RequestDto buildDto(By by, StackTraceElement element, List<List<Node>> nodePath) {
        RequestDto dto = this.buildDto(by, element);
        dto.setNodePath(nodePath);
        return dto;
    }

    default public RequestDto buildDto(By by, StackTraceElement element, String page, List<Scored<By>> healingResults, Scored<By> selected, byte[] screenshot) {
        RequestDto dto = this.buildDto(by, element);
        dto.setPageContent(page).setResults(this.buildResultDto(healingResults)).setUsedResult(this.buildResultDto(selected)).setScreenshot(screenshot);
        return dto;
    }

    default public HealingResultDto buildResultDto(Scored<By> scored) {
        return new HealingResultDto(this.byToLocator((By)scored.getValue()), scored.getScore());
    }

    default public List<HealingResultDto> buildResultDto(Collection<Scored<By>> scored) {
        return scored.stream().map(this::buildResultDto).collect(Collectors.toList());
    }

    default public Locator byToLocator(By by) {
        String[] locatorParts = by.toString().split(":", 2);
        return new Locator(locatorParts[1].trim(), locatorParts[0].trim());
    }

    default public List<Locator> byToLocator(Collection<By> by) {
        return by.stream().map(this::byToLocator).collect(Collectors.toList());
    }
}

