/*
 * Decompiled with CFR 0.152.
 */
package com.emc.codec.encryption;

import com.emc.codec.EncodeOutputStream;
import com.emc.codec.encryption.EncryptionException;
import com.emc.codec.encryption.EncryptionMetadata;
import com.emc.codec.util.CountingOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;

public class EncryptionOutputStream
extends EncodeOutputStream<EncryptionMetadata> {
    private EncryptionMetadata metadata;
    boolean closed = false;
    private DigestOutputStream digestStream;
    private CountingOutputStream counterStream;

    public EncryptionOutputStream(OutputStream originalStream, String encodeSpec, Cipher cipher, String encryptedKey) {
        super(originalStream);
        this.metadata = new EncryptionMetadata(encodeSpec);
        this.metadata.setEncryptedKey(encryptedKey);
        this.metadata.setInitVector(cipher.getIV());
        try {
            CipherOutputStream cipherStream = new CipherOutputStream(originalStream, cipher);
            this.digestStream = new DigestOutputStream(cipherStream, MessageDigest.getInstance("SHA1"));
            this.counterStream = new CountingOutputStream(this.digestStream);
            this.out = this.counterStream;
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException("Unable to initialize digest", e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        super.close();
        this.metadata.setOriginalSize(this.counterStream.getByteCount());
        this.metadata.setOriginalDigest(this.digestStream.getMessageDigest().digest());
        this.notifyListeners();
    }

    @Override
    public EncryptionMetadata getEncodeMetadata() {
        return this.metadata;
    }
}

