/*
 * Decompiled with CFR 0.152.
 */
package com.emc.codec.encryption;

import com.emc.codec.AbstractCodec;
import com.emc.codec.CodecChain;
import com.emc.codec.EncodeInputStream;
import com.emc.codec.EncodeListener;
import com.emc.codec.EncodeOutputStream;
import com.emc.codec.EncodeStream;
import com.emc.codec.encryption.DoesNotNeedRekeyException;
import com.emc.codec.encryption.EncryptionException;
import com.emc.codec.encryption.EncryptionInputStream;
import com.emc.codec.encryption.EncryptionMetadata;
import com.emc.codec.encryption.EncryptionOutputStream;
import com.emc.codec.encryption.EncryptionUtil;
import com.emc.codec.encryption.KeyProvider;
import com.emc.codec.util.CodecUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionCodec
extends AbstractCodec<EncryptionMetadata> {
    private static final Logger log = LoggerFactory.getLogger(EncryptionCodec.class);
    public static final int PRIORITY = 1000;
    public static final String SECURE_RANDOM_INSTANCE = "SHA1PRNG";
    public static final String AES_CBC_PKCS5_CIPHER = "AES/CBC/PKCS5Padding";
    public static final String PROP_KEY_SIZE = "com.emc.codec.encryption.EncryptionCodec.keySize";
    public static final String PROP_KEY_PROVIDER = "com.emc.codec.encryption.EncryptionCodec.keyProvider";
    public static final String PROP_SECURITY_PROVIDER = "com.emc.codec.encryption.EncryptionCodec.securityProvider";
    public static final int DEFAULT_KEY_SIZE = 128;

    public static String encodeSpec(String cipherSpec) {
        return CodecUtil.getEncodeSpec("ENC", cipherSpec);
    }

    public static int getKeySize(Map<String, Object> codecProperties) {
        return CodecUtil.getCodecProperty(PROP_KEY_SIZE, codecProperties, 128);
    }

    public static void setKeySize(Map<String, Object> codecProperties, int keySize) {
        codecProperties.put(PROP_KEY_SIZE, keySize);
    }

    public static KeyProvider getKeyProvider(Map<String, Object> codecProperties) {
        return CodecUtil.getCodecProperty(PROP_KEY_PROVIDER, codecProperties, null);
    }

    public static void setKeyProvider(Map<String, Object> codecProperties, KeyProvider keyProvider) {
        codecProperties.put(PROP_KEY_PROVIDER, keyProvider);
    }

    public static Provider getSecurityProvider(Map<String, Object> codecProperties) {
        return CodecUtil.getCodecProperty(PROP_SECURITY_PROVIDER, codecProperties, null);
    }

    public static void setPropSecurityProvider(Map<String, Object> codecProperties, Provider securityProvider) {
        codecProperties.put(PROP_SECURITY_PROVIDER, securityProvider);
    }

    @Override
    public boolean canProcess(String encodeSpec) {
        if (!"ENC".equals(CodecUtil.getEncodeType(encodeSpec))) {
            return false;
        }
        String cipherSpec = EncryptionUtil.getCipherSpec(encodeSpec);
        try {
            Cipher.getInstance(cipherSpec);
            return true;
        }
        catch (Exception e) {
            log.warn("cannot process cipher " + cipherSpec, (Throwable)e);
            return false;
        }
    }

    @Override
    public String getDefaultEncodeSpec() {
        return EncryptionCodec.encodeSpec(AES_CBC_PKCS5_CIPHER);
    }

    @Override
    public int getPriority() {
        return 1000;
    }

    @Override
    public EncryptionMetadata createEncodeMetadata(String encodeSpec, Map<String, String> metaMap) {
        return new EncryptionMetadata(encodeSpec, metaMap);
    }

    @Override
    public long getDecodedSize(EncryptionMetadata encodeInfo) {
        return encodeInfo.getOriginalSize();
    }

    @Override
    public OutputStream getDecodingStream(OutputStream originalStream, EncryptionMetadata metadata, Map<String, Object> codecProperties) {
        KeyProvider keyProvider = this._getKeyProvider(codecProperties);
        Provider provider = EncryptionCodec.getSecurityProvider(codecProperties);
        return new CipherOutputStream(originalStream, this.initDecryptCipher(metadata, keyProvider, provider));
    }

    @Override
    public InputStream getDecodingStream(InputStream originalStream, EncryptionMetadata metadata, Map<String, Object> codecProperties) {
        KeyProvider keyProvider = this._getKeyProvider(codecProperties);
        Provider provider = EncryptionCodec.getSecurityProvider(codecProperties);
        return new CipherInputStream(originalStream, this.initDecryptCipher(metadata, keyProvider, provider));
    }

    @Override
    public boolean isSizePredictable() {
        return true;
    }

    @Override
    public long getEncodedSize(long originalSize, String encodeSpec, Map<String, Object> codecProperties) {
        String cipherSpec = EncryptionUtil.getCipherSpec(encodeSpec);
        Provider provider = EncryptionCodec.getSecurityProvider(codecProperties);
        SecretKey key = this.generateKey(cipherSpec, EncryptionCodec.getKeySize(codecProperties), provider);
        Cipher cipher = this.initEncryptCipher(cipherSpec, key, provider);
        long trailer = originalSize % (long)cipher.getBlockSize();
        long trunc = originalSize - trailer;
        try {
            return trunc + (long)cipher.doFinal(new byte[(int)trailer]).length;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Cipher error", e);
        }
    }

    @Override
    public EncodeOutputStream<EncryptionMetadata> getEncodingStream(OutputStream originalStream, String encodeSpec, Map<String, Object> codecProperties) {
        String cipherSpec = EncryptionUtil.getCipherSpec(encodeSpec);
        Provider provider = EncryptionCodec.getSecurityProvider(codecProperties);
        KeyProvider keyProvider = this._getKeyProvider(codecProperties);
        SecretKey key = this.generateKey(cipherSpec, EncryptionCodec.getKeySize(codecProperties), provider);
        Cipher cipher = this.initEncryptCipher(cipherSpec, key, provider);
        String encryptedKey = this.encryptKey(key, keyProvider.getMasterKey(), provider);
        EncryptionOutputStream eos = new EncryptionOutputStream(originalStream, encodeSpec, cipher, encryptedKey);
        eos.addListener(new SigningEncodeMetadataListener(keyProvider, provider));
        return eos;
    }

    @Override
    public EncodeInputStream<EncryptionMetadata> getEncodingStream(InputStream originalStream, String encodeSpec, Map<String, Object> codecProperties) {
        String cipherSpec = EncryptionUtil.getCipherSpec(encodeSpec);
        Provider provider = EncryptionCodec.getSecurityProvider(codecProperties);
        KeyProvider keyProvider = this._getKeyProvider(codecProperties);
        SecretKey key = this.generateKey(cipherSpec, EncryptionCodec.getKeySize(codecProperties), provider);
        Cipher cipher = this.initEncryptCipher(cipherSpec, key, provider);
        String encryptedKey = this.encryptKey(key, keyProvider.getMasterKey(), provider);
        EncryptionInputStream eis = new EncryptionInputStream(originalStream, encodeSpec, cipher, encryptedKey);
        eis.addListener(new SigningEncodeMetadataListener(keyProvider, provider));
        return eis;
    }

    public void rekey(Map<String, String> metaMap, Map<String, Object> codecProperties) {
        String encryptSpec = null;
        for (String spec : CodecChain.getEncodeSpecs(metaMap)) {
            if (!this.canDecode(spec)) continue;
            encryptSpec = spec;
            break;
        }
        if (encryptSpec == null) {
            throw new IllegalArgumentException("object is not encrypted");
        }
        EncryptionMetadata metadata = new EncryptionMetadata(encryptSpec, metaMap);
        this.rekey(metadata, codecProperties);
        metaMap.putAll(metadata.toMap());
    }

    public void rekey(EncryptionMetadata metadata, Map<String, Object> codecProperties) {
        KeyProvider keyProvider = EncryptionCodec.getKeyProvider(codecProperties);
        Provider provider = EncryptionCodec.getSecurityProvider(codecProperties);
        if (metadata.getMasterKeyFingerprint().equals(keyProvider.getMasterKeyFingerprint())) {
            throw new DoesNotNeedRekeyException("Object is already using the current master key");
        }
        KeyPair oldKey = keyProvider.getKey(metadata.getMasterKeyFingerprint());
        if (oldKey == null) {
            throw new EncryptionException(String.format("Master key with fingerprint %s not found", metadata.getMasterKeyFingerprint()));
        }
        SecretKey objectKey = metadata.getSecretKey((RSAPrivateKey)oldKey.getPrivate(), provider);
        metadata.setSecretKey(objectKey, keyProvider.getMasterKey().getPublic(), provider);
        metadata.setMasterKeyFingerprint(keyProvider.getMasterKeyFingerprint());
        metadata.sign((RSAPrivateKey)keyProvider.getMasterKey().getPrivate(), provider);
    }

    protected Cipher initEncryptCipher(String cipherSpec, SecretKey key, Provider provider) {
        try {
            Cipher cipher = this.createCipher(cipherSpec, provider);
            cipher.init(1, (Key)key, this.getSecureRandom(provider));
            return cipher;
        }
        catch (GeneralSecurityException e) {
            throw new EncryptionException("Error initializing cipher", e);
        }
    }

    protected Cipher initDecryptCipher(EncryptionMetadata metadata, KeyProvider keyProvider, Provider provider) {
        try {
            String cipherSpec = EncryptionUtil.getCipherSpec(metadata.getEncodeSpec());
            Cipher cipher = this.createCipher(cipherSpec, provider);
            KeyPair masterKey = keyProvider.getKey(metadata.getMasterKeyFingerprint());
            if (masterKey == null) {
                throw new EncryptionException(String.format("Could not decrypt object. no master key with ID %s found", metadata.getMasterKeyFingerprint()));
            }
            SecretKey key = metadata.getSecretKey((RSAPrivateKey)masterKey.getPrivate(), provider);
            cipher.init(2, (Key)key, new IvParameterSpec(metadata.getInitVector()));
            return cipher;
        }
        catch (GeneralSecurityException e) {
            throw new EncryptionException("Error initializing cipher", e);
        }
    }

    protected Cipher createCipher(String cipherSpec, Provider provider) {
        try {
            if (provider != null) {
                return Cipher.getInstance(cipherSpec, provider);
            }
            return Cipher.getInstance(cipherSpec);
        }
        catch (GeneralSecurityException e) {
            throw new UnsupportedOperationException("Could not get cipher instance for algorithm " + cipherSpec, e);
        }
    }

    protected SecretKey generateKey(String cipherSpec, int keySize, Provider provider) {
        String baseAlgorithm = EncryptionUtil.getBaseAlgorithm(cipherSpec);
        try {
            if (keySize > Cipher.getMaxAllowedKeyLength(cipherSpec)) {
                throw new InvalidKeyException(String.format("Key size of %d bits is larger than the maximum allowed of %d", keySize, Cipher.getMaxAllowedKeyLength(cipherSpec)));
            }
            KeyGenerator keygen = provider != null ? KeyGenerator.getInstance(baseAlgorithm, provider) : KeyGenerator.getInstance(baseAlgorithm);
            keygen.init(keySize, this.getSecureRandom(provider));
            return keygen.generateKey();
        }
        catch (GeneralSecurityException e) {
            throw new UnsupportedOperationException("Could not generate key for algorithm " + baseAlgorithm, e);
        }
    }

    public String encryptKey(SecretKey key, KeyPair masterKey, Provider provider) {
        return EncryptionUtil.encryptKey(key, provider, masterKey.getPublic());
    }

    protected KeyProvider _getKeyProvider(Map<String, Object> codecProperties) {
        KeyProvider keyProvider = EncryptionCodec.getKeyProvider(codecProperties);
        if (keyProvider == null) {
            throw new EncryptionException("no key provider specified");
        }
        return keyProvider;
    }

    protected SecureRandom getSecureRandom(Provider provider) {
        try {
            if (provider != null) {
                return SecureRandom.getInstance(SECURE_RANDOM_INSTANCE, provider);
            }
            return SecureRandom.getInstance(SECURE_RANDOM_INSTANCE);
        }
        catch (GeneralSecurityException e) {
            throw new UnsupportedOperationException("Could not get secure random instance for SHA1PRNG", e);
        }
    }

    protected class SigningEncodeMetadataListener
    implements EncodeListener<EncryptionMetadata> {
        private KeyProvider keyProvider;
        private Provider provider;

        public SigningEncodeMetadataListener(KeyProvider keyProvider, Provider provider) {
            this.keyProvider = keyProvider;
            this.provider = provider;
        }

        @Override
        public void encodeComplete(EncodeStream<EncryptionMetadata> encodeStream) {
            encodeStream.getEncodeMetadata().setMasterKeyFingerprint(this.keyProvider.getMasterKeyFingerprint());
            encodeStream.getEncodeMetadata().sign((RSAPrivateKey)this.keyProvider.getMasterKey().getPrivate(), this.provider);
        }
    }
}

