/*
 * Decompiled with CFR 0.152.
 */
package com.emc.codec.compression.lzma;

import com.emc.codec.compression.CompressionException;
import com.emc.codec.compression.CompressionOutputStream;
import com.emc.codec.compression.lzma.EncoderThread;
import com.emc.codec.compression.lzma.LzmaProfile;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class LzmaEncodeOutputStream
extends CompressionOutputStream {
    private OutputStream postPipeStream;
    private LzmaProfile compressionProfile;
    private int bufferSize;
    private PipedOutputStream outputPipe;
    private EncoderThread encoderThread;

    public LzmaEncodeOutputStream(OutputStream out, String encodeSpec, LzmaProfile compressionProfile, int bufferSize) {
        super(out, encodeSpec);
        this.compressionProfile = compressionProfile;
        this.bufferSize = bufferSize;
        this.initStreams(out);
    }

    @Override
    protected OutputStream getCompressionStream(OutputStream output) throws IOException {
        this.postPipeStream = output;
        PipedInputStream inputPipe = new PipedInputStream(this.bufferSize);
        this.outputPipe = new PipedOutputStream(inputPipe);
        this.encoderThread = new EncoderThread(this.compressionProfile, inputPipe, output);
        this.encoderThread.start();
        return this.outputPipe;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkForError();
        super.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.checkForError();
        super.write(b);
    }

    @Override
    public void write(int b) throws IOException {
        this.checkForError();
        super.write(b);
    }

    @Override
    public void close() throws IOException {
        try {
            this.outputPipe.close();
            this.encoderThread.join();
        }
        catch (InterruptedException e) {
            throw new CompressionException("interrupted while waiting for encoder thread", e);
        }
        super.close();
        this.postPipeStream.close();
        this.encoderThread = null;
    }

    protected void checkForError() {
        if (this.encoderThread != null && this.encoderThread.isErrorSet()) {
            Throwable t = this.encoderThread.getError();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new CompressionException("Compression error", t);
        }
    }
}

