/*
 * Decompiled with CFR 0.152.
 */
package com.emc.codec.compression;

import com.emc.codec.EncodeMetadata;
import com.emc.codec.compression.CompressionException;
import com.emc.codec.encryption.EncryptionException;
import com.emc.codec.encryption.EncryptionUtil;
import com.emc.codec.util.CodecUtil;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;

public class CompressionMetadata
extends EncodeMetadata {
    private long originalSize;
    private long compressedSize;
    private double compressionRatio;
    private byte[] originalDigest;

    public CompressionMetadata(String encodeSpec) {
        super(encodeSpec);
        if (!"COMP".equals(CodecUtil.getEncodeType(encodeSpec))) {
            throw new IllegalArgumentException("encodeSpec is not a compression type");
        }
    }

    public CompressionMetadata(String encodeSpec, Map<String, String> metaMap) {
        this(encodeSpec);
        String originalSizeStr = metaMap.get("x-emc-comp-uncompressed-size");
        if (originalSizeStr == null) {
            throw new CompressionException("no original size set on object.");
        }
        this.originalSize = Long.parseLong(originalSizeStr);
        String compressedSizeStr = metaMap.get("x-emc-comp-compressed-size");
        if (compressedSizeStr == null) {
            throw new CompressionException("no compressed size set on object");
        }
        this.compressedSize = Long.parseLong(compressedSizeStr);
        String compressionRatioStr = metaMap.get("x-emc-comp-compression-ratio");
        if (compressionRatioStr == null) {
            throw new CompressionException("no compression ratio set on object");
        }
        compressionRatioStr = compressionRatioStr.replaceAll("%$", "");
        this.compressionRatio = Float.parseFloat(compressionRatioStr);
        String originalDigestStr = metaMap.get("x-emc-comp-uncompressed-sha1");
        if (originalDigestStr == null) {
            throw new EncryptionException("no SHA1 digest set on object.");
        }
        this.originalDigest = DatatypeConverter.parseHexBinary((String)originalDigestStr);
    }

    @Override
    public boolean isComplete() {
        return this.originalDigest != null;
    }

    @Override
    public Map<String, String> toMap() {
        HashMap<String, String> metaMap = new HashMap<String, String>();
        if (this.isComplete()) {
            metaMap.put("x-emc-comp-uncompressed-size", "" + this.originalSize);
            metaMap.put("x-emc-comp-compressed-size", "" + this.compressedSize);
            metaMap.put("x-emc-comp-compression-ratio", String.format("%.1f%%", this.compressionRatio));
            metaMap.put("x-emc-comp-uncompressed-sha1", EncryptionUtil.toHexPadded(this.originalDigest));
        }
        return metaMap;
    }

    protected void calculateCompressionRatio() {
        if (this.originalSize > 0L && this.compressedSize > 0L) {
            this.compressionRatio = 100.0 - (double)this.compressedSize * 100.0 / (double)this.originalSize;
        }
    }

    public long getOriginalSize() {
        return this.originalSize;
    }

    public void setOriginalSize(long originalSize) {
        this.originalSize = originalSize;
        this.calculateCompressionRatio();
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public void setCompressedSize(long compressedSize) {
        this.compressedSize = compressedSize;
        this.calculateCompressionRatio();
    }

    public double getCompressionRatio() {
        return this.compressionRatio;
    }

    public byte[] getOriginalDigest() {
        return this.originalDigest;
    }

    public void setOriginalDigest(byte[] originalDigest) {
        this.originalDigest = originalDigest;
    }
}

