/*
 * Decompiled with CFR 0.152.
 */
package com.emc.codec;

import com.emc.codec.EncodeListener;
import com.emc.codec.EncodeMetadata;
import com.emc.codec.EncodeStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class EncodeInputStream<M extends EncodeMetadata>
extends FilterInputStream
implements EncodeStream<M> {
    List<EncodeListener<M>> listeners = new ArrayList<EncodeListener<M>>();
    EncodeStream prevEncodeStream;
    EncodeStream nextEncodeStream;

    public EncodeInputStream(InputStream in) {
        super(in);
        if (in instanceof EncodeInputStream) {
            this.prevEncodeStream = (EncodeStream)((Object)in);
            ((EncodeInputStream)in).nextEncodeStream = this;
        }
    }

    protected void notifyListeners() {
        for (EncodeListener<M> listener : this.listeners) {
            listener.encodeComplete(this);
        }
    }

    @Override
    public void addListener(EncodeListener<M> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(EncodeListener<M> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public EncodeStream getChainHead() {
        return this.prevEncodeStream == null ? this : this.prevEncodeStream.getChainHead();
    }

    @Override
    public EncodeStream getNext() {
        return this.nextEncodeStream;
    }
}

