/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.core.util;

import com.emarsys.core.util.Assert;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonUtils {
    public static JSONObject fromMap(Map<String, Object> map) {
        Assert.notNull(map, "Map must not be null!");
        JSONObject result = new JSONObject();
        try {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Map) {
                    result.put(key, (Object)JsonUtils.fromMap((Map)value));
                    continue;
                }
                if (value instanceof List) {
                    result.put(key, (Object)JsonUtils.fromList((List)value));
                    continue;
                }
                result.put(key, value);
            }
        }
        catch (JSONException je) {
            throw new IllegalArgumentException(je);
        }
        return result;
    }

    public static JSONArray fromList(List<Object> list) {
        Assert.notNull(list, "List must not be null!");
        JSONArray result = new JSONArray();
        for (Object item : list) {
            if (item instanceof List) {
                result.put((Object)JsonUtils.fromList((List)item));
                continue;
            }
            if (item instanceof Map) {
                result.put((Object)JsonUtils.fromMap((Map)item));
                continue;
            }
            result.put(item);
        }
        return result;
    }

    public static JSONObject merge(JSONObject ... jsonObjects) {
        JsonUtils.validateArgument(jsonObjects);
        JSONObject result = new JSONObject();
        for (JSONObject jsonObject : jsonObjects) {
            if (jsonObject == null) continue;
            Iterator iterator = jsonObject.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                try {
                    result.put(key, jsonObject.get(key));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static Map<String, String> toFlatMap(JSONObject jsonObject) {
        Assert.notNull(jsonObject, "JsonObject must not be null!");
        HashMap<String, String> result = new HashMap<String, String>();
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            try {
                String key = (String)iterator.next();
                String value = jsonObject.getString(key);
                result.put(key, value);
            }
            catch (JSONException jSONException) {}
        }
        return result;
    }

    private static void validateArgument(JSONObject[] jsonObjects) {
        if (jsonObjects.length == 0) {
            throw new IllegalArgumentException("Argument must not be empty array!");
        }
        int nullCount = 0;
        for (JSONObject jsonObject : jsonObjects) {
            if (jsonObject != null) continue;
            ++nullCount;
        }
        if (nullCount == jsonObjects.length) {
            throw new IllegalArgumentException("Argument must contain at least one not null element!");
        }
    }
}

