/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.core.request.model;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import com.emarsys.core.database.helper.CoreDbHelper;
import com.emarsys.core.database.repository.AbstractSqliteRepository;
import com.emarsys.core.request.model.RequestMethod;
import com.emarsys.core.request.model.RequestModel;
import com.emarsys.core.util.log.CoreTopic;
import com.emarsys.core.util.log.EMSLogger;
import com.emarsys.core.util.serialization.SerializationException;
import com.emarsys.core.util.serialization.SerializationUtils;
import java.util.HashMap;
import java.util.Map;

public class RequestModelRepository
extends AbstractSqliteRepository<RequestModel> {
    public RequestModelRepository(Context context) {
        super("request", new CoreDbHelper(context));
    }

    @Override
    protected ContentValues contentValuesFromItem(RequestModel item) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("request_id", item.getId());
        contentValues.put("method", item.getMethod().name());
        contentValues.put("url", item.getUrl().toString());
        contentValues.put("headers", SerializationUtils.serializableToBlob(item.getHeaders()));
        contentValues.put("payload", SerializationUtils.serializableToBlob(item.getPayload()));
        contentValues.put("timestamp", Long.valueOf(item.getTimestamp()));
        contentValues.put("ttl", Long.valueOf(item.getTtl()));
        return contentValues;
    }

    @Override
    protected RequestModel itemFromCursor(Cursor cursor) {
        String requestId = cursor.getString(cursor.getColumnIndex("request_id"));
        RequestMethod method = RequestMethod.valueOf(cursor.getString(cursor.getColumnIndex("method")));
        String url = cursor.getString(cursor.getColumnIndex("url"));
        HashMap<String, String> headers = new HashMap();
        try {
            headers = (Map)SerializationUtils.blobToSerializable(cursor.getBlob(cursor.getColumnIndex("headers")));
        }
        catch (SerializationException | ClassCastException e) {
            EMSLogger.log(CoreTopic.UTIL, "Exception: %s", e);
        }
        HashMap<String, Object> payload = new HashMap();
        try {
            payload = (Map)SerializationUtils.blobToSerializable(cursor.getBlob(cursor.getColumnIndex("payload")));
        }
        catch (SerializationException | ClassCastException e) {
            EMSLogger.log(CoreTopic.UTIL, "Exception: %s", e);
        }
        long timeStamp = cursor.getLong(cursor.getColumnIndex("timestamp"));
        long ttl = cursor.getLong(cursor.getColumnIndex("ttl"));
        return new RequestModel(url, method, payload, headers, timeStamp, ttl, requestId);
    }
}

