/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.core.notification;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.support.annotation.RequiresApi;
import android.support.v4.app.NotificationManagerCompat;
import com.emarsys.core.notification.ChannelSettings;
import com.emarsys.core.util.Assert;
import java.util.ArrayList;
import java.util.List;

public class NotificationManagerProxy {
    private final NotificationManagerCompat notificationManagerCompat;
    private final NotificationManager notificationManager;

    public NotificationManagerProxy(NotificationManager notificationManager, NotificationManagerCompat notificationManagerCompat) {
        Assert.notNull(notificationManager, "NotificationManager must not be null!");
        Assert.notNull(notificationManagerCompat, "NotificationManagerCompat must not be null!");
        this.notificationManagerCompat = notificationManagerCompat;
        this.notificationManager = notificationManager;
    }

    public boolean areNotificationsEnabled() {
        return this.notificationManagerCompat.areNotificationsEnabled();
    }

    public int getImportance() {
        return this.notificationManagerCompat.getImportance();
    }

    @RequiresApi(api=26)
    public List<ChannelSettings> getNotificationChannels() {
        ArrayList<ChannelSettings> channelSettings = new ArrayList<ChannelSettings>();
        List notificationChannels = this.notificationManager.getNotificationChannels();
        for (NotificationChannel notificationChannel : notificationChannels) {
            channelSettings.add(new ChannelSettings(notificationChannel.getId(), notificationChannel.getImportance(), notificationChannel.canBypassDnd(), notificationChannel.canShowBadge(), notificationChannel.shouldVibrate(), notificationChannel.shouldShowLights()));
        }
        return channelSettings;
    }
}

