/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.core.notification;

import com.emarsys.core.util.Assert;

public class ChannelSettings {
    private final String channelId;
    private final int importance;
    private final boolean canBypassDnd;
    private final boolean canShowBadge;
    private final boolean shouldVibrate;
    private final boolean shouldShowLights;

    public ChannelSettings(String channelId, int importance, boolean canBypassDnd, boolean canShowBadge, boolean shouldVibrate, boolean shouldShowLights) {
        Assert.notNull(channelId, "ChannelId must not be null!");
        this.channelId = channelId;
        this.importance = importance;
        this.canBypassDnd = canBypassDnd;
        this.canShowBadge = canShowBadge;
        this.shouldVibrate = shouldVibrate;
        this.shouldShowLights = shouldShowLights;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public int getImportance() {
        return this.importance;
    }

    public boolean isCanBypassDnd() {
        return this.canBypassDnd;
    }

    public boolean isCanShowBadge() {
        return this.canShowBadge;
    }

    public boolean isShouldVibrate() {
        return this.shouldVibrate;
    }

    public boolean isShouldShowLights() {
        return this.shouldShowLights;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChannelSettings that = (ChannelSettings)o;
        if (this.importance != that.importance) {
            return false;
        }
        if (this.canBypassDnd != that.canBypassDnd) {
            return false;
        }
        if (this.canShowBadge != that.canShowBadge) {
            return false;
        }
        if (this.shouldVibrate != that.shouldVibrate) {
            return false;
        }
        if (this.shouldShowLights != that.shouldShowLights) {
            return false;
        }
        return this.channelId != null ? this.channelId.equals(that.channelId) : that.channelId == null;
    }

    public int hashCode() {
        int result = this.channelId != null ? this.channelId.hashCode() : 0;
        result = 31 * result + this.importance;
        result = 31 * result + (this.canBypassDnd ? 1 : 0);
        result = 31 * result + (this.canShowBadge ? 1 : 0);
        result = 31 * result + (this.shouldVibrate ? 1 : 0);
        result = 31 * result + (this.shouldShowLights ? 1 : 0);
        return result;
    }

    public String toString() {
        return "ChannelSettings{channelId='" + this.channelId + '\'' + ", importance=" + this.importance + ", canBypassDnd=" + this.canBypassDnd + ", canShowBadge=" + this.canShowBadge + ", shouldVibrate=" + this.shouldVibrate + ", shouldShowLights=" + this.shouldShowLights + '}';
    }
}

