/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.core.activity;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.emarsys.core.activity.ActivityLifecycleAction;
import com.emarsys.core.util.Assert;
import java.util.ArrayList;
import java.util.List;

public class ActivityLifecycleWatchdog
implements Application.ActivityLifecycleCallbacks {
    private Activity currentActivity;
    private final ActivityLifecycleAction[] applicationStartActions;
    private final ActivityLifecycleAction[] activityCreatedActions;
    private List<ActivityLifecycleAction> triggerOnActivityActions;

    public ActivityLifecycleWatchdog(ActivityLifecycleAction[] applicationStartActions, ActivityLifecycleAction[] activityCreatedActions) {
        this.applicationStartActions = this.initializeActionsIfNull(applicationStartActions);
        this.activityCreatedActions = this.initializeActionsIfNull(activityCreatedActions);
        Assert.elementsNotNull(this.applicationStartActions, "ApplicationStartActions must not contain null elements!");
        Assert.elementsNotNull(this.activityCreatedActions, "ActivityCreatedActions must not contain null elements!");
        this.triggerOnActivityActions = new ArrayList<ActivityLifecycleAction>();
    }

    public void addTriggerOnActivityAction(ActivityLifecycleAction triggerOnActivityAction) {
        this.triggerOnActivityActions.add(triggerOnActivityAction);
        if (this.currentActivity != null) {
            this.triggerOnActivity();
        }
    }

    public ActivityLifecycleAction[] getApplicationStartActions() {
        return this.applicationStartActions;
    }

    public ActivityLifecycleAction[] getActivityCreatedActions() {
        return this.activityCreatedActions;
    }

    public List<ActivityLifecycleAction> getTriggerOnActivityActions() {
        return this.triggerOnActivityActions;
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        for (ActivityLifecycleAction action : this.activityCreatedActions) {
            action.execute(activity);
        }
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        if (this.currentActivity == null) {
            for (ActivityLifecycleAction action : this.applicationStartActions) {
                action.execute(activity);
            }
        }
        this.currentActivity = activity;
        this.triggerOnActivity();
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
        if (this.currentActivity == activity) {
            this.currentActivity = null;
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    private void triggerOnActivity() {
        for (int i = this.triggerOnActivityActions.size() - 1; i >= 0; --i) {
            ActivityLifecycleAction action = this.triggerOnActivityActions.remove(i);
            action.execute(this.currentActivity);
        }
    }

    private ActivityLifecycleAction[] initializeActionsIfNull(ActivityLifecycleAction[] actions) {
        return actions != null ? actions : new ActivityLifecycleAction[]{};
    }
}

