package com.emarsys.core.notification;

import com.emarsys.core.util.Assert;

public class ChannelSettings {
    private final String channelId;

    private final int importance;

    private final boolean canBypassDnd;

    private final boolean canShowBadge;

    private final boolean shouldVibrate;

    private final boolean shouldShowLights;

    public ChannelSettings(String channelId, int importance, boolean canBypassDnd, boolean canShowBadge, boolean shouldVibrate, boolean shouldShowLights) {
        Assert.notNull(channelId, "ChannelId must not be null!");

        this.channelId = channelId;
        this.importance = importance;
        this.canBypassDnd = canBypassDnd;
        this.canShowBadge = canShowBadge;
        this.shouldVibrate = shouldVibrate;
        this.shouldShowLights = shouldShowLights;
    }

    public String getChannelId() {
        return channelId;
    }

    public int getImportance() {
        return importance;
    }

    public boolean isCanBypassDnd() {
        return canBypassDnd;
    }

    public boolean isCanShowBadge() {
        return canShowBadge;
    }

    public boolean isShouldVibrate() {
        return shouldVibrate;
    }

    public boolean isShouldShowLights() {
        return shouldShowLights;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ChannelSettings that = (ChannelSettings) o;

        if (importance != that.importance) return false;
        if (canBypassDnd != that.canBypassDnd) return false;
        if (canShowBadge != that.canShowBadge) return false;
        if (shouldVibrate != that.shouldVibrate) return false;
        if (shouldShowLights != that.shouldShowLights) return false;
        return channelId != null ? channelId.equals(that.channelId) : that.channelId == null;
    }

    @Override
    public int hashCode() {
        int result = channelId != null ? channelId.hashCode() : 0;
        result = 31 * result + importance;
        result = 31 * result + (canBypassDnd ? 1 : 0);
        result = 31 * result + (canShowBadge ? 1 : 0);
        result = 31 * result + (shouldVibrate ? 1 : 0);
        result = 31 * result + (shouldShowLights ? 1 : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ChannelSettings{" +
                "channelId='" + channelId + '\'' +
                ", importance=" + importance +
                ", canBypassDnd=" + canBypassDnd +
                ", canShowBadge=" + canShowBadge +
                ", shouldVibrate=" + shouldVibrate +
                ", shouldShowLights=" + shouldShowLights +
                '}';
    }
}
