/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.core.validate;

import com.emarsys.core.util.Assert;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonObjectValidator {
    private final JSONObject json;
    private final List<String> errors;

    public static JsonObjectValidator from(JSONObject jsonObject) {
        Assert.notNull(jsonObject, "JsonObject must not be null!");
        return new JsonObjectValidator(jsonObject);
    }

    private JsonObjectValidator(JSONObject json) {
        this.json = json;
        this.errors = new ArrayList<String>();
    }

    public JsonObjectValidator hasField(String fieldName) {
        Assert.notNull(fieldName, "FieldName must not be null!");
        if (!this.json.has(fieldName)) {
            this.errors.add(String.format("Missing field: '%s'", fieldName));
        }
        return this;
    }

    public JsonObjectValidator hasFieldWithType(String fieldName, Class fieldType) {
        Assert.notNull(fieldName, "FieldName must not be null!");
        Assert.notNull(fieldType, "FieldType must not be null!");
        if (!this.json.has(fieldName)) {
            this.errors.add(String.format("Missing field: '%s' with type: %s", fieldName, fieldType));
        } else {
            try {
                Object value = this.json.get(fieldName);
                if (fieldType != value.getClass()) {
                    this.errors.add(String.format("Type mismatch for key: '%s', expected type: %s, but was: %s", fieldName, fieldType, value.getClass()));
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return this;
    }

    public List<String> validate() {
        return this.errors;
    }
}

